/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core;

import com.tandbergtv.workflow.auth.domain.IProtectionKeyAware;
import com.tandbergtv.workflow.auth.domain.ProtectionKey;
import com.tandbergtv.workflow.core.AutomaticTaskNode;
import com.tandbergtv.workflow.core.GraphElementAnnotation;
import com.tandbergtv.workflow.core.NodeGroup;
import com.tandbergtv.workflow.core.Selector;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.graph.DefaultExceptionHandler;
import com.tandbergtv.workflow.core.graph.Graph;
import com.tandbergtv.workflow.core.graph.IAnnotatedElement;
import com.tandbergtv.workflow.core.graph.NodeVisitor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;
import org.jbpm.file.def.FileDefinition;
import org.jbpm.file.def.WorkflowFileDefinition;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.DelegationException;
import org.jbpm.graph.def.ExceptionHandler;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.node.Fork;
import org.jbpm.graph.node.Join;
import org.jbpm.graph.node.StartState;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.jpdl.xml.Parsable;
import org.jbpm.module.def.ModuleDefinition;
import org.jbpm.taskmgmt.def.Task;

public class WorkflowTemplate
extends ProcessDefinition
implements Graph,
IProtectionKeyAware,
IAnnotatedElement,
Parsable {
    private static final long serialVersionUID = 5496751233335662922L;
    private Set<ProtectionKey> protectionKeys = new HashSet<ProtectionKey>();
    private Set<Selector> selectorKeys = new HashSet<Selector>();
    private Date createDate;
    private static final String ANNOTATION_PREFIX = "@";

    public Date getCreateDate() {
        return this.createDate;
    }

    @Override
    public Set<ProtectionKey> getProtectionKeys() {
        return this.protectionKeys;
    }

    public void setProtectionKeys(Set<ProtectionKey> protectionKeys) {
        this.protectionKeys = protectionKeys;
    }

    @Override
    public void addProtectionKey(ProtectionKey protectionKey) {
        this.protectionKeys.add(protectionKey);
    }

    public ModuleDefinition addDefinition(ModuleDefinition moduleDefinition) {
        try {
            Field field = ModuleDefinition.class.getDeclaredField("name");
            field.setAccessible(true);
            field.set(moduleDefinition, moduleDefinition.getClass().getName());
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return super.addDefinition(moduleDefinition);
    }

    public List<Node> getNodes() {
        return super.getNodes();
    }

    public FileDefinition getFileDefinition() {
        return (FileDefinition)this.getDefinition(WorkflowFileDefinition.class);
    }

    public String getFullName() {
        return String.valueOf(this.name) + " - v" + this.version;
    }

    public boolean hasAsyncMessages() {
        for (Node node : this.getNodes()) {
            NodeGroup superstate;
            AutomaticTaskNode tasknode;
            if (!(node instanceof AutomaticTaskNode ? (tasknode = (AutomaticTaskNode)AutomaticTaskNode.class.cast(node)).getMessage() != null : node instanceof NodeGroup && (superstate = (NodeGroup)node).hasAsyncMessages())) continue;
            return true;
        }
        return false;
    }

    public Collection<TaskVariable> getStartTaskVariables() {
        Task task = this.getTaskMgmtDefinition().getStartTask();
        if (task != null) {
            return task.getTaskController().getVariableAccesses();
        }
        return new ArrayList<TaskVariable>();
    }

    @Override
    public void depthFirstTraversal(NodeVisitor visitor) {
        Queue<Node> roots = this.getRoots();
        HashMap<Node, Boolean> traversed = new HashMap<Node, Boolean>();
        for (Node root : roots) {
            this.depthFirstTraversal(root, traversed, visitor);
        }
    }

    private void depthFirstTraversal(Node node, Map<Node, Boolean> traversed, NodeVisitor visitor) {
        traversed.put(node, true);
        visitor.visit(node);
        List transitions = node.getLeavingTransitions();
        if (transitions == null) {
            return;
        }
        for (Transition t : transitions) {
            Boolean visited;
            Node destination = t.getTo();
            if (destination.getSuperState() != null) {
                destination = destination.getSuperState();
            }
            if (Boolean.TRUE.equals(visited = traversed.get(destination))) continue;
            this.depthFirstTraversal(destination, traversed, visitor);
        }
    }

    @Override
    public void breadthFirstTraversal(NodeVisitor visitor) {
        LinkedList<Node> queue = new LinkedList<Node>();
        HashMap<Node, Boolean> traversed = new HashMap<Node, Boolean>();
        Node root = this.getStartState();
        traversed.put(root, true);
        queue.add(root);
        while (!queue.isEmpty()) {
            Node node = (Node)queue.remove(0);
            if (node instanceof Fork) {
                this.depthFirstTraversal2(node, queue, traversed, visitor);
                continue;
            }
            visitor.visit(node);
            List transitions = node.getLeavingTransitions();
            if (transitions == null) continue;
            for (Transition transition : transitions) {
                Boolean visited;
                Node destination = transition.getTo();
                if (destination.getSuperState() != null) {
                    destination = destination.getSuperState();
                }
                if (Boolean.TRUE.equals(visited = (Boolean)traversed.get(destination))) continue;
                traversed.put(destination, true);
                queue.add(destination);
            }
        }
    }

    private void depthFirstTraversal2(Node node, List<Node> queue, Map<Node, Boolean> traversed, NodeVisitor visitor) {
        if (node instanceof Join) {
            if (!queue.contains(node)) {
                queue.add(0, node);
            }
            return;
        }
        traversed.put(node, true);
        visitor.visit(node);
        List transitions = node.getLeavingTransitions();
        if (transitions == null) {
            return;
        }
        for (Transition t : transitions) {
            Boolean visited;
            Node destination = t.getTo();
            if (destination.getSuperState() != null) {
                destination = destination.getSuperState();
            }
            if (Boolean.TRUE.equals(visited = traversed.get(destination))) continue;
            this.depthFirstTraversal2(destination, queue, traversed, visitor);
        }
    }

    @Override
    public Queue<Node> getRoots() {
        LinkedList<Node> roots = new LinkedList<Node>();
        roots.add(this.getStartState());
        for (Node node : this.nodes) {
            Set transitions;
            if (node instanceof StartState || (transitions = node.getArrivingTransitions()) != null && !transitions.isEmpty()) continue;
            roots.add(node);
        }
        return roots;
    }

    public Set<Selector> getSelectorKeys() {
        return this.selectorKeys;
    }

    public void addSelectorKey(Selector selector) {
        selector.setTemplate(this);
        this.selectorKeys.add(selector);
    }

    public void removeSelectorKey(Selector selector) {
        this.selectorKeys.remove(selector);
    }

    public void removeSelectorKeys() {
        this.selectorKeys.clear();
    }

    public void raiseException(Throwable exception, ExecutionContext context) throws DelegationException {
        if (this.exceptionHandlers == null || this.exceptionHandlers.isEmpty()) {
            this.addExceptionHandler(new DefaultExceptionHandler());
        }
        try {
            ExceptionHandler exceptionHandler = this.findExceptionHandler(exception);
            if (exceptionHandler != null) {
                context.setException(exception);
                exceptionHandler.handleException(context);
            }
        }
        catch (Throwable t) {
            throw new DelegationException(t, context);
        }
    }

    public void read(Element root, JpdlXmlReader jpdlReader) {
        Element e = root.element("description");
        if (e == null) {
            return;
        }
        Matcher m = Pattern.compile("\\@.*\\(.*\\)").matcher(e.getText());
        while (m.find()) {
            this.addAnnotation(m.group().trim());
        }
    }

    public void write(Element element) {
    }

    @Override
    public Collection<String> getAnnotations() {
        ArrayList<String> annotations = new ArrayList<String>();
        if (!this.hasActions()) {
            return annotations;
        }
        for (Action action : this.actions.values()) {
            if (!(action instanceof GraphElementAnnotation)) continue;
            String type = ((GraphElementAnnotation)((Object)GraphElementAnnotation.class.cast(action))).getAnnotation();
            annotations.add(type);
        }
        return annotations;
    }

    @Override
    public Collection<String> getAnnotations(String annotationType) {
        ArrayList<String> annotations = new ArrayList<String>();
        if (!this.hasActions()) {
            return annotations;
        }
        for (Action action : this.actions.values()) {
            String type;
            if (!(action instanceof GraphElementAnnotation) || !(type = ((GraphElementAnnotation)((Object)GraphElementAnnotation.class.cast(action))).getAnnotation()).startsWith(ANNOTATION_PREFIX + annotationType + "(")) continue;
            annotations.add(type);
        }
        return annotations;
    }

    protected void addAnnotation(String annotation) {
        this.addAction((Action)new GraphElementAnnotation(annotation));
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof WorkflowTemplate)) {
            return false;
        }
        return this.getId() == ((WorkflowTemplate)WorkflowTemplate.class.cast(o)).getId();
    }

    public int hashCode() {
        return Long.valueOf(this.getId()).hashCode();
    }

    public String toString() {
        String string = this.getFullName();
        if (this.getId() != 0L) {
            return "[" + this.getId() + "] " + string;
        }
        return string;
    }
}

