/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.pluginmanager;

import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceEvent;
import com.tandbergtv.workflow.core.service.ServiceEvents;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.pluginmanager.PluginManagement;
import com.tandbergtv.workflow.pluginmanager.entities.FailureDescriptor;
import com.tandbergtv.workflow.pluginmanager.entities.ResourceGroupDescriptor;
import com.tandbergtv.workflow.pluginmanager.entities.ResourceTypeDescriptor;
import com.tandbergtv.workflow.pluginmanager.entities.WatchPointDescriptor;
import com.tandbergtv.workflow.pluginmanager.event.PluginChangeEvent;
import com.tandbergtv.workflow.pluginmanager.event.ResourceGroupDescriptorChangeEvent;
import com.tandbergtv.workflow.pluginmanager.event.ResourceTypeDescriptorChangeEvent;
import com.tandbergtv.workflow.pluginmanager.internal.PluginChangeHandler;
import com.tandbergtv.workflow.pluginmanager.internal.PluginChangeResult;
import com.tandbergtv.workflow.pluginmanager.internal.PluginExtensionHandler;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.IntegrityCheckReport;
import org.java.plugin.registry.PluginRegistry;

public class WatchPointPluginManager
implements PluginManagement,
IColleague {
    private static final Logger logger = Logger.getLogger(WatchPointPluginManager.class);
    private static final String SERVICE_NAME = "Plugin Management";
    private static final String SCHEDULER_NAME = "plugin-changeEvents";
    private static final long POLL_TIME = 25000L;
    private PluginManager pluginManager;
    private Map<String, ResourceTypeDescriptor> resTypeDescriptors = new Hashtable<String, ResourceTypeDescriptor>();
    private Map<String, ResourceGroupDescriptor> resGroupDescriptors = new Hashtable<String, ResourceGroupDescriptor>();
    private List<FailureDescriptor> failedDescriptors = new ArrayList<FailureDescriptor>();
    private List<FailureDescriptor> failedRGDescriptors = new ArrayList<FailureDescriptor>();
    private Map<String, FailureDescriptor> missingRGDescriptors = new HashMap<String, FailureDescriptor>();
    private Map<String, FailureDescriptor> unacceptedRGDescriptors = new HashMap<String, FailureDescriptor>();
    private int numOfLicResTypes;
    private ISchedulerService<Void> pluginChangeScheduler = null;
    private final List<PluginChangeEvent> pendingEvents;
    private PluginExtensionHandler extensionHandler;

    public WatchPointPluginManager(PluginManager pluginmanager, int max) {
        this.pluginManager = pluginmanager;
        this.numOfLicResTypes = max;
        this.pendingEvents = Collections.synchronizedList(new ArrayList());
    }

    private void loadResourceTypeDescriptors(IntegrityCheckReport report) {
        logger.debug((Object)"Loading the Resource Type Descriptors...");
        PluginRegistry registry = this.pluginManager.getRegistry();
        ExtensionPoint rtPoint = registry.getExtensionPoint("com.tandbergtv.workflow", "resourcetype");
        for (Extension extension : rtPoint.getAvailableExtensions()) {
            WatchPointDescriptor descriptor = this.extensionHandler.buildDescriptor(this.pluginManager, extension, report);
            if (descriptor instanceof ResourceTypeDescriptor) {
                ResourceTypeDescriptor typeDescriptor = (ResourceTypeDescriptor)descriptor;
                String systemId = typeDescriptor.getSystemId();
                if (this.resTypeDescriptors.containsKey(systemId)) {
                    ResourceTypeDescriptor other = this.resTypeDescriptors.get(systemId);
                    if (typeDescriptor.compareTo(other) < 0) {
                        this.resTypeDescriptors.put(systemId, typeDescriptor);
                        typeDescriptor = other;
                    }
                    descriptor = this.extensionHandler.buildDescriptorForDuplicateKey(typeDescriptor);
                } else {
                    this.resTypeDescriptors.put(systemId, typeDescriptor);
                }
            }
            if (!(descriptor instanceof FailureDescriptor)) continue;
            FailureDescriptor failedDescriptor = (FailureDescriptor)descriptor;
            this.failedDescriptors.add(failedDescriptor);
        }
        this.unregisterPlugins(this.failedDescriptors);
        logger.debug((Object)("Finished loading: " + this.resTypeDescriptors.size() + " plugins at startup."));
    }

    private void loadResourceGroupDescriptors(IntegrityCheckReport report) {
        logger.debug((Object)"Loading Resource Group Descriptors...");
        PluginRegistry registry = this.pluginManager.getRegistry();
        ExtensionPoint rtPoint = registry.getExtensionPoint("com.tandbergtv.workflow", "resourcegroup");
        for (Extension extension : rtPoint.getAvailableExtensions()) {
            WatchPointDescriptor descriptor = this.extensionHandler.buildDescriptor(this.pluginManager, extension, report);
            if (descriptor instanceof ResourceGroupDescriptor) {
                ResourceGroupDescriptor groupDescriptor = (ResourceGroupDescriptor)descriptor;
                logger.debug((Object)("Parsed Res Grp Descriptor: " + groupDescriptor.toString()));
                String name = groupDescriptor.getName();
                if (this.resGroupDescriptors.containsKey(name)) {
                    descriptor = this.extensionHandler.buildDescriptorForDuplicateKey(groupDescriptor);
                } else {
                    this.resGroupDescriptors.put(name, groupDescriptor);
                }
            }
            if (!(descriptor instanceof FailureDescriptor)) continue;
            FailureDescriptor failedDescriptor = (FailureDescriptor)descriptor;
            logger.debug((Object)("Failure Descriptor: " + failedDescriptor.toString()));
            this.failedRGDescriptors.add(failedDescriptor);
        }
        this.unregisterPlugins(this.failedRGDescriptors);
        logger.debug((Object)("Finished loading " + this.resGroupDescriptors.size() + " Resource Group Descriptors..."));
    }

    private void unregisterPlugins(List<FailureDescriptor> failureDescriptors) {
        if (failureDescriptors.size() > 0) {
            String[] failedPlugins = new String[failureDescriptors.size()];
            int i = 0;
            while (i < failureDescriptors.size()) {
                failedPlugins[i] = failureDescriptors.get(i).getPluginId();
                ++i;
            }
            this.pluginManager.getRegistry().unregister(failedPlugins);
            logger.debug((Object)("Found : " + failureDescriptors.size() + " invalid plugins."));
        }
    }

    private void checkLicense() {
        if (this.numOfLicResTypes >= this.resTypeDescriptors.size()) {
            return;
        }
        ArrayList<ResourceTypeDescriptor> descriptors = new ArrayList<ResourceTypeDescriptor>();
        descriptors.addAll(this.resTypeDescriptors.values());
        Collections.sort(descriptors);
        ArrayList<String> failedPlugins = new ArrayList<String>();
        int i = 0;
        while (i < descriptors.size()) {
            ResourceTypeDescriptor descriptor = (ResourceTypeDescriptor)descriptors.get(i);
            boolean licensed = i < this.numOfLicResTypes;
            descriptor.setLicensed(i < this.numOfLicResTypes);
            String msg = licensed ? null : "The Plugin for Resource Type: " + descriptor.getName() + "[" + descriptor.getSystemId() + "] is invalid due to a limited number of licenses: " + this.numOfLicResTypes;
            descriptor.setSummaryMessage(msg);
            if (!licensed) {
                failedPlugins.add(descriptor.getPluginId());
            }
            ++i;
        }
        PluginRegistry registry = this.pluginManager.getRegistry();
        if (failedPlugins.size() > 0) {
            registry.unregister(failedPlugins.toArray(new String[0]));
            logger.debug((Object)("Found : " + failedPlugins.size() + " invalid plugins due to a limited license."));
        }
    }

    @Override
    public synchronized ResourceTypeDescriptor getResourceTypeDescriptor(String systemId) {
        ResourceTypeDescriptor result = null;
        ResourceTypeDescriptor descriptor = this.resTypeDescriptors.get(systemId);
        if (descriptor != null) {
            result = (ResourceTypeDescriptor)descriptor.clone();
        }
        return result;
    }

    @Override
    public synchronized List<ResourceTypeDescriptor> getResourceTypeDescriptors() {
        ArrayList<ResourceTypeDescriptor> result = new ArrayList<ResourceTypeDescriptor>();
        for (ResourceTypeDescriptor descriptor : this.resTypeDescriptors.values()) {
            if (!descriptor.isLicensed()) continue;
            ResourceTypeDescriptor clone = (ResourceTypeDescriptor)descriptor.clone();
            result.add(clone);
        }
        return result;
    }

    @Override
    public synchronized List<ResourceGroupDescriptor> getResourceGroupDescriptors() {
        ArrayList<ResourceGroupDescriptor> result = new ArrayList<ResourceGroupDescriptor>();
        for (ResourceGroupDescriptor descriptor : this.resGroupDescriptors.values()) {
            result.add((ResourceGroupDescriptor)descriptor.clone());
        }
        return result;
    }

    @Override
    public synchronized ResourceGroupDescriptor getResourceGroupDescriptor(String name) {
        if (this.resGroupDescriptors != null && this.resGroupDescriptors.containsKey(name)) {
            return (ResourceGroupDescriptor)this.resGroupDescriptors.get(name).clone();
        }
        return null;
    }

    @Override
    public synchronized List<FailureDescriptor> getFailureDescriptors() {
        ArrayList<FailureDescriptor> result = new ArrayList<FailureDescriptor>();
        for (FailureDescriptor descriptor : this.failedDescriptors) {
            FailureDescriptor clone = (FailureDescriptor)descriptor.clone();
            result.add(clone);
        }
        return result;
    }

    @Override
    public synchronized List<ResourceTypeDescriptor> getNonLicensedDescriptors() {
        ArrayList<ResourceTypeDescriptor> result = new ArrayList<ResourceTypeDescriptor>();
        for (ResourceTypeDescriptor descriptor : this.resTypeDescriptors.values()) {
            if (descriptor.isLicensed()) continue;
            result.add((ResourceTypeDescriptor)descriptor.clone());
        }
        return result;
    }

    @Override
    public synchronized ResourceTypeDescriptor getNonLicensedDescriptor(String systemId) {
        ResourceTypeDescriptor result = null;
        ResourceTypeDescriptor descriptor = this.resTypeDescriptors.get(systemId);
        if (descriptor != null && !descriptor.isLicensed()) {
            result = (ResourceTypeDescriptor)descriptor.clone();
        }
        return result;
    }

    @Override
    public synchronized List<FailureDescriptor> getFailedResourceGroupDescriptors() {
        return this.clone(this.failedRGDescriptors);
    }

    @Override
    public synchronized List<FailureDescriptor> getMissingResourceGroups() {
        return this.clone(this.missingRGDescriptors.values());
    }

    @Override
    public synchronized List<FailureDescriptor> getUnacceptedResourceGroupDescriptors() {
        return this.clone(this.unacceptedRGDescriptors.values());
    }

    private List<FailureDescriptor> clone(Collection<FailureDescriptor> descriptors) {
        ArrayList<FailureDescriptor> result = new ArrayList<FailureDescriptor>();
        for (FailureDescriptor descriptor : descriptors) {
            FailureDescriptor clone = (FailureDescriptor)descriptor.clone();
            result.add(clone);
        }
        return result;
    }

    @Override
    public synchronized void addMissingResourceTypeDescriptor(ResourceType resourceType) {
        FailureDescriptor descriptor2;
        String systemId = resourceType.getSystemId();
        String name = resourceType.getName();
        for (FailureDescriptor descriptor2 : this.failedDescriptors) {
            if (!systemId.equals(descriptor2.getId())) continue;
            return;
        }
        descriptor2 = new FailureDescriptor();
        descriptor2.setId(systemId);
        descriptor2.setName(name);
        String msg = "The Plugin for Resource Type: " + name + "[" + systemId + "] is missing or is invalid.";
        descriptor2.setSummaryMessage(msg);
        this.failedDescriptors.add(descriptor2);
    }

    @Override
    public synchronized void notifyMissingResourceGroup(String name, String systemID) {
        logger.debug((Object)("Missing Resource Group | Name: " + name + " System ID: " + systemID));
        FailureDescriptor failureDescriptor = this.missingRGDescriptors.get(name);
        if (failureDescriptor == null) {
            failureDescriptor = new FailureDescriptor();
            failureDescriptor.setId(systemID);
            failureDescriptor.setName(name);
            failureDescriptor.addErrorMessage("Plugin is missing.");
            this.missingRGDescriptors.put(name, failureDescriptor);
        }
    }

    @Override
    public synchronized void notifyUnacceptedResourceGroupDescriptor(ResourceGroupDescriptor descriptor, Collection<String> messages) {
        logger.debug((Object)("Resource Group Descriptor: " + descriptor + "\nMessages: " + messages));
        FailureDescriptor failureDescriptor = this.unacceptedRGDescriptors.get(descriptor.getName());
        if (failureDescriptor == null) {
            failureDescriptor = new FailureDescriptor();
            failureDescriptor.setName(descriptor.getName());
            failureDescriptor.setId(descriptor.getSystemId());
            failureDescriptor.setPluginId(descriptor.getPluginId());
            failureDescriptor.setExtensionId(descriptor.getExtensionId());
            this.unacceptedRGDescriptors.put(descriptor.getName(), failureDescriptor);
        }
        failureDescriptor.addErrorMessages(messages);
        String pluginId = failureDescriptor.getPluginId();
        if (pluginId != null) {
            this.pluginManager.getRegistry().unregister(new String[]{pluginId});
        }
    }

    @Override
    public synchronized void notifyUnacceptedResourceGroupDescriptor(ResourceGroupDescriptor descriptor, String message) {
        logger.debug((Object)("Resource Group Descriptor: " + descriptor + "\nMessage: " + message));
        ArrayList<String> messages = new ArrayList<String>();
        messages.add(message);
        this.notifyUnacceptedResourceGroupDescriptor(descriptor, messages);
    }

    public String getColleagueName() {
        return this.getServiceName();
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.NORMAL;
    }

    public void receive(WorkflowEvent event) {
        if (event instanceof PluginChangeEvent) {
            this.handlePluginChangeEvent((PluginChangeEvent)event);
        }
    }

    public synchronized void start() {
        logger.debug((Object)"The plugin management service is starting...");
        DefaultMediator.getInstance().sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STARTING));
        this.extensionHandler = new PluginExtensionHandler();
        IntegrityCheckReport report = this.extensionHandler.getReport(this.pluginManager);
        this.loadResourceTypeDescriptors(report);
        this.loadResourceGroupDescriptors(report);
        this.checkLicense();
        this.pluginChangeScheduler = new Scheduler(SCHEDULER_NAME, 1, 1);
        this.pluginChangeScheduler.start();
        DefaultMediator.getInstance().register((IColleague)this);
        DefaultMediator.getInstance().sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STARTED));
        logger.info((Object)"The plugin management service has started.");
    }

    public synchronized void stop() {
        logger.debug((Object)"The plugin management service is stopping...");
        DefaultMediator.getInstance().sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STOPPING));
        DefaultMediator.getInstance().unregister((IColleague)this);
        this.pluginChangeScheduler.stop();
        this.pluginChangeScheduler = null;
        this.resGroupDescriptors.clear();
        this.resTypeDescriptors.clear();
        this.failedDescriptors.clear();
        this.failedRGDescriptors.clear();
        this.missingRGDescriptors.clear();
        this.unacceptedRGDescriptors.clear();
        DefaultMediator.getInstance().sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STOPPED));
        logger.info((Object)"The plugin management service has stopped.");
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    private void handlePluginChangeEvent(PluginChangeEvent event) {
        logger.info((Object)("Received plugin change notification[" + event.getPluginFolder() + "]"));
        this.pendingEvents.add(event);
        this.pluginChangeScheduler.schedule((Callable)new PluginChangeRunnable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPendingEvents() {
        ArrayList<PluginChangeEvent> copy = null;
        List<PluginChangeEvent> list = this.pendingEvents;
        synchronized (list) {
            copy = new ArrayList<PluginChangeEvent>(this.pendingEvents);
            this.pendingEvents.clear();
        }
        int eventCount = copy.size();
        if (eventCount == 0) {
            return;
        }
        PluginChangeHandler changeHandler = new PluginChangeHandler();
        PluginChangeResult result = changeHandler.processEvents(this.pluginManager, copy);
        this.handleUpdatedDescriptors(result);
    }

    private synchronized void handleUpdatedDescriptors(PluginChangeResult result) {
        this.handleUpdatedResourceTypeDescriptors(result.getResourceTypeDescriptors());
        this.handleUpdatedResourceGroupDescriptors(result.getResourceGroupDescriptors());
    }

    private void handleUpdatedResourceTypeDescriptors(List<WatchPointDescriptor> descriptors) {
        String pluginId;
        String systemId;
        ArrayList<FailureDescriptor> failures = new ArrayList<FailureDescriptor>();
        for (WatchPointDescriptor descriptor : descriptors) {
            if (!(descriptor instanceof ResourceTypeDescriptor)) continue;
            ResourceTypeDescriptor type = (ResourceTypeDescriptor)descriptor;
            systemId = type.getSystemId();
            pluginId = type.getPluginId();
            ResourceTypeDescriptor oldType = this.resTypeDescriptors.get(systemId);
            this.removeResourceTypeFailureDescriptors(pluginId, systemId);
            if (oldType != null && !oldType.getPluginId().equals(pluginId)) {
                failures.add(this.extensionHandler.buildDescriptorForDuplicateKey(type));
                continue;
            }
            this.resTypeDescriptors.put(systemId, type);
            ResourceTypeDescriptor clone = (ResourceTypeDescriptor)type.clone();
            ResourceTypeDescriptorChangeEvent event = new ResourceTypeDescriptorChangeEvent(clone, oldType);
            DefaultMediator.getInstance().sendAsync((WorkflowEvent)event);
            logger.debug((Object)("Cached descriptor " + type + " for resource type plugin."));
        }
        for (WatchPointDescriptor descriptor : descriptors) {
            if (!(descriptor instanceof FailureDescriptor)) continue;
            FailureDescriptor failure = (FailureDescriptor)descriptor;
            systemId = failure.getId();
            pluginId = failure.getPluginId();
            this.removeResourceTypeFailureDescriptors(pluginId, systemId);
            ResourceTypeDescriptor currentDescriptor = this.resTypeDescriptors.get(systemId);
            if (currentDescriptor == null) {
                failures.add(failure);
                logger.debug((Object)("Cached failure for resource type plugin[" + pluginId + "]"));
                continue;
            }
            logger.debug((Object)("Ignoring invalid resource type plugin: " + failure));
        }
        this.failedDescriptors.addAll(failures);
        this.unregisterPlugins(failures);
    }

    private void removeResourceTypeFailureDescriptors(String pluginId, String systemId) {
        Iterator<FailureDescriptor> iterator = this.failedDescriptors.iterator();
        while (iterator.hasNext()) {
            FailureDescriptor failureDescriptor = iterator.next();
            if (pluginId != null && pluginId.equals(failureDescriptor.getPluginId())) {
                iterator.remove();
                continue;
            }
            if (failureDescriptor.getPluginId() != null || systemId == null || !systemId.equals(failureDescriptor.getId())) continue;
            iterator.remove();
        }
    }

    private void handleUpdatedResourceGroupDescriptors(List<WatchPointDescriptor> descriptors) {
        String pluginId;
        String name;
        ArrayList<FailureDescriptor> failures = new ArrayList<FailureDescriptor>();
        for (WatchPointDescriptor descriptor : descriptors) {
            if (!(descriptor instanceof ResourceGroupDescriptor)) continue;
            ResourceGroupDescriptor group = (ResourceGroupDescriptor)descriptor;
            name = group.getName();
            pluginId = group.getPluginId();
            ResourceGroupDescriptor oldGroup = this.resGroupDescriptors.get(name);
            this.removeResourceGroupFailureDescriptors(pluginId, name);
            if (oldGroup != null && !oldGroup.getPluginId().equals(group.getPluginId())) {
                failures.add(this.extensionHandler.buildDescriptorForDuplicateKey(group));
                continue;
            }
            this.resGroupDescriptors.put(name, group);
            ResourceGroupDescriptor clone = (ResourceGroupDescriptor)group.clone();
            ResourceGroupDescriptorChangeEvent event = new ResourceGroupDescriptorChangeEvent(clone, oldGroup);
            DefaultMediator.getInstance().sendAsync((WorkflowEvent)event);
            logger.debug((Object)("Cached resource group descriptor " + group + " for plugin update."));
        }
        for (WatchPointDescriptor descriptor : descriptors) {
            if (!(descriptor instanceof FailureDescriptor)) continue;
            FailureDescriptor failure = (FailureDescriptor)descriptor;
            name = failure.getName();
            pluginId = failure.getPluginId();
            this.removeResourceGroupFailureDescriptors(pluginId, name);
            ResourceGroupDescriptor currentDescriptor = this.resGroupDescriptors.get(name);
            if (currentDescriptor == null) {
                failures.add(failure);
                logger.debug((Object)("Cached failure for resource group plugin[" + pluginId + "]"));
                continue;
            }
            logger.debug((Object)("Ignoring invalid resource group plugin update: " + failure));
        }
        this.failedRGDescriptors.addAll(failures);
        this.unregisterPlugins(failures);
    }

    private void removeResourceGroupFailureDescriptors(String pluginId, String groupName) {
        Iterator<FailureDescriptor> iterator = this.failedRGDescriptors.iterator();
        while (iterator.hasNext()) {
            FailureDescriptor failureDescriptor = iterator.next();
            if (pluginId != null && pluginId.equals(failureDescriptor.getPluginId())) {
                iterator.remove();
                continue;
            }
            if (failureDescriptor.getPluginId() != null || groupName == null || !groupName.equals(failureDescriptor.getName())) continue;
            iterator.remove();
        }
        this.missingRGDescriptors.remove(groupName);
        this.unacceptedRGDescriptors.remove(groupName);
    }

    private class PluginChangeRunnable
    implements Callable<Void> {
        private PluginChangeRunnable() {
        }

        @Override
        public Void call() throws Exception {
            block4: {
                int pendingEventCount = WatchPointPluginManager.this.pendingEvents.size();
                Thread.sleep(25000L);
                if (pendingEventCount == WatchPointPluginManager.this.pendingEvents.size()) break block4;
                return null;
            }
            try {
                WatchPointPluginManager.this.processPendingEvents();
            }
            catch (InterruptedException e) {
                logger.debug((Object)"Interrupted when processing pending plugin change events.", (Throwable)e);
            }
            catch (Exception e) {
                logger.error((Object)"Failure when processing plugin change events.", (Throwable)e);
            }
            return null;
        }
    }
}

