/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search;

import com.tandbergtv.workflow.driver.search.SearchOperator;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import java.util.ArrayList;
import java.util.List;

public class ListParameter
extends SearchParameterBase {
    private List values;
    private SearchOperator operator;

    public ListParameter(String name) {
        this(name, SearchType.STRING);
    }

    public ListParameter(String name, SearchType type) {
        this(name, type, SearchOperator.IN);
    }

    public ListParameter(String name, SearchType type, boolean isVariable) {
        this(name, type, SearchOperator.IN, isVariable);
    }

    public ListParameter(String name, SearchType type, SearchOperator operator) {
        this(name, type, operator, false);
    }

    public ListParameter(String name, SearchType type, SearchOperator operator, boolean isVariable) {
        super(name, type, isVariable);
        this.setOperator(operator);
    }

    public List getValues() {
        return this.values;
    }

    public void setValues(List values) {
        this.values = values;
    }

    public SearchOperator getOperator() {
        return this.operator;
    }

    public void setOperator(SearchOperator operator) {
        if (operator != SearchOperator.IN && operator != SearchOperator.NOTIN) {
            throw new RuntimeException("Search operator is invalid: " + (Object)((Object)operator));
        }
        this.operator = operator;
    }

    public void addValue(Object val) {
        if (this.values == null) {
            this.values = new ArrayList();
        }
        this.values.add(val);
    }

    public void addValues(Object ... values) {
        if (this.values == null) {
            this.values = new ArrayList();
        }
        for (Object value : values) {
            this.values.add(value);
        }
    }

    @Override
    public String getPredicate() {
        String result = null;
        String operatorperfix = this.operator == SearchOperator.IN ? " IN (" : " NOT IN (";
        for (Object val : this.values) {
            if (result == null) {
                result = operatorperfix + this.getFormattedValue(val);
                continue;
            }
            result = result + "," + this.getFormattedValue(val);
        }
        if (result != null) {
            result = result + ")";
        }
        return result;
    }

    private String getFormattedValue(Object val) {
        if (this.getFieldType() == SearchType.STRING) {
            return "'" + val + "'";
        }
        if (this.getFieldType() == SearchType.DATE) {
            return "to_date('" + val + "','" + "yyyy-MM-dd" + "' )";
        }
        return val.toString();
    }
}

