/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.search;

import com.tandbergtv.workflow.driver.search.SearchOperator;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.util.SortingOrder;

public class SearchParameter
extends SearchParameterBase {
    protected SearchParameterBase parameter;
    protected boolean isConjunction = true;
    private SearchOperator operator = null;

    protected SearchParameter(String name) {
        super(name, SearchType.STRING, false);
    }

    public SearchParameter(SearchParameterBase parameter) {
        super(parameter.getFieldName());
        this.parameter = parameter;
    }

    public SearchParameterBase getDecoratedParameter() {
        return this.parameter;
    }

    @Override
    public String getPredicate() {
        return this.parameter.getPredicate();
    }

    public int getObjectCount() {
        return this.objectCount;
    }

    public void setObjectCount(int count) {
        this.objectCount = count;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public boolean isConjunction() {
        return this.isConjunction;
    }

    public void setConjunction(boolean isConjunction) {
        this.isConjunction = isConjunction;
    }

    @Override
    public String getPartialFromClause(int count) {
        throw new UnsupportedOperationException();
    }

    public String getCompleteAlias() {
        return String.valueOf(this.alias) + this.objectCount;
    }

    @Override
    public String getFieldName() {
        if (this.parameter != null) {
            return this.parameter.getFieldName();
        }
        return super.getFieldName();
    }

    @Override
    public String getSortingColumn() {
        if (this.parameter instanceof SortParameter) {
            return this.parameter.getSortingColumn();
        }
        throw new RuntimeException("This is not a sort parameter");
    }

    @Override
    public SortingOrder getSortingOrder() {
        if (this.parameter instanceof SortParameter) {
            return this.parameter.getSortingOrder();
        }
        throw new RuntimeException("This is not a sort parameter");
    }

    public String getPartialOrderByClause() {
        if (this.parameter instanceof SortParameter) {
            String order = this.getSortingOrder() == SortingOrder.ASCENDING ? " ASC" : " DESC";
            return String.valueOf(this.getSortingColumn()) + order;
        }
        throw new RuntimeException("This is not a sort parameter");
    }

    @Override
    public String getPartialWhereClause() {
        String property = this.parameter.getFieldName();
        String predicate = this.parameter.getPredicate();
        if (this.parameter.getIgnoreCase()) {
            return "lower(" + this.getCompleteAlias() + "." + property + ") " + predicate;
        }
        return String.valueOf(this.getCompleteAlias()) + "." + property + " " + predicate;
    }

    public void setOperator(SearchOperator operator) {
        this.operator = operator;
    }

    public SearchOperator getOperator() {
        return this.operator;
    }
}

