/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.handler;

import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.adaptor.handler.HandlerException;
import com.tandbergtv.workflow.adaptor.handler.XMLTemplateHandler;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IPayload;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.StringPayload;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.WPCLConverter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MappingXMLTemplateHandler
extends XMLTemplateHandler {
    private static final String OUTGOING_TEMPLATE_FILE_PATH = "template/outgoing.xml";
    private static final String INCOMING_TEMPLATE_FILE_PATH = "template/incoming.xml";
    private static final String INCOMING_MAPPING_FILE_PATH = "mapping/incoming.xml";
    private static final String PARAMETER_NAME_TAG = "Name";
    private static final String PARAMETER_VALUE_TAG = "Value";
    private static final String PARAMETER_XPATH = "//Parameter";
    private static final Logger LOGGER = Logger.getLogger(MappingXMLTemplateHandler.class);
    private static final String SOAP_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body>";
    private static final String SOAP_FOOTER = "</soapenv:Body></soapenv:Envelope>";
    boolean isMessageTypeOutgoing = false;

    public MappingXMLTemplateHandler() {
    }

    public MappingXMLTemplateHandler(IHandlerConfiguration conf) {
        super(conf);
    }

    private String generateXMLFromVariableMapping(String inputContent) throws HandlerException {
        String template = this.getTemplate();
        Document source = this.getDOMDocumentFromString(inputContent);
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList parameterList = null;
        try {
            parameterList = (NodeList)xPath.evaluate(PARAMETER_XPATH, source, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new HandlerException("Failed to transform document", e);
        }
        String ret = template;
        for (int i = 0; i < parameterList.getLength(); ++i) {
            Element parameter = (Element)parameterList.item(i);
            String name = parameter.getAttribute(PARAMETER_NAME_TAG);
            NodeList list = parameter.getElementsByTagName(PARAMETER_VALUE_TAG);
            String value = list.item(0).getFirstChild().getNodeValue();
            ret = ret.replace("${" + name + "}", value);
        }
        int index = ret.indexOf("?>");
        ret = ret.substring(index + 2);
        return ret;
    }

    private String getTemplate() throws HandlerException {
        ClassLoader classLoader = this.getConfiguration().getClassLoader();
        BufferedReader templateReader = new BufferedReader(new InputStreamReader(classLoader.getResourceAsStream(this.getConfigPath() + OUTGOING_TEMPLATE_FILE_PATH)));
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[255];
        try {
            int size = 0;
            while ((size = templateReader.read(buffer)) != -1) {
                sb.append(buffer, 0, size);
            }
        }
        catch (IOException e) {
            throw new HandlerException("Failed to read template", e);
        }
        finally {
            try {
                templateReader.close();
            }
            catch (IOException iOException) {}
        }
        return sb.toString();
    }

    @Override
    public IMessage postProcess(IMessage message) throws HandlerException {
        LOGGER.debug((Object)("Input: " + message));
        String inputContent = message.getPayload().getContent();
        String outputContent = null;
        outputContent = this.isMessageTypeOutgoing ? this.generateOutputXML(inputContent, INCOMING_MAPPING_FILE_PATH, INCOMING_TEMPLATE_FILE_PATH) : this.generateXMLFromVariableMapping(inputContent);
        MessageImpl ret = new MessageImpl((IPayload)new StringPayload(outputContent));
        LOGGER.debug((Object)("Output: " + ret));
        return ret;
    }

    private boolean isMessageTypeOutgoing(IMessage message) {
        boolean isOutgoing = false;
        WorkflowMessage workflowMessage = null;
        WPCLConverter converter = new WPCLConverter();
        try {
            workflowMessage = converter.convert(message);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (workflowMessage != null) {
            isOutgoing = workflowMessage.getMessageUID().isMessageOutgoing();
        }
        return isOutgoing;
    }

    private IMessage processOutgoingMessage(String inputContent, IMessage message) throws HandlerException {
        String outputContent = this.generateXMLFromVariableMapping(inputContent);
        StringBuilder sb = new StringBuilder();
        sb.append(SOAP_HEADER);
        sb.append(outputContent);
        sb.append(SOAP_FOOTER);
        return this.constructMessage(sb.toString(), message);
    }

    private IMessage processIncomingMessage(String inputContent) throws HandlerException {
        String outputContent = this.generateOutputXML(inputContent, INCOMING_MAPPING_FILE_PATH, INCOMING_TEMPLATE_FILE_PATH);
        return new MessageImpl((IPayload)new StringPayload(outputContent));
    }

    @Override
    public IMessage process(IMessage message) throws HandlerException {
        LOGGER.debug((Object)("Input: " + message));
        this.isMessageTypeOutgoing = this.isMessageTypeOutgoing(message);
        String inputContent = message.getPayload().getContent();
        IMessage returnMessage = null;
        returnMessage = this.isMessageTypeOutgoing ? this.processOutgoingMessage(inputContent, message) : this.processIncomingMessage(inputContent);
        LOGGER.debug((Object)("Output: " + returnMessage));
        return returnMessage;
    }
}

