/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.api;

import com.tandbergtv.workflow.api.APIException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public abstract class AbstractClientRequest<T> {
    private int lastStatusCode;
    protected static final String API_VERSION_HEADER = "X-API-Version";
    protected static final String API_VERSION_V1 = "1";
    protected static final int CONNECTION_TIMEOUT = 30000;
    protected static final int READ_TIMEOUT = 30000;
    protected Map<String, Object> responseMap = Collections.emptyMap();
    private static final Logger logger = Logger.getLogger(AbstractClientRequest.class);

    protected AbstractClientRequest() {
    }

    public int getLastStatusCode() {
        return this.lastStatusCode;
    }

    public abstract T execute() throws IOException;

    protected abstract URL url() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> request() throws IOException {
        HttpURLConnection connection = null;
        try {
            connection = this.connect();
            this.responseMap = this.getResources(connection);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return this.responseMap;
    }

    protected HttpURLConnection connect() throws IOException {
        URL url = this.url();
        logger.debug((Object)("Making request to " + url));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoInput(true);
        connection.setRequestMethod("GET");
        connection.setConnectTimeout(30000);
        connection.setReadTimeout(30000);
        connection.setRequestProperty(API_VERSION_HEADER, API_VERSION_V1);
        this.lastStatusCode = connection.getResponseCode();
        logger.debug((Object)("Status code " + this.lastStatusCode));
        if (this.lastStatusCode >= 400) {
            if (connection.getContentType().equals("application/json")) {
                throw new APIException(this.getResources(connection).get("message").toString(), this.lastStatusCode);
            }
            throw new APIException(this.read(connection), this.lastStatusCode);
        }
        return connection;
    }

    protected String read(HttpURLConnection connection) throws IOException {
        String line;
        InputStream ris = null;
        ris = connection.getResponseCode() >= 400 ? connection.getErrorStream() : connection.getInputStream();
        StringBuffer sb = new StringBuffer();
        BufferedReader br = new BufferedReader(new InputStreamReader(ris));
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    protected Integer getTotal() {
        return (Integer)this.responseMap.get("total");
    }

    protected Integer getCount() {
        return (Integer)this.responseMap.get("count");
    }

    protected String getPrevPageToken() {
        return (String)this.responseMap.get("prev");
    }

    protected String getNextPageToken() {
        return (String)this.responseMap.get("next");
    }

    private Map<String, Object> getResources(HttpURLConnection connection) throws IOException {
        JsonFactory factory = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper(factory);
        TypeReference<Map<String, Object>> ref = new TypeReference<Map<String, Object>>(){};
        this.responseMap = (Map)mapper.readValue(this.read(connection), (TypeReference)ref);
        return this.responseMap;
    }
}

