/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.api;

import com.google.common.collect.Lists;
import com.tandbergtv.workflow.api.AbstractClientRequest;
import com.tandbergtv.workflow.api.Converters;
import com.tandbergtv.workflow.api.model.resource.Resource;
import com.tandbergtv.workflow.api.model.resource.ResourceListResponse;
import com.tandbergtv.workflow.api.model.resource.ResourceQueryBuilder;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Resources
extends AbstractClientRequest<ResourceListResponse> {
    private String baseUrl;
    private ResourceQueryBuilder query;

    Resources(String baseUrl) {
        this.baseUrl = baseUrl;
        this.query = new ResourceQueryBuilder(this.baseUrl);
    }

    public ResourceQueryBuilder query() {
        return this.query;
    }

    @Override
    public ResourceListResponse execute() throws IOException {
        Map<String, Object> map = this.request();
        Integer total = this.getTotal();
        if (total != null) {
            List list = (List)map.get("resources");
            return new ResourceListResponse(this.getItems(list), total, this.getCount(), this.getPrevPageToken(), this.getNextPageToken());
        }
        Resource resource = (Resource)Converters.forResource().apply(map);
        return new ResourceListResponse(Collections.singletonList(resource), 1, 1);
    }

    @Override
    protected URL url() throws IOException {
        return new URL(this.query.build());
    }

    private List<Resource> getItems(List<Map<String, Object>> map) {
        return Lists.transform(map, Converters.forResource());
    }
}

