/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.util.resource;

import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.resourcemanager.IInternalResourceService;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class InternalResourceService
implements IInternalResourceService {
    private Set<Long> resourceGroupIds;
    private Collection<String> systemIds;
    private static final Logger LOGGER = Logger.getLogger(InternalResourceService.class);

    public InternalResourceService(Collection<String> systemIds) {
        this.systemIds = systemIds;
    }

    public boolean needsResource(long resourceGroupId) {
        return !this.resourceGroupIds.contains(resourceGroupId);
    }

    public void start() {
        this.resourceGroupIds = new HashSet<Long>();
        for (String systemId : this.systemIds) {
            this.buildResourceGroupList(systemId);
        }
    }

    public void stop() {
        this.resourceGroupIds.clear();
    }

    public String getServiceName() {
        return "resource-internal-service";
    }

    private void buildResourceGroupList(String systemID) {
        ResourceManagement service = (ResourceManagement)ServiceRegistry.getDefault().lookup(ResourceManagement.class);
        ResourceType resourceType = service.getResourceTypeBySystemId(systemID);
        if (resourceType == null) {
            return;
        }
        long resourceTypeId = resourceType.getId();
        List resourceGroups = service.getResourceGroupsByResourceType(resourceTypeId);
        for (ResourceGroup g : resourceGroups) {
            LOGGER.debug((Object)("for " + systemID + " added " + g.getName()));
            this.resourceGroupIds.add(g.getId());
        }
    }
}

