/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver;

import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.ericsson.cms.neptune.cluster.service.IDistributedSchedulerService;
import com.hazelcast.core.Member;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.IPersistenceService;
import com.tandbergtv.workflow.core.NodeGroup;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.graph.ErrorCategory;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.ProcessFinder;
import com.tandbergtv.workflow.driver.event.EventMulticast;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEventType;
import com.tandbergtv.workflow.driver.event.message.MessageRejectedEvent;
import com.tandbergtv.workflow.driver.process.WorkflowProcessCache;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceConsumerKey;
import com.tandbergtv.workflow.resourcemanager.event.IResourceConsumerAware;
import com.tandbergtv.workflow.resourcemanager.event.QueueOrderChangedEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceAcquiredEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceAllocationFailedEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceFailedEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceRequestRejectedEvent;
import com.tandbergtv.workflow.resourcemanager.event.WorkflowProcessStatusLogEvent;
import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.ExceptionHandler;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.Token;

public final class EngineDriver
implements IColleague {
    private static EngineDriver instance;
    private static final Logger LOGGER;
    private static final String ALLOCATED_RESOURCE_KEY_VARIABLE = "_allocated_resource_";
    private static final String LAST_ALLOCATED_RESOURCE_VARIABLE = "_last_allocated_resource";
    private IClusterService clusterService;

    private EngineDriver() {
    }

    public static synchronized EngineDriver getInstance() {
        if (instance == null) {
            instance = new EngineDriver();
        }
        return instance;
    }

    private CustomToken getToken(ResourceConsumerKey key) {
        WorkflowProcess process = this.getProcessCache().get((Serializable)Long.valueOf(key.getParentId()));
        return process != null ? process.findToken(key.getId()) : null;
    }

    private WorkflowProcessCache getProcessCache() {
        return (WorkflowProcessCache)ServiceRegistry.getDefault().lookup("Process Cache");
    }

    private IProcessManagerService getProcessManagerService() {
        return (IProcessManagerService)ServiceRegistry.getDefault().lookup(IProcessManagerService.class);
    }

    private IDistributedSchedulerService<CustomToken> getScheduler() {
        return (IDistributedSchedulerService)ServiceRegistry.getDefault().lookup("distributed-scheduler");
    }

    private void save(WorkflowProcess process) {
        ((IPersistenceService)ServiceRegistry.getDefault().lookup(IPersistenceService.class)).save(process);
    }

    public String getColleagueName() {
        return this.getClass().getName();
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.NORMAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(WorkflowEvent event) {
        Object source = event.getSource();
        if (source == this) {
            return;
        }
        if (!(event instanceof IResourceConsumerAware)) {
            return;
        }
        ResourceConsumerKey key = ((IResourceConsumerAware)IResourceConsumerAware.class.cast(event)).getResourceConsumerKey();
        if (!this.owner(key)) {
            this.sendEvent(key.getParentId(), key.getId(), event);
            return;
        }
        CustomToken token = this.getToken(key);
        if (event instanceof ResourceAcquiredEvent) {
            ResourceAcquiredEvent e = (ResourceAcquiredEvent)event;
            WorkflowProcess process = token.getProcessInstance();
            if (token.getStatus() != ProcessStatus.QUEUED) {
                LOGGER.warn((Object)(token + " spurious resource grant"));
                return;
            }
            LOGGER.debug((Object)(token + " got resource"));
            DefaultMediator.getInstance().send((WorkflowEvent)new WorkflowProcessStatusLogEvent(true, (Token)token, e.getResourceGroup(), e.getResource(), e.getStart(), e.getAllocationTime()));
            String name = ALLOCATED_RESOURCE_KEY_VARIABLE + token.getId();
            String value = e.getAllocatedResourceKey();
            ContextInstance c = process.getContextInstance();
            process.lock();
            try {
                c.setVariable(LAST_ALLOCATED_RESOURCE_VARIABLE, (Object)e.getResource().getName());
            }
            finally {
                process.unlock();
            }
            c.setTransientVariable(name, (Object)value);
            c.setTransientVariable("_resource_" + token.getId(), (Object)e.getResource());
            c.setTransientVariable("_task_assigner_" + token.getId(), (Object)e.getTaskAssigner());
            this.getProcessManagerService().dequeue(token);
        } else if (event instanceof ResourceRequestRejectedEvent) {
            if (token.getStatus() == ProcessStatus.QUEUED) {
                LOGGER.warn((Object)(token + " - resource request was rejected"));
                token.fail(ErrorCategory.RESOURCE_REQUEST_REJECTED, "Resource request was rejected");
            } else {
                LOGGER.warn((Object)(token + " - resource request was rejected"));
            }
        } else if (event instanceof QueueOrderChangedEvent) {
            QueueOrderChangedEvent e = (QueueOrderChangedEvent)event;
            WorkflowProcess process = token.getProcessInstance();
            ProcessPriority priority = e.getPriority();
            LOGGER.debug((Object)(token + ", event QUEUE REORDER " + priority));
            if (process.getPriority().equals((Object)priority)) {
                return;
            }
            process.setPriority(priority);
            this.save(process);
            for (CustomToken t : process.findAllTokens()) {
                if (t.equals((Object)token)) continue;
                this.sendEvent((WorkflowEvent)new WorkflowProcessEvent(process, (Token)t, WorkflowProcessEventType.PRIORITY_CHANGED));
            }
        } else if (event instanceof ResourceFailedEvent) {
            ResourceFailedEvent e = (ResourceFailedEvent)event;
            if (token == null) {
                LOGGER.warn((Object)(key + " resource failure event ignored because process has completed"));
                return;
            }
            LOGGER.debug((Object)(token + " event RESOURCE FAILURE (" + token.getNode().getName() + ")"));
            ContextInstance c = token.getProcessInstance().getContextInstance();
            c.deleteTransientVariable("_resource_" + token.getId());
            c.deleteTransientVariable("_task_assigner_" + token.getId());
            if (e.isHeartBeatFailure()) {
                token.setResumeAfterFail(true);
                token.abort();
                return;
            }
            Node node = token.getCurrentNode();
            if (e.getToken().getCurrentNode().getId() == node.getId() && (!this.checkExceptionHandlers(node) || node instanceof NodeGroup)) {
                token.abort();
            }
        } else if (event instanceof ResourceAllocationFailedEvent) {
            ResourceAllocationFailedEvent e = (ResourceAllocationFailedEvent)event;
            this.sendEvent((WorkflowEvent)new MessageRejectedEvent((Object)this, (Token)token, e.getMessage()));
        }
    }

    private boolean owner(ResourceConsumerKey key) {
        long id = key.getParentId();
        boolean local = this.getProcessCache().getLocalCache().getKeys().contains(id);
        if (!local) {
            return false;
        }
        WorkflowProcess process = this.getProcessCache().get((Serializable)Long.valueOf(id));
        if (!ProcessFinder.isOwner((WorkflowProcess)process)) {
            LOGGER.warn((Object)(process + ", exists in local cache but is not running here"));
        }
        return true;
    }

    private void sendEvent(WorkflowEvent event) {
        DefaultMediator.getInstance().sendAsync(event);
    }

    private void sendEvent(long id, long tokenId, WorkflowEvent event) {
        if (event.isConsume()) {
            return;
        }
        event.setConsume(true);
        Set members = this.getClusterService().members();
        if (members.isEmpty()) {
            LOGGER.warn((Object)("[" + id + ":" + tokenId + "], lost event " + event.getClass().getSimpleName()));
            return;
        }
        for (Member member : members) {
            this.getScheduler().schedule((Callable)new EventMulticast(id, tokenId, (Serializable)member.getSocketAddress(), event));
        }
    }

    private boolean checkExceptionHandlers(Node node) {
        if (node.getExceptionHandlers() == null) {
            return false;
        }
        for (ExceptionHandler exceptionHander : node.getExceptionHandlers()) {
            for (Action action : exceptionHander.getActions()) {
                if (!action.toString().equals("IgnoreException")) continue;
                return true;
            }
        }
        return false;
    }

    private IClusterService getClusterService() {
        if (this.clusterService == null) {
            this.clusterService = (IClusterService)ServiceRegistry.getDefault().lookup(IClusterService.class);
        }
        return this.clusterService;
    }

    static {
        LOGGER = Logger.getLogger(EngineDriver.class);
    }
}

