/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.sanmanager.entities;

import com.tandbergtv.workflow.sanmanager.entities.DriveCapacityUnit;
import com.tandbergtv.workflow.sanmanager.entities.DriveStatus;
import java.io.Serializable;
import java.util.Date;
import org.apache.log4j.Logger;

public class SANDrive
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 7338412016673517462L;
    private static final int DEFAULT_ID = -1;
    private long id = -1L;
    private String name;
    private String path;
    private int warningThreshold;
    private int errorThreshold;
    private long capacity;
    private long usedSpace;
    private DriveStatus status = DriveStatus.OK;
    private DriveCapacityUnit displayUnit = DriveCapacityUnit.GIGABYTE;
    private long configureDriveID = -1L;
    private Long resourceID = null;
    private String description = "";
    private static final Logger logger = Logger.getLogger(SANDrive.class);
    private Date sampleDate;

    public long getCapacity() {
        return this.capacity;
    }

    public void setCapacity(long capacity) {
        if (capacity < 0L) {
            capacity = 0L;
        }
        this.capacity = capacity;
    }

    public double getCapacity(DriveCapacityUnit unit) {
        return DriveCapacityUnit.convert(this.capacity, DriveCapacityUnit.BYTE, unit);
    }

    public void setCapacity(double capacity, DriveCapacityUnit unit) {
        if (capacity < 0.0) {
            capacity = 0.0;
        }
        this.capacity = (long)DriveCapacityUnit.convert(capacity, unit, DriveCapacityUnit.BYTE);
    }

    public DriveCapacityUnit getDisplayUnit() {
        return this.displayUnit;
    }

    public void setDisplayUnit(DriveCapacityUnit displayUnit) {
        this.displayUnit = displayUnit;
    }

    public double getDisplayCapacity() {
        return DriveCapacityUnit.convert(this.capacity, DriveCapacityUnit.BYTE, this.displayUnit);
    }

    public int getErrorThreshold() {
        return this.errorThreshold;
    }

    public void setErrorThreshold(int errorThreshold) {
        this.errorThreshold = errorThreshold;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public DriveStatus getStatus() {
        return this.status;
    }

    public void setStatus(DriveStatus status) {
        this.status = status;
    }

    public long getUsedSpace() {
        return this.usedSpace;
    }

    public void setUsedSpace(long usedSpace) {
        this.usedSpace = usedSpace;
    }

    public int getWarningThreshold() {
        return this.warningThreshold;
    }

    public void setWarningThreshold(int warningThreshold) {
        this.warningThreshold = warningThreshold;
    }

    public Object clone() {
        SANDrive clone = null;
        try {
            clone = (SANDrive)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            logger.error((Object)"Failed to clone the SANDrive object.", (Throwable)ex);
        }
        return clone;
    }

    public long getConfigureDriveID() {
        return this.configureDriveID;
    }

    public void setConfigureDriveID(long configureDriveID) {
        this.configureDriveID = configureDriveID;
    }

    public Long getResourceID() {
        return this.resourceID;
    }

    public void setResourceID(Long resourceID) {
        this.resourceID = resourceID;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getSampleDate() {
        return this.sampleDate;
    }

    public void setSampleDate(Date sampleDate) {
        this.sampleDate = sampleDate;
    }
}

