/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor.core;

import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.monitor.core.IObserver;
import com.tandbergtv.workflow.monitor.core.IRecorder;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class Recorder
implements IRecorder {
    protected final ISchedulerService<Void> pool;
    protected final String name;
    protected final long period;
    protected Set<IObserver> observers;
    private static final long PERIOD = 10000L;

    public Recorder(ISchedulerService<Void> pool, String name) {
        this(pool, name, 10000L);
    }

    public Recorder(ISchedulerService<Void> pool, String name, long period) {
        this.pool = pool;
        this.name = name;
        this.period = period;
        this.observers = new HashSet<IObserver>();
    }

    public ISchedulerService<Void> getScheduler() {
        return this.pool;
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observers.remove(observer);
    }

    @Override
    public Set<IObserver> getObservers() {
        return this.observers;
    }

    public void start() {
        this.pool.start();
        this.pool.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    Recorder.this.record();
                }
                catch (Throwable t) {
                    Logger.getLogger(Recorder.class).warn((Object)"error", t);
                }
            }
        }, 0L, this.period);
    }

    public void stop() {
        this.observers.clear();
        this.pool.stop();
    }

    public String getServiceName() {
        return this.name;
    }
}

