/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.driver.internal.IWorkOrderLoader;
import com.tandbergtv.workflow.driver.internal.JBPMPersistenceService;
import com.tandbergtv.workflow.driver.internal.ProcessPersistenceService;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class WorkOrderLoaderAdaptor
implements IWorkOrderLoader {
    private static final Logger LOGGER = Logger.getLogger(ProcessPersistenceService.class);
    private JBPMPersistenceService legacyPersistenceService;
    private ProcessPersistenceService processPersistenceService;

    public WorkOrderLoaderAdaptor(JBPMPersistenceService legacyPersistenceService, ProcessPersistenceService processPersistenceService) {
        this.legacyPersistenceService = legacyPersistenceService;
        this.processPersistenceService = processPersistenceService;
    }

    @Override
    public WorkflowProcess get(Serializable id) {
        WorkflowProcess wo = null;
        try {
            wo = this.processPersistenceService.get(id);
            this.setLegacy(wo, false);
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Cannot fetch WorkflowProcess object from database and cache: ", (Throwable)e);
        }
        if (wo == null && this.legacyPersistenceService != null) {
            LOGGER.info((Object)("Cannot find Work Order in ttv table with id: " + id + ", try to find it in jbpm table."));
            try {
                wo = this.legacyPersistenceService.get(id);
                this.setLegacy(wo, true);
            }
            catch (Exception e) {
                LOGGER.error((Object)("Cannot fetch Process Object in legacy table by id :" + id + " error:" + e.getMessage()));
            }
        }
        return wo;
    }

    @Override
    public List<WorkflowProcess> getAll(List<Serializable> ids) {
        List<WorkflowProcess> processes = null;
        try {
            processes = this.processPersistenceService.getAll(ids);
            this.setLegacy(processes, false);
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Cannot fetch WorkflowProcess object from database and cache: ", (Throwable)e);
        }
        if (processes == null && this.legacyPersistenceService != null) {
            try {
                processes = this.legacyPersistenceService.getAll(ids);
                this.setLegacy(processes, true);
            }
            catch (Exception e) {
                LOGGER.error((Object)("Cannot fetch Process Object in legacy table by id :[" + StringUtils.join(ids, (String)",") + "] error:" + e.getMessage()));
            }
        }
        return processes == null ? Collections.emptyList() : processes;
    }

    private void setLegacy(WorkflowProcess wo, boolean b) {
        if (wo != null) {
            wo.setLegacy(b);
        }
    }

    private void setLegacy(List<WorkflowProcess> wos, boolean b) {
        for (WorkflowProcess workflowProcess : wos) {
            this.setLegacy(workflowProcess, b);
        }
    }

    public String getServiceName() {
        return "WorkOrderLoaderService";
    }

    public void start() {
    }

    public void stop() {
    }
}

