/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WFSearchResult;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.entity.CustomTokenDTO;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.util.HibernateTemplate;
import com.tandbergtv.workflow.core.util.SessionUtils;
import com.tandbergtv.workflow.core.util.Watch;
import com.tandbergtv.workflow.driver.internal.IWorkOrderLoader;
import com.tandbergtv.workflow.driver.monitor.IProcessMonitor;
import com.tandbergtv.workflow.driver.process.WorkflowProcessCache;
import com.tandbergtv.workflow.driver.search.CriteriaBuilder;
import com.tandbergtv.workflow.driver.search.ISearchHelper;
import com.tandbergtv.workflow.driver.search.ListParameter;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.driver.search.WorkflowProcessSearchHelper;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class SearchService
implements IProcessSearchService {
    private static final String START_TIME = "startTime";
    private static final String PROCESS_ID = "processId";
    private static final String PROCESS_STATUS = "operationalStatus";
    private SessionFactory factory;
    public static final String SERVICE_NAME = "Process Search Service";
    private IWorkOrderLoader workOrderLoader;
    private static final Logger LOGGER = Logger.getLogger(SearchService.class);
    private WorkflowProcessCache processCache;

    public SearchService(SessionFactory factory) {
        this.factory = factory;
    }

    public void setPersistenceService(IWorkOrderLoader workOrderLoader) {
        this.workOrderLoader = workOrderLoader;
    }

    public void setProcessCache(WorkflowProcessCache processCache) {
        this.processCache = processCache;
    }

    @Override
    public int count(SearchCriteria criteria) {
        return this.getSearchHelper().count(criteria);
    }

    @Override
    public IProcessMonitor statistics(SearchCriteria criteria) {
        return this.getSearchHelper().statistics(criteria);
    }

    @Deprecated
    public int count(ProcessStatus status) {
        return this.count(Lists.newArrayList((Object[])new ProcessStatus[]{status}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int count(ProcessStatus status, Date cutOffDate) {
        Session session = null;
        try {
            session = this.factory.openSession();
            Criteria criteria = session.createCriteria(CustomTokenDTO.class).add(Restrictions.in((String)PROCESS_STATUS, this.toSearchStatus(status))).add((Criterion)Restrictions.ge((String)START_TIME, (Object)cutOffDate)).setProjection((Projection)Projections.countDistinct((String)PROCESS_ID));
            int n = HibernateTemplate.toInteger((Object)criteria.uniqueResult());
            return n;
        }
        finally {
            SessionUtils.closeSession((org.hibernate.Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int count(List<ProcessStatus> statuslist) {
        Assert.isTrue((!CollectionUtils.isEmpty(statuslist) ? 1 : 0) != 0, (String)"The status list cannot be null");
        Session session = null;
        try {
            session = this.factory.openSession();
            Criteria criteria = session.createCriteria(CustomTokenDTO.class).add(Restrictions.in((String)PROCESS_STATUS, this.toSearchStatus(statuslist))).setProjection((Projection)Projections.countDistinct((String)PROCESS_ID));
            int n = HibernateTemplate.toInteger((Object)criteria.uniqueResult());
            return n;
        }
        finally {
            SessionUtils.closeSession((org.hibernate.Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int count(WorkflowTemplate template, ProcessStatus ... status) {
        Session session = this.factory.openSession();
        try {
            List<ProcessStatus> searchStatus = this.toSearchStatus(status);
            String hsql = "select count(distinct  p.processid) from ttv_processinstance p, ttv_template template, ttv_token tt where p.isactive=1 and p.templateid= template.id and  tt.processid= p.processid  and template.typeid=2  and template.id = ?  and tt.operationalstatus in " + HibernateTemplate.constructInParameters((int)searchStatus.size());
            SQLQuery query = session.createSQLQuery(hsql);
            query.setParameter(0, (Object)template.getId());
            HibernateTemplate.constructInParameter((Query)query, (int)1, searchStatus);
            int n = HibernateTemplate.toInteger((Object)query.uniqueResult());
            return n;
        }
        finally {
            SessionUtils.closeSession((org.hibernate.Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkflowProcess> findAllByStatus(List<ProcessStatus> statuslist) {
        ArrayList result = Lists.newArrayList();
        org.hibernate.Session session = SessionUtils.getSession((SessionFactory)this.factory);
        try {
            Criteria criteria = session.createCriteria(CustomTokenDTO.class).add(Restrictions.in((String)PROCESS_STATUS, this.toSearchStatus(statuslist))).setProjection(Projections.distinct((Projection)Projections.property((String)PROCESS_ID)));
            List<WorkflowProcess> processes = this.loadProcess(criteria.list());
            if (!processes.isEmpty()) {
                result.addAll(processes);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Fail to execute query:", (Throwable)e);
        }
        finally {
            SessionUtils.closeSession((org.hibernate.Session)session);
        }
        return this.replacedFromCache(result);
    }

    private List<ProcessStatus> toSearchStatus(List<ProcessStatus> statuslist) {
        ArrayList to = Lists.newArrayList();
        for (ProcessStatus status : statuslist) {
            if (status == ProcessStatus.ACTIVE) {
                to.addAll(ProcessStatus.getActiveSet());
                continue;
            }
            to.add(status);
        }
        return to;
    }

    private List<ProcessStatus> toSearchStatus(ProcessStatus ... statuslist) {
        return this.toSearchStatus(Lists.newArrayList((Object[])statuslist));
    }

    private List<WorkflowProcess> loadProcess(List list) {
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        Stopwatch watch = Stopwatch.createStarted();
        List<WorkflowProcess> result = this.workOrderLoader.getAll(list);
        watch.stop();
        LOGGER.debug((Object)("Load " + result.size() + " process objects from DB in " + Watch.cost((Stopwatch)watch)));
        return CollectionUtils.isEmpty(result) ? Collections.emptyList() : result;
    }

    protected WorkflowProcess loadWorkOrder(Long processId) {
        return this.workOrderLoader.get(processId);
    }

    @Override
    public List<WorkflowProcess> findAllByStatus(ProcessStatus status) {
        ArrayList list = Lists.newArrayList((Object[])new ProcessStatus[]{status});
        return this.findAllByStatus(list);
    }

    @Override
    public List<WorkflowProcess> findAllByStatus(ProcessStatus ... statuslist) {
        ArrayList list = Lists.newArrayList((Object[])statuslist);
        return this.findAllByStatus(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkflowProcess> search(SearchCriteria searchCriteria) {
        Session session = null;
        try {
            session = this.factory.openSession();
            Criteria criteria = session.createCriteria(CustomTokenDTO.class);
            criteria.setProjection((Projection)Projections.property((String)PROCESS_ID));
            CriteriaBuilder.build(criteria, searchCriteria);
            List<WorkflowProcess> list = this.searchByCriteria(criteria);
            return list;
        }
        finally {
            SessionUtils.closeSession((org.hibernate.Session)session);
        }
    }

    private List<WorkflowProcess> searchByCriteria(Criteria criteria) {
        ArrayList result = Lists.newArrayList();
        try {
            result.addAll(this.loadProcess(criteria.list()));
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Faile to execute search by Criteria : " + criteria.toString()), (Throwable)ex);
        }
        return this.replacedFromCache(result);
    }

    private List<WorkflowProcess> replacedFromCache(List<WorkflowProcess> searchResult) {
        ArrayList<WorkflowProcess> processes = new ArrayList<WorkflowProcess>();
        for (WorkflowProcess process : searchResult) {
            WorkflowProcess cached = this.getProcessCache().get(Long.valueOf(process.getId()));
            if (cached != null) {
                process = cached;
            }
            processes.add(process);
        }
        return processes;
    }

    private WorkflowProcessCache getProcessCache() {
        if (this.processCache == null) {
            this.processCache = (WorkflowProcessCache)ServiceRegistry.getDefault().lookup("Process Cache");
        }
        return this.processCache;
    }

    @Override
    public List<WFSearchResult> expressSearch(SearchCriteria searchCriteria) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int expressCount(SearchCriteria criteria) {
        throw new UnsupportedOperationException();
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
    }

    public void stop() {
    }

    public SearchCriteria getSearchCriteriaByProcessStatus(ProcessStatus status) {
        SearchCriteria criteria = new SearchCriteria();
        criteria.addParameter((SearchParameterBase)new ValueParameter("status", SearchType.PROCESSSTATUS, (Object)status));
        criteria.setSearchDistinct(false);
        return criteria;
    }

    public SearchCriteria getSearchCriteriaByProcessStatusList(List<ProcessStatus> list) {
        ListParameter parameter = new ListParameter("status", SearchType.PROCESSSTATUS);
        parameter.addValue(list);
        SearchCriteria criteria = new SearchCriteria();
        criteria.addParameter((SearchParameterBase)parameter);
        criteria.setSearchDistinct(false);
        return criteria;
    }

    private ISearchHelper getSearchHelper() {
        return new WorkflowProcessSearchHelper(this.factory);
    }
}

