/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.callable;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.graph.ErrorCategory;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.thread.DistributedCallable;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.driver.ProcessFinder;
import com.tandbergtv.workflow.driver.monitor.IProcessCounter;
import com.tandbergtv.workflow.driver.monitor.IStatistics;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import java.io.Serializable;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public abstract class TokenCallable
implements Serializable,
DistributedCallable<CustomToken> {
    private static final long serialVersionUID = 7600678204063487453L;
    protected long pid;
    protected long tokenId;
    protected Serializable key;

    protected TokenCallable() {
    }

    public TokenCallable(CustomToken token) {
        this.pid = token.getProcessInstance().getId();
        this.tokenId = token.getId();
        this.key = ProcessFinder.getKey(token.getProcessInstance());
    }

    public Object getKey() {
        return this.key;
    }

    protected long getPid() {
        return this.pid;
    }

    public CustomToken call() throws Exception {
        CustomToken token = null;
        try {
            this.schedule(this.innerCallable(this.findToken()));
        }
        catch (Throwable t) {
            Logger.getLogger(TokenCallable.class).error((Object)"Could not run task", t);
        }
        return token;
    }

    protected abstract Callable<CustomToken> innerCallable(CustomToken var1);

    protected void schedule(Callable<CustomToken> callable) {
        this.getScheduler().schedule(callable);
    }

    protected CustomToken findToken() {
        IPersistenceService service = (IPersistenceService)ServiceRegistry.getDefault().lookup(IPersistenceService.class);
        for (int count = 0; service == null && count < 180; ++count) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            service = (IPersistenceService)ServiceRegistry.getDefault().lookup(IPersistenceService.class);
        }
        WorkflowProcess process = service.get(Long.valueOf(this.pid));
        return process.findToken(this.tokenId);
    }

    protected void handleStackOverflowError(CustomToken token, Throwable t) {
        Logger.getLogger(TokenCallable.class).warn((Object)(token + " overflowed stack"));
        token.fail(ErrorCategory.INFINITE_LOOP, t);
    }

    protected ISchedulerService<CustomToken> getScheduler() {
        return ((IProcessManagerService)ServiceRegistry.getDefault().lookup(IProcessManagerService.class)).getScheduler();
    }

    protected IProcessCounter counter() {
        IStatistics stats = ((IProcessManagerService)ServiceRegistry.getDefault().lookup(IProcessManagerService.class)).getStatistics();
        return (IProcessCounter)IProcessCounter.class.cast(stats.getCumulativeStatistics());
    }
}

