/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template.internal;

import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.driver.DriverException;
import com.tandbergtv.workflow.driver.search.ListParameter;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.driver.template.IArchivalStrategy;
import com.tandbergtv.workflow.driver.template.IESDeleteService;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.util.List;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.node.ProcessState;

public class VersionBasedArchivalStrategy
implements IArchivalStrategy {
    private static final Logger LOGGER = Logger.getLogger(VersionBasedArchivalStrategy.class);
    private ITemplateLoaderService loader;
    private IProcessSearchService search;
    private IESDeleteService processDeleter;

    public VersionBasedArchivalStrategy(ITemplateLoaderService loader, IProcessSearchService search, IESDeleteService processDeleter) {
        this.loader = loader;
        this.search = search;
        this.processDeleter = processDeleter;
    }

    @Override
    public void archive() {
        for (WorkflowTemplate template : this.loader.getLatestTemplates()) {
            this.archive(template);
        }
    }

    @Override
    public void archive(WorkflowTemplate template) {
        LOGGER.info((Object)("Trying to delete older versions of template " + template));
        for (WorkflowTemplate previous : this.loader.getPreviousVersions(template)) {
            if (this.isSubProcess(previous)) continue;
            SearchCriteria criteria = new SearchCriteria();
            this.template(criteria, previous.getId());
            int count = this.search.expressCount(criteria);
            LOGGER.info((Object)("Found " + count + " process(es) of template " + previous));
            try {
                if (count == 0) {
                    this.loader.delete(previous);
                    continue;
                }
                this.processDeleter.addToCache(previous);
            }
            catch (DriverException e) {
                LOGGER.warn((Object)("Failed to delete older versions of template " + template), (Throwable)e);
            }
        }
    }

    private SearchCriteria template(SearchCriteria criteria, Long templateId) {
        ListParameter parameter = new ListParameter("templateId", SearchType.NUMERIC);
        parameter.addValue((Object)templateId);
        criteria.addParameter((SearchParameterBase)parameter);
        return criteria;
    }

    private boolean isSubProcess(WorkflowTemplate template) {
        List<WorkflowTemplate> templates = this.loader.getAllTemplates();
        for (WorkflowTemplate t : templates) {
            if (t.equals((Object)template)) continue;
            for (Node node : t.getNodes()) {
                ProcessState p;
                if (!(node instanceof ProcessState) || !(p = (ProcessState)ProcessState.class.cast(node)).getSubProcessDefinition().equals((Object)template)) continue;
                LOGGER.info((Object)(template + " is used by " + t));
                return true;
            }
        }
        return false;
    }
}

