/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search.elasticsearch;

import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.hazelcast.core.ISet;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WFSVariableInstance;
import com.tandbergtv.workflow.core.WFSearchResult;
import com.tandbergtv.workflow.core.WFToken;
import com.tandbergtv.workflow.core.WFVariable;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.driver.ProcessFinder;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchService;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.driver.search.elasticsearch.IWFSElasticSearchPersistanceHelper;
import com.tandbergtv.workflow.driver.search.elasticsearch.WFSElasticSearchFilterBuilder;
import com.tandbergtv.workflow.driver.search.elasticsearch.WfsEsParameters;
import com.tandbergtv.workflow.driver.search.elasticsearch.WfsEsPersistanceSynchronizer;
import com.tandbergtv.workflow.driver.search.elasticsearch.WfsEsProcessHelper;
import com.tandbergtv.workflow.driver.search.event.ProcessPersistEvent;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.io.FileReader;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.hibernate.SessionFactory;

public class WFSElasticSearchService
extends SearchService
implements IWFSElasticSearchPersistanceHelper,
IColleague {
    private static final Logger LOGGER = Logger.getLogger(WFSElasticSearchService.class);
    private static final String CONFIG_FILE = System.getProperty("com.tandbergtv.cms.product.dir", "/opt/tandbergtv/cms") + "/conf/workflow/WFSElasticSearch.properties";
    private static final boolean USE_HAZELCAST_TO_HANDLE_FAILED_ATTEMPT = System.getProperty("workflow.elasticsearch.sync.util", "").isEmpty();
    private TransportClient client;
    private WfsEsProcessHelper esProcessHelper = WfsEsProcessHelper.getInstance();
    private static final long INITIAL_TIMEOUT_MS = 30000L;
    private static final int DEFAULT_PORT = 9300;
    private long writeTimeoutMs = 30000L;
    private long readTimeoutMs = 30000L;
    private static final String SAVE_FAILED_MAP = "ES_SAVE_MAP";
    private static final String DELETE_FAILED_MAP = "ES_DELETE_MAP";
    private ExecutorService executor = Executors.newFixedThreadPool(2);
    private IWFSElasticSearchPersistanceHelper persistanceHelper;
    private Thread asyncESSynchronizer;
    private boolean running = true;
    private ISchedulerService<Void> scheduler;
    private BulkProcessor processor;
    private IClusterService clusterService;

    public WFSElasticSearchService(SessionFactory factory) {
        super(factory);
    }

    @Override
    public String getServiceName() {
        return super.getServiceName();
    }

    @Override
    public int count(ProcessStatus status) {
        return this.expressCount(this.getSearchCriteriaByProcessStatus(status));
    }

    @Override
    public int count(List<ProcessStatus> list) {
        return this.expressCount(this.getSearchCriteriaByProcessStatusList(list));
    }

    @Override
    public void start() {
        LOGGER.debug((Object)"Starting WFSElasticSearch service...");
        try {
            Properties props = this.readConfiguration();
            this.initTimeouts(props);
            String clusterName = props.getProperty("cluster.name");
            LOGGER.debug((Object)("Cluster name: " + clusterName));
            Settings settings = Settings.settingsBuilder().put("cluster.name", clusterName).build();
            this.client = new TransportClient.Builder().settings(settings).build();
            String hosts = props.getProperty("hosts");
            StringTokenizer tkz = new StringTokenizer(hosts, ",; ");
            while (tkz.hasMoreTokens()) {
                String hostEntry = tkz.nextToken().trim();
                if (hostEntry.length() <= 0) continue;
                int port = 9300;
                String host = hostEntry;
                int idx = hostEntry.indexOf(58);
                if (idx > 0) {
                    try {
                        port = Integer.parseInt(hostEntry.substring(idx + 1));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    host = hostEntry.substring(0, idx);
                }
                this.client.addTransportAddress((TransportAddress)new InetSocketTransportAddress(InetAddress.getByName(host), port));
                LOGGER.debug((Object)("Added host: " + host + ":" + port));
            }
            this.processor = BulkProcessor.builder((Client)this.client, (BulkProcessor.Listener)this.listener()).setFlushInterval(TimeValue.timeValueSeconds((long)10L)).build();
            this.scheduler = new Scheduler("process-elasticsearch-save", 1, 1);
            this.scheduler.start();
            DefaultMediator.getInstance().register((IColleague)this);
            this.persistanceHelper = this;
            this.running = true;
            this.asyncESSynchronizer = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (WFSElasticSearchService.this.running) {
                        if (USE_HAZELCAST_TO_HANDLE_FAILED_ATTEMPT && WFSElasticSearchService.this.getClusterService().isMaster()) {
                            WfsEsPersistanceSynchronizer synchronizer;
                            Long[] wip;
                            ISet failedSet = WFSElasticSearchService.this.getClusterService().getInstance().getSet(WFSElasticSearchService.DELETE_FAILED_MAP);
                            if (failedSet != null) {
                                for (Long procId : wip = failedSet.toArray(new Long[failedSet.size()])) {
                                    failedSet.remove(procId);
                                    synchronizer = new WfsEsPersistanceSynchronizer(procId, WFSElasticSearchService.this.persistanceHelper, true);
                                    WFSElasticSearchService.this.executor.execute(synchronizer);
                                }
                            }
                            if ((failedSet = WFSElasticSearchService.this.getClusterService().getInstance().getSet(WFSElasticSearchService.SAVE_FAILED_MAP)) != null) {
                                for (Long procId : wip = failedSet.toArray(new Long[failedSet.size()])) {
                                    failedSet.remove(procId);
                                    synchronizer = new WfsEsPersistanceSynchronizer(procId, WFSElasticSearchService.this.persistanceHelper, false);
                                    WFSElasticSearchService.this.executor.execute(synchronizer);
                                }
                            }
                        }
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                    WFSElasticSearchService.this.executor.shutdown();
                }
            });
            this.asyncESSynchronizer.start();
            LOGGER.debug((Object)"Started WFSElasticSearch service");
        }
        catch (Exception e) {
            LOGGER.error((Object)"Could not connect to ElasticSearch.", (Throwable)e);
        }
    }

    private Properties readConfiguration() throws Exception {
        FileReader reader = new FileReader(CONFIG_FILE);
        Properties props = new Properties();
        props.load(reader);
        reader.close();
        return props;
    }

    private void initTimeouts(Properties props) {
        int tmp;
        try {
            tmp = Integer.parseInt(props.getProperty("timeout.read"));
            this.readTimeoutMs = tmp < 3 ? 3000L : (tmp > 30 ? 30000L : (long)(1000 * tmp));
        }
        catch (Exception ex) {
            this.readTimeoutMs = 15000L;
        }
        LOGGER.debug((Object)("Read timeout: " + this.readTimeoutMs / 1000L));
        try {
            tmp = Integer.parseInt(props.getProperty("timeout.write"));
            this.writeTimeoutMs = tmp < 3 ? 3000L : (tmp > 30 ? 30000L : (long)(1000 * tmp));
        }
        catch (Exception ex) {
            this.writeTimeoutMs = 15000L;
        }
        LOGGER.debug((Object)("Write timeout: " + this.writeTimeoutMs / 1000L));
    }

    @Override
    public void stop() {
        LOGGER.debug((Object)"Stopping ElasticSearch service...");
        this.scheduler.stop();
        if (this.asyncESSynchronizer != null) {
            this.asyncESSynchronizer.interrupt();
        }
        this.running = false;
        DefaultMediator.getInstance().unregister((IColleague)this);
        try {
            this.client.close();
        }
        catch (Exception ex) {
            LOGGER.error((Object)ex);
        }
        LOGGER.debug((Object)"Stopped ElasticSearch service.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void softDelete(WorkflowProcess process) throws Exception {
        if (process == null || process.getId() < 1L || process.getRootToken() == null) {
            return;
        }
        String procId = String.valueOf(process.getId());
        LOGGER.debug((Object)("Saving process[" + procId + "]"));
        try (XContentBuilder source = this.esProcessHelper.createProcess(process);){
            this.esProcessHelper.trySaving(procId, source, this.client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(WorkflowProcess process) throws Exception {
        if (process == null || process.getId() < 1L || process.getRootToken() == null) {
            return;
        }
        String id = String.valueOf(process.getId());
        LOGGER.debug((Object)("Saving process[" + id + "]"));
        try (XContentBuilder source = this.esProcessHelper.createProcess(process);){
            this.processor.add((IndexRequest)this.client.prepareIndex("wfs", "processinstance", id).setSource(source).request());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(WFSearchResult result) throws Exception {
        if (result == null || result.getProcessId() < 1L || result.getToken().getTokenId() < 1L) {
            return;
        }
        String procId = String.valueOf(result.getProcessId());
        LOGGER.debug((Object)("Saving process[" + procId + "]"));
        try (XContentBuilder source = this.esProcessHelper.createBuilder(result);){
            this.esProcessHelper.savingNoWait(procId, source, this.client);
        }
    }

    private void saveFailedProcessId(long id, boolean deleting) {
        if (!USE_HAZELCAST_TO_HANDLE_FAILED_ATTEMPT) {
            LOGGER.fatal((Object)("Failed attempt of saving process Id " + id + " to reindex later for " + (deleting ? "delete" : "save") + " operation."));
            throw new RuntimeException("Failed attempt of saving process Id " + id + " to reindex later for " + (deleting ? "delete" : "save") + " operation.");
        }
        LOGGER.info((Object)("Saving process Id " + id + " to reindex later for " + (deleting ? "delete" : "save") + " operation."));
        ISet failedSet = deleting ? this.getClusterService().getInstance().getSet(DELETE_FAILED_MAP) : this.getClusterService().getInstance().getSet(SAVE_FAILED_MAP);
        failedSet.add(id);
    }

    @Override
    public void delete(long id) throws Exception {
        String procId = String.valueOf(id);
        LOGGER.debug((Object)("Deleting process[" + procId + "]"));
        long t1 = System.currentTimeMillis();
        while (!this.esProcessHelper.tryDeleting(procId, this.client)) {
            long t2;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if ((t2 = System.currentTimeMillis()) - t1 <= this.writeTimeoutMs) continue;
            this.saveFailedProcessId(id, true);
            return;
        }
    }

    @Override
    public void softDelete(long id) throws Exception {
        String procId = String.valueOf(id);
        XContentBuilder contentBuilder = JsonXContent.contentBuilder().startObject();
        contentBuilder.field("isActive", false);
        contentBuilder.endObject();
        UpdateRequest updateRequest = new UpdateRequest("wfs", "processinstance", procId);
        updateRequest.doc(contentBuilder);
        this.client.update(updateRequest).get(this.writeTimeoutMs, TimeUnit.MILLISECONDS);
    }

    private List<WFSearchResult> expressSearchGetChildren(List<SearchParameterBase> whereList, List<SearchParameterBase> sortList) {
        long start = System.currentTimeMillis();
        String parentIdPredicate = null;
        boolean hidesubprocess = false;
        for (SearchParameterBase param : whereList) {
            String esPropertyName = WfsEsParameters.mapUIColumnToESProperty(param.getFieldName());
            if ("id".equalsIgnoreCase(esPropertyName)) {
                parentIdPredicate = param.getPredicate();
                parentIdPredicate = parentIdPredicate.substring(parentIdPredicate.indexOf("= ") + 2);
                continue;
            }
            if (!"hidesubprocess".equalsIgnoreCase(param.getFieldName())) continue;
            hidesubprocess = true;
        }
        ArrayList<WFSearchResult> processes = new ArrayList<WFSearchResult>();
        processes.add(this.convertProcess(parentIdPredicate, hidesubprocess));
        LOGGER.debug((Object)("Total getChildren: " + (System.currentTimeMillis() - start) + " ms."));
        return processes;
    }

    private WFSearchResult convertProcess(String processIdAsString, boolean hidesubprocess) {
        WorkflowProcess proc = ((IPersistenceService)ServiceRegistry.getDefault().lookup(IPersistenceService.class)).get(Long.valueOf(Long.parseLong(processIdAsString)));
        WFSearchResult result = new WFSearchResult();
        result.setProcessId(proc.getId());
        result.setProcessDefinitionName(proc.getProcessDefinition().getFullName());
        result.setRootTokenId(proc.getRootToken().getId());
        WFToken token = new WFToken();
        result.setToken(token);
        this.convertToken(proc.getRootToken(), token, result, hidesubprocess);
        if (proc.getSuperProcessToken() == null) {
            Set vars = proc.getVariables();
            Iterator varItr = vars.iterator();
            int varsFound = 0;
            while (varItr.hasNext()) {
                WFSVariableInstance var = (WFSVariableInstance)varItr.next();
                if (!"titleId".equalsIgnoreCase(var.getName()) && !"title_id".equalsIgnoreCase(var.getName()) && !"titlebrief".equalsIgnoreCase(var.getName()) && !"title_brief".equalsIgnoreCase(var.getName()) && !"licensestart".equalsIgnoreCase(var.getName()) && !"license_start".equalsIgnoreCase(var.getName()) && !"licenseend".equalsIgnoreCase(var.getName()) && !"license_end".equalsIgnoreCase(var.getName()) && !"ingestTemplate".equalsIgnoreCase(var.getName()) && !"providerid".equalsIgnoreCase(var.getName()) && !"provider_id".equalsIgnoreCase(var.getName())) continue;
                this.addVar(result.getVariables(), var);
                if (++varsFound < 6) continue;
                break;
            }
        }
        return result;
    }

    private void addVar(Map<String, WFVariable> wfVariables, WFSVariableInstance var) {
        WFVariable newVar = new WFVariable();
        newVar.setName(var.getName());
        newVar.addValue(var.getStringVal());
        wfVariables.put(newVar.getName(), newVar);
    }

    private void convertToken(CustomToken rootToken, WFToken token, WFSearchResult result, boolean hidesubprocess) {
        token.setAdministrativeStatus(rootToken.getRequestedStatus().ordinal());
        token.setEndTime(rootToken.getEnd());
        if (rootToken.getErrorDetails() != null) {
            token.setErrorComment(rootToken.getErrorDetails().getMessage());
            token.setErrorTime(rootToken.getErrorDetails().getTime());
        }
        token.setNodeName(rootToken.getCurrentNode().getName());
        token.setOperationalStatus(rootToken.getStatus().ordinal());
        token.setProcessId(rootToken.getProcessInstance().getId());
        token.setStartTime(rootToken.getStart());
        token.setTokenId(rootToken.getId());
        if (!hidesubprocess) {
            SearchRequestBuilder bld = this.client.prepareSearch(new String[]{"wfs"});
            this.esProcessHelper.addResultProperties(bld);
            BoolQueryBuilder filterBuilder = new BoolQueryBuilder().must((QueryBuilder)QueryBuilders.termQuery((String)"superProcessTokenId", (long)rootToken.getId())).must((QueryBuilder)QueryBuilders.termQuery((String)"isActive", (boolean)true));
            bld.setPostFilter((QueryBuilder)filterBuilder);
            SearchResponse resp = (SearchResponse)bld.execute().actionGet(this.readTimeoutMs);
            for (SearchHit hit : resp.getHits().hits()) {
                result.addChild(this.convertProcess("" + this.esProcessHelper.getLongField(hit, "id"), hidesubprocess));
            }
        }
        for (CustomToken child : rootToken.getChildTokens()) {
            WFToken chld = new WFToken();
            this.convertToken(child, chld, result, hidesubprocess);
            token.addChild(chld);
        }
    }

    @Override
    public List<WFSearchResult> expressSearch(SearchCriteria searchCriteria) {
        LOGGER.debug((Object)"Starting expressSearch --> ");
        List searchParameters = searchCriteria.getSearchList();
        ArrayList<SearchParameterBase> sortList = new ArrayList<SearchParameterBase>();
        ArrayList<SearchParameterBase> whereList = new ArrayList<SearchParameterBase>();
        boolean getChildren = false;
        for (SearchParameterBase param : searchParameters) {
            if (param instanceof SortParameter) {
                sortList.add(param);
                continue;
            }
            if (param.getPartialWhereClause() == null) continue;
            if ("getChildren".equalsIgnoreCase(param.getFieldName())) {
                getChildren = true;
                continue;
            }
            whereList.add(param);
        }
        if (getChildren) {
            return this.expressSearchGetChildren(whereList, sortList);
        }
        return this.expressSearchTopLevelProcesses(searchCriteria, whereList, sortList);
    }

    private List<WFSearchResult> expressSearchTopLevelProcesses(SearchCriteria searchCriteria, List<SearchParameterBase> whereList, List<SearchParameterBase> sortList) {
        long topLevelStart = System.currentTimeMillis();
        SearchRequestBuilder bld = this.client.prepareSearch(new String[]{"wfs"});
        this.esProcessHelper.addResultProperties(bld);
        for (SearchParameterBase searchParameterBase : sortList) {
            FieldSortBuilder fieldSortBuilder = SortBuilders.fieldSort((String)WfsEsParameters.mapUIColumnToESProperty(searchParameterBase.getFieldName()));
            fieldSortBuilder.order(SortingOrder.DESCENDING.equals((Object)searchParameterBase.getSortingOrder()) ? SortOrder.DESC : SortOrder.ASC);
            fieldSortBuilder.ignoreUnmapped(true);
            bld.addSort((SortBuilder)fieldSortBuilder);
        }
        bld.setFrom(searchCriteria.getStartingRecordNumber());
        if (searchCriteria.getRecordsCount() > 0) {
            bld.setSize(searchCriteria.getRecordsCount());
        }
        LinkedList<Object> filterBuilders = new LinkedList<Object>();
        if (this.addActiveFilter(whereList)) {
            filterBuilders.add(QueryBuilders.termQuery((String)"isActive", (boolean)true));
        }
        for (SearchParameterBase searchParameterBase : whereList) {
            QueryBuilder queryBuilder = WFSElasticSearchFilterBuilder.getFilterBuilder(searchParameterBase);
            if (queryBuilder == null) continue;
            filterBuilders.add(queryBuilder);
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        for (QueryBuilder queryBuilder : filterBuilders) {
            boolQueryBuilder.must(queryBuilder);
        }
        bld.setPostFilter((QueryBuilder)boolQueryBuilder);
        long l = System.currentTimeMillis();
        SearchResponse resp = (SearchResponse)bld.execute().actionGet(this.readTimeoutMs);
        LOGGER.debug((Object)("actionGet: " + (System.currentTimeMillis() - l) + " ms."));
        ArrayList<WFSearchResult> processes = new ArrayList<WFSearchResult>();
        long totalHits = resp.getHits().totalHits();
        l = System.currentTimeMillis();
        for (SearchHit hit : resp.getHits().hits()) {
            processes.add(this.esProcessHelper.convert(hit, totalHits));
        }
        LOGGER.debug((Object)("Object conversions: " + (System.currentTimeMillis() - l) + " ms."));
        LOGGER.debug((Object)("Total top level expressSearch: " + (System.currentTimeMillis() - topLevelStart) + " ms."));
        return processes;
    }

    private boolean addActiveFilter(List<SearchParameterBase> parameters) {
        for (SearchParameterBase parameter : parameters) {
            if (!"all".equals(parameter.getFieldName())) continue;
            return false;
        }
        return true;
    }

    private BulkProcessor.Listener listener() {
        return new BulkProcessor.Listener(){

            public void beforeBulk(long executionId, BulkRequest request) {
            }

            public void afterBulk(long executionId, BulkRequest request, Throwable e) {
                LOGGER.warn((Object)":(", e);
            }

            public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
                LOGGER.debug((Object)("Bulk request took " + response.getTookInMillis() + "msec"));
                if (response.hasFailures()) {
                    LOGGER.warn((Object)response.buildFailureMessage());
                }
            }
        };
    }

    @Override
    public int expressCount(SearchCriteria criteria) {
        List<WFSearchResult> result = this.expressSearch(criteria);
        return result == null || result.size() == 0 ? 0 : (int)result.get(0).getSearchResultCount();
    }

    public String getColleagueName() {
        return this.getClass().getName();
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.NORMAL;
    }

    public void receive(WorkflowEvent event) {
        if (event instanceof ProcessPersistEvent) {
            this.scheduler.schedule((Callable)new ProcessSaveCallable((ProcessPersistEvent)event));
        }
    }

    private IClusterService getClusterService() {
        if (this.clusterService == null) {
            this.clusterService = (IClusterService)ServiceRegistry.getDefault().lookup(IClusterService.class);
        }
        return this.clusterService;
    }

    private class ProcessSaveCallable
    implements Callable<Void> {
        private ProcessPersistEvent event;

        ProcessSaveCallable(ProcessPersistEvent evt) {
            this.event = evt;
        }

        @Override
        public Void call() throws Exception {
            WorkflowProcess process = this.event.getProcess();
            if (!ProcessFinder.isOwner(process) && !this.event.isDeleted()) {
                return null;
            }
            try {
                if (this.event.isDeleted()) {
                    if (this.event.getProcess().isActive()) {
                        WFSElasticSearchService.this.delete(process.getId());
                    } else {
                        WFSElasticSearchService.this.softDelete(process);
                    }
                } else {
                    WFSElasticSearchService.this.save(process);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)(process + ", failed to persist in ElasticSearch"), (Throwable)e);
            }
            return null;
        }
    }
}

