/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.internal.entity;

import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.ResourceManagementException;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceState;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceUser;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class ResourceProxy
extends Resource {
    private static final long serialVersionUID = -3545838218239201950L;
    private transient Resource resource = null;

    public ResourceProxy() {
    }

    public ResourceProxy(long resourceId) {
        super(resourceId);
    }

    @Override
    public boolean getActive() {
        return this.getResource().getActive();
    }

    @Override
    public void setActive(boolean active) {
        this.getResource().setActive(active);
    }

    @Override
    public ResourceState getAdministrationState() {
        return this.getResource().getAdministrationState();
    }

    @Override
    public void setAdministrationState(ResourceState administrationState) {
        this.getResource().setAdministrationState(administrationState);
    }

    @Override
    public String getConnectionString() {
        return this.getResource().getConnectionString();
    }

    @Override
    public void setConnectionString(String connectionString) {
        this.getResource().setConnectionString(connectionString);
    }

    @Override
    public String getFunctionalType() {
        return this.getResource().getFunctionalType();
    }

    @Override
    public void setFunctionalType(String functionalType) {
        this.getResource().setFunctionalType(functionalType);
    }

    @Override
    public String getHeartbeatConnectionString() {
        return this.getResource().getHeartbeatConnectionString();
    }

    @Override
    public void setHeartbeatConnectionString(String heartbeatConnectionString) {
        this.getResource().setHeartbeatConnectionString(heartbeatConnectionString);
    }

    @Override
    public Long getHeartbeatFrequency() {
        return this.getResource().getHeartbeatFrequency();
    }

    @Override
    public void setHeartbeatFrequency(Long heartbeatFrequency) {
        this.getResource().setHeartbeatFrequency(heartbeatFrequency);
    }

    @Override
    public int getMaxConcurrentUsers() {
        return this.getResource().getMaxConcurrentUsers();
    }

    @Override
    public void setMaxConcurrentUsers(int maxConcurrentUsers) {
        this.getResource().setMaxConcurrentUsers(maxConcurrentUsers);
    }

    @Override
    public String getName() {
        return this.getResource().getName();
    }

    @Override
    public void setName(String name) {
        this.getResource().setName(name);
    }

    @Override
    public String getUserName() {
        return this.getResource().getUserName();
    }

    @Override
    public void setUserName(String userName) {
        this.getResource().setUserName(userName);
    }

    @Override
    public Date getCreateDate() {
        return this.getResource().getCreateDate();
    }

    @Override
    @Deprecated
    public void setCreateDate(Date createDate) {
        this.getResource().setCreateDate(createDate);
    }

    @Override
    public ResourceState getOperationalState() {
        return this.getResource().getOperationalState();
    }

    @Override
    public void setOperationalState(ResourceState operationalState) {
        this.getResource().setOperationalState(operationalState);
    }

    @Override
    public boolean getIgnoreTimeout() {
        return this.getResource().getIgnoreTimeout();
    }

    @Override
    public void setIgnoreTimeout(boolean ignoreTimeout) {
        this.getResource().setIgnoreTimeout(ignoreTimeout);
    }

    @Override
    public ResourceType getResourceType() {
        return this.getResource().getResourceType();
    }

    @Override
    public void setResourceType(ResourceType resourceType) {
        this.getResource().setResourceType(resourceType);
    }

    @Override
    public Set<ResourceGroup> getResourceGroups() {
        return this.getResource().getResourceGroups();
    }

    @Override
    public void setResourceGroups(Set<ResourceGroup> groups) {
        this.getResource().setResourceGroups(groups);
    }

    @Override
    public void removeAllResourceGroups() {
        this.getResource().removeAllResourceGroups();
    }

    @Override
    public void addResourceGroup(ResourceGroup group) {
        this.getResource().addResourceGroup(group);
    }

    @Override
    public void removeResourceGroup(ResourceGroup group) {
        this.getResource().removeResourceGroup(group);
    }

    @Override
    @Deprecated
    public List<ResourceGroup> getOrderedListOfResGroups() {
        return this.getResource().getOrderedListOfResGroups();
    }

    @Override
    @Deprecated
    public void setOrderedListOfResGroups(List<ResourceGroup> orderedListOfResGroups) {
        this.getResource().setOrderedListOfResGroups(orderedListOfResGroups);
    }

    @Override
    public Set<ResourceUser> getUsers() {
        return this.getResource().getUsers();
    }

    @Override
    @Deprecated
    public void setUsers(Set<ResourceUser> userList) {
        this.getResource().setUsers(userList);
    }

    @Override
    public void addUser(ResourceUser user) {
        this.getResource().addUser(user);
    }

    @Override
    public void removeUser(ResourceUser user) {
        this.getResource().removeUser(user);
    }

    @Override
    public int getUserCount() {
        return this.getResource().getUserCount();
    }

    @Override
    public boolean equals(Object obj) {
        return this.getLightWeightResource().equals(obj);
    }

    @Override
    public int hashCode() {
        return this.getLightWeightResource().hashCode();
    }

    @Override
    public ResourceProxy clone() {
        return (ResourceProxy)super.clone();
    }

    @Override
    public String toString() {
        return "[" + this.getId() + "] ";
    }

    private Resource getResource() {
        if (this.resource == null) {
            try {
                ServiceRegistry registry = ServiceRegistry.getDefault();
                this.resource = ((ResourceManagement)registry.lookup(ResourceManagement.class)).getResource(this.getId());
            }
            catch (ResourceManagementException e) {
                this.resource = this.getLightWeightResource();
            }
        }
        return this.resource;
    }

    private Resource getLightWeightResource() {
        return new Resource(this.getId());
    }
}

