/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.internal.resourcegroup;

import com.tandbergtv.workflow.resourcemanager.ActionException;
import com.tandbergtv.workflow.resourcemanager.DataOperationException;
import com.tandbergtv.workflow.resourcemanager.FinderException;
import com.tandbergtv.workflow.resourcemanager.IResourceGroupService;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.internal.IDistributedServiceTaskExecutor;
import com.tandbergtv.workflow.resourcemanager.internal.ILocatorService;
import com.tandbergtv.workflow.resourcemanager.internal.IResourceManagementService;
import com.tandbergtv.workflow.resourcemanager.internal.ResourceManagementService;
import com.tandbergtv.workflow.resourcemanager.internal.resourcegroup.GetAllResourceGroupsCallable;
import com.tandbergtv.workflow.resourcemanager.internal.resourcegroup.GetExternallyAcquiredResourceGroupsByUserCallable;
import com.tandbergtv.workflow.resourcemanager.internal.resourcegroup.GetResourceGroupByTokenCallable;
import com.tandbergtv.workflow.resourcemanager.internal.resourcegroup.GetResourceGroupCallable;
import com.tandbergtv.workflow.resourcemanager.internal.resourcegroup.GetResourceGroupsByResourceCallable;
import com.tandbergtv.workflow.resourcemanager.internal.resourcegroup.GetResourceGroupsByResourceTypeCallable;
import com.tandbergtv.workflow.resourcemanager.internal.resourcegroup.GetVisibleResourceGroupsCallable;
import com.tandbergtv.workflow.resourcemanager.internal.resourcegroup.IsExternallyAcquiredResourceGroupCallable;
import com.tandbergtv.workflow.resourcemanager.internal.resourcegroup.MoveQueueItemDownCallable;
import com.tandbergtv.workflow.resourcemanager.internal.resourcegroup.MoveQueueItemToBottomCallable;
import com.tandbergtv.workflow.resourcemanager.internal.resourcegroup.MoveQueueItemToTopCallable;
import com.tandbergtv.workflow.resourcemanager.internal.resourcegroup.MoveQueueItemUpCallable;
import com.tandbergtv.workflow.resourcemanager.internal.resourcegroup.SetResourceGroupAllocatableCallable;
import com.tandbergtv.workflow.resourcemanager.internal.resourcegroup.SetResourceGroupVisibleCallable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;

public class DistributedResourceGroupService
extends ResourceManagementService
implements IResourceGroupService,
IResourceManagementService {
    @Override
    public List<ResourceGroup> getAllResourceGroups() {
        ArrayList<ResourceGroup> resourceGroupList = new ArrayList<ResourceGroup>();
        GetAllResourceGroupsCallable callable = new GetAllResourceGroupsCallable();
        String failureMessage = "Failed to get all resource groups";
        Collection<List<ResourceGroup>> results = this.getDistributedExecutor().runMultiTask(callable, failureMessage);
        if (results != null) {
            for (List<ResourceGroup> result : results) {
                if (result == null) continue;
                resourceGroupList.addAll(result);
            }
        }
        return resourceGroupList;
    }

    @Override
    public List<ResourceGroup> getVisibleResourceGroups() {
        ArrayList<ResourceGroup> resourceGroupList = new ArrayList<ResourceGroup>();
        GetVisibleResourceGroupsCallable callable = new GetVisibleResourceGroupsCallable();
        String failureMessage = "Failed to get visible resource groups";
        Collection<List<ResourceGroup>> results = this.getDistributedExecutor().runMultiTask(callable, failureMessage);
        if (results != null) {
            for (List<ResourceGroup> result : results) {
                if (result == null) continue;
                resourceGroupList.addAll(result);
            }
        }
        return resourceGroupList;
    }

    @Override
    public ResourceGroup getResourceGroup(long resourceGroupId) throws FinderException {
        Long resourceTypeId = this.getLocatorService().getResourceTypeIdForGroup(resourceGroupId);
        if (resourceTypeId == null) {
            String msg = "Could not find resource group[" + resourceGroupId + "]";
            throw new FinderException(msg);
        }
        ResourceGroup group = null;
        GetResourceGroupCallable callable = new GetResourceGroupCallable(resourceTypeId, resourceGroupId);
        String failureMessage = "Failed to get resource group[" + resourceGroupId + "]";
        try {
            group = this.getDistributedExecutor().runTask(callable, failureMessage, FinderException.class);
        }
        catch (FinderException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.getDistributedExecutor().wrapError(failureMessage, e);
        }
        return group;
    }

    @Override
    public List<ResourceGroup> getResourceGroupsByResourceType(long resourceTypeId) {
        GetResourceGroupsByResourceTypeCallable callable = new GetResourceGroupsByResourceTypeCallable(resourceTypeId);
        String failureMessage = "Failed to get resource groups by type[" + resourceTypeId + "]";
        return this.getDistributedExecutor().runTask(callable, failureMessage);
    }

    @Override
    public List<ResourceGroup> getResourceGroupsByResource(long resourceId) {
        Long resourceTypeId = this.getLocatorService().getResourceTypeIdForResource(resourceId);
        if (resourceTypeId == null) {
            return new ArrayList<ResourceGroup>();
        }
        GetResourceGroupsByResourceCallable callable = new GetResourceGroupsByResourceCallable(resourceTypeId, resourceId);
        String failureMessage = "Failed to get resource groups by resource[" + resourceId + "]";
        return this.getDistributedExecutor().runTask(callable, failureMessage);
    }

    @Override
    public ResourceGroup getResourceGroupByToken(long tokenId) {
        GetResourceGroupByTokenCallable callable = new GetResourceGroupByTokenCallable(tokenId);
        String failureMessage = "Failed to get resource group for token " + tokenId;
        Collection<ResourceGroup> results = this.getDistributedExecutor().runMultiTask(callable, failureMessage);
        if (results != null) {
            for (ResourceGroup result : results) {
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    @Override
    public List<ResourceGroup> getExternallyAcquiredResourceGroupsByUser(String userName) {
        Long resourceTypeId = this.getLocatorService().getResourceTypeIdForDevice("04");
        if (resourceTypeId == null) {
            return new ArrayList<ResourceGroup>();
        }
        GetExternallyAcquiredResourceGroupsByUserCallable callable = new GetExternallyAcquiredResourceGroupsByUserCallable(resourceTypeId, userName);
        String failureMessage = "Failed to get externally acquired resource groups by user " + userName;
        return this.getDistributedExecutor().runTask(callable, failureMessage);
    }

    @Override
    public boolean isExternallyAcquiredResourceGroup(long resourceGroupId) throws FinderException {
        Long resourceTypeId = this.getLocatorService().getResourceTypeIdForGroup(resourceGroupId);
        if (resourceTypeId == null) {
            String msg = "Could not find resource group[" + resourceGroupId + "]";
            throw new FinderException(msg);
        }
        Boolean result = null;
        IsExternallyAcquiredResourceGroupCallable callable = new IsExternallyAcquiredResourceGroupCallable(resourceTypeId, resourceGroupId);
        String failureMessage = "Failed to determine if resource group[" + resourceGroupId + "] is externally acquired";
        try {
            result = this.getDistributedExecutor().runTask(callable, failureMessage, FinderException.class);
        }
        catch (FinderException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.getDistributedExecutor().wrapError(failureMessage, e);
        }
        return result;
    }

    @Override
    public ResourceGroup moveQueueItemToTop(long resourceGroupId, long queueItemId) throws ActionException, FinderException {
        Long resourceTypeId = this.getLocatorService().getResourceTypeIdForGroup(resourceGroupId);
        this.ensureValidQueueOperation(resourceTypeId, resourceGroupId);
        MoveQueueItemToTopCallable callable = new MoveQueueItemToTopCallable(resourceTypeId, resourceGroupId, queueItemId);
        return this.performQueueOperation(callable);
    }

    @Override
    public ResourceGroup moveQueueItemToBottom(long resourceGroupId, long queueItemId) throws ActionException, FinderException {
        Long resourceTypeId = this.getLocatorService().getResourceTypeIdForGroup(resourceGroupId);
        this.ensureValidQueueOperation(resourceTypeId, resourceGroupId);
        MoveQueueItemToBottomCallable callable = new MoveQueueItemToBottomCallable(resourceTypeId, resourceGroupId, queueItemId);
        return this.performQueueOperation(callable);
    }

    @Override
    public ResourceGroup moveQueueItemUp(long resourceGroupId, long queueItemId, long neighborQueueItemId) throws ActionException, FinderException {
        Long resourceTypeId = this.getLocatorService().getResourceTypeIdForGroup(resourceGroupId);
        this.ensureValidQueueOperation(resourceTypeId, resourceGroupId);
        MoveQueueItemUpCallable callable = new MoveQueueItemUpCallable(resourceTypeId, resourceGroupId, queueItemId, neighborQueueItemId);
        return this.performQueueOperation(callable);
    }

    @Override
    public ResourceGroup moveQueueItemDown(long resourceGroupId, long queueItemId, long neighborQueueItemId) throws ActionException, FinderException {
        Long resourceTypeId = this.getLocatorService().getResourceTypeIdForGroup(resourceGroupId);
        this.ensureValidQueueOperation(resourceTypeId, resourceGroupId);
        MoveQueueItemDownCallable callable = new MoveQueueItemDownCallable(resourceTypeId, resourceGroupId, queueItemId, neighborQueueItemId);
        return this.performQueueOperation(callable);
    }

    private void ensureValidQueueOperation(Long resourceTypeId, long resourceGroupId) throws FinderException {
        if (resourceTypeId == null) {
            String msg = "Could not find resource group[" + resourceGroupId + "]";
            throw new FinderException(msg);
        }
    }

    private ResourceGroup performQueueOperation(Callable<ResourceGroup> operation) throws ActionException, FinderException {
        String failureMessage = "Failed to move queue item";
        try {
            return this.getDistributedExecutor().runTask(operation, failureMessage, FinderException.class, ActionException.class);
        }
        catch (FinderException e) {
            throw e;
        }
        catch (ActionException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.getDistributedExecutor().wrapError(failureMessage, e);
        }
    }

    @Override
    public ResourceGroup setResourceGroupQueueUIVisibility(long resourceGroupId, boolean visible) throws FinderException, DataOperationException {
        Long resourceTypeId = this.getLocatorService().getResourceTypeIdForGroup(resourceGroupId);
        if (resourceTypeId == null) {
            String msg = "Could not find resource group[" + resourceGroupId + "]";
            throw new FinderException(msg);
        }
        ResourceGroup group = null;
        SetResourceGroupVisibleCallable callable = new SetResourceGroupVisibleCallable(resourceTypeId, resourceGroupId, visible);
        String failureMessage = "Failed to set resource group queue UI visibility";
        try {
            group = this.getDistributedExecutor().runDataOperationTask(callable, failureMessage, FinderException.class, DataOperationException.class);
        }
        catch (FinderException e) {
            throw e;
        }
        catch (DataOperationException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.getDistributedExecutor().wrapError(failureMessage, e);
        }
        return group;
    }

    @Override
    public List<ResourceGroup> setResourceGroupQueueAllocatability(long resourceGroupId, boolean allocatable) throws FinderException, DataOperationException {
        Long resourceTypeId = this.getLocatorService().getResourceTypeIdForGroup(resourceGroupId);
        if (resourceTypeId == null) {
            String msg = "Could not find resource group[" + resourceGroupId + "]";
            throw new FinderException(msg);
        }
        Collection<List<ResourceGroup>> groups = null;
        SetResourceGroupAllocatableCallable callable = new SetResourceGroupAllocatableCallable(resourceTypeId, resourceGroupId, allocatable);
        String failureMessage = "Failed to set resource group allocatability";
        try {
            groups = this.getDistributedExecutor().runDataOperationMultiTask(callable, failureMessage, FinderException.class, DataOperationException.class);
        }
        catch (FinderException e) {
            throw e;
        }
        catch (DataOperationException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.getDistributedExecutor().wrapError(failureMessage, e);
        }
        ArrayList<ResourceGroup> resourceGroupList = new ArrayList<ResourceGroup>();
        if (groups != null) {
            for (List<ResourceGroup> result : groups) {
                if (result == null) continue;
                resourceGroupList.addAll(result);
            }
        }
        return resourceGroupList;
    }

    @Override
    public String getServiceName() {
        return "DistributedResourceGroupService";
    }

    private IDistributedServiceTaskExecutor getDistributedExecutor() {
        return this.getService(IDistributedServiceTaskExecutor.class);
    }

    private ILocatorService getLocatorService() {
        return this.getService(ILocatorService.class);
    }
}

