/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.util;

import com.tandbergtv.workflow.comm.DeviceType;
import com.tandbergtv.workflow.comm.HTTPDevice;
import com.tandbergtv.workflow.comm.IDevice;
import com.tandbergtv.workflow.comm.TCPDevice;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceConnectionType;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class DeviceTypeUtil {
    private static final Logger LOGGER = Logger.getLogger(DeviceTypeUtil.class);

    public static IDevice createDevice(Resource resource) {
        HTTPDevice device = null;
        ResourceConnectionType rct = resource.getResourceType().getConnectionType();
        LOGGER.debug((Object)("Creating device for resource " + resource.getName()));
        if (rct == ResourceConnectionType.URL) {
            device = new HTTPDevice(resource.getConnectionString(), resource.getName());
        } else if (rct == ResourceConnectionType.IP_PORT) {
            StringTokenizer st = new StringTokenizer(resource.getConnectionString(), ":");
            if (st.hasMoreTokens()) {
                String ipAddress = st.nextToken();
                device = new TCPDevice(ipAddress, resource.getName());
            }
            if (st.hasMoreTokens()) {
                String portNumberString = st.nextToken();
                int portNumber = Integer.parseInt(portNumberString);
                ((TCPDevice)device).setPort(portNumber);
            }
        }
        return device;
    }

    public static IDevice createDevice(String connectionType, String connectionString) {
        HTTPDevice device = null;
        LOGGER.debug((Object)("Creating device for connectionType: " + connectionType + " connectionString: " + connectionString));
        if (connectionType.equals(ResourceConnectionType.URL.getDisplayName())) {
            device = new HTTPDevice(connectionString);
        } else if (connectionType.equals(ResourceConnectionType.IP_PORT.getDisplayName())) {
            StringTokenizer st = new StringTokenizer(connectionString, ":");
            if (st.hasMoreTokens()) {
                String ipAddress = st.nextToken();
                device = new TCPDevice(ipAddress);
            }
            if (st.hasMoreTokens()) {
                String portNumberString = st.nextToken();
                int portNumber = Integer.parseInt(portNumberString);
                ((TCPDevice)device).setPort(portNumber);
            }
        }
        return device;
    }

    public static IDevice createDevice(String connectionType, String connectionString, String connectionOrigin) {
        HTTPDevice device = null;
        LOGGER.debug((Object)("Creating device for connectionType: " + connectionType + " connectionString: " + connectionString));
        if (connectionType.equals(ResourceConnectionType.URL.getDisplayName())) {
            device = new HTTPDevice(connectionString, connectionOrigin);
        } else if (connectionType.equals(ResourceConnectionType.IP_PORT.getDisplayName())) {
            StringTokenizer st = new StringTokenizer(connectionString, ":");
            if (st.hasMoreTokens()) {
                String ipAddress = st.nextToken();
                device = new TCPDevice(ipAddress, connectionOrigin);
            }
            if (st.hasMoreTokens()) {
                String portNumberString = st.nextToken();
                int portNumber = Integer.parseInt(portNumberString);
                ((TCPDevice)device).setPort(portNumber);
            }
        }
        return device;
    }

    public static String getConnectionString(IDevice device) {
        String result = null;
        if (device instanceof HTTPDevice) {
            HTTPDevice httpDevice = (HTTPDevice)device;
            result = httpDevice.getUrl();
        } else if (device instanceof TCPDevice) {
            TCPDevice tcpDevice = (TCPDevice)device;
            result = String.valueOf(tcpDevice.getIP()) + ":" + tcpDevice.getPort();
        }
        return result;
    }

    @Deprecated
    public static IDevice createWorkflowDevice() {
        return DeviceTypeUtil.createDevice(DeviceType.URL.name(), "Deprecated", "WFS");
    }
}

