/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.internal.plugin;

import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.core.service.cache.IMultiValueCacheService;
import com.tandbergtv.workflow.pluginmanager.entities.ResourceGroupDescriptor;
import com.tandbergtv.workflow.pluginmanager.entities.ResourceTypeDescriptor;
import com.tandbergtv.workflow.resourcemanager.FinderException;
import com.tandbergtv.workflow.resourcemanager.ResourceGroupContainer;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.ResourceTypeContainer;
import com.tandbergtv.workflow.resourcemanager.dataaccess.DataAccessObjectFactory;
import com.tandbergtv.workflow.resourcemanager.dataaccess.ResourceGroupDAI;
import com.tandbergtv.workflow.resourcemanager.dataaccess.ResourceTypeDAI;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import com.tandbergtv.workflow.resourcemanager.event.ResourceGroupCachedEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceTypeCachedEvent;
import com.tandbergtv.workflow.resourcemanager.internal.ICloneService;
import com.tandbergtv.workflow.resourcemanager.internal.IHibernatePersistenceService;
import com.tandbergtv.workflow.resourcemanager.internal.ILocatorService;
import com.tandbergtv.workflow.resourcemanager.internal.ResourceManagementService;
import com.tandbergtv.workflow.resourcemanager.internal.event.IEventHandler;
import com.tandbergtv.workflow.resourcemanager.internal.plugin.IPluginDescriptorChangeHandler;
import com.tandbergtv.workflow.resourcemanager.internal.plugin.IPluginDescriptorMergeService;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.hibernate.Session;

public class PluginDescriptorChangeHandler
extends ResourceManagementService
implements IPluginDescriptorChangeHandler {
    private static final Logger LOGGER = Logger.getLogger(PluginDescriptorChangeHandler.class);

    @Override
    public void handleResourceTypeDescriptorChange(ResourceTypeDescriptor descriptor) {
        LOGGER.debug((Object)("Received resource type descriptor change event for " + descriptor));
        String systemId = descriptor.getSystemId();
        ResourceType resourceType = this.getManager().getResourceTypeBySystemId(systemId);
        if (!this.getMergeService().validateResourceTypeDescriptor(descriptor, resourceType)) {
            return;
        }
        if (resourceType == null && this.getClusterService().isMaster()) {
            resourceType = this.getMergeService().mergeResourceType(descriptor, resourceType);
            if (resourceType != null) {
                this.createResourceType(descriptor, resourceType);
            }
        } else if (resourceType != null && this.getClusterService().owner((Object)resourceType.getId()) && (resourceType = this.getMergeService().mergeResourceType(descriptor, resourceType)) != null) {
            this.updateResourceType(descriptor, resourceType);
        }
    }

    private void createResourceType(ResourceTypeDescriptor descriptor, ResourceType resourceType) {
        if ((resourceType = this.saveResourceType(descriptor, resourceType, true)) == null) {
            return;
        }
        ResourceType clone = this.getCloneService().cloneResourceType(resourceType);
        this.getResourceTypeCache().add((Serializable)Long.valueOf(clone.getId()), (Object)clone);
        this.getDistributedEventHandler().handleEvent(new ResourceTypeCachedEvent(clone.getId()));
        LOGGER.info((Object)("resource type" + clone + " was created for plugin: " + descriptor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateResourceType(ResourceTypeDescriptor descriptor, ResourceType resourceType) {
        ResourceTypeContainer container = (ResourceTypeContainer)this.getResourceTypeContainerCache().get((Serializable)Long.valueOf(resourceType.getId()));
        String name = "resource type" + resourceType.toString();
        if (container == null || container.isStopped()) {
            LOGGER.error((Object)("Failed to update " + name + " for plugin: " + descriptor + ", resource type is not in local cache."));
            return;
        }
        container.getWriteLock().lock();
        try {
            if (container.isStopped()) {
                LOGGER.error((Object)("Failed to update " + container + " for plugin: " + descriptor + ", resource type is not in local cache."));
                return;
            }
            if ((resourceType = this.saveResourceType(descriptor, resourceType, false)) != null) {
                container.performMaintenance(descriptor, resourceType);
            }
        }
        finally {
            container.getWriteLock().unlock();
        }
        LOGGER.info((Object)(container + " was updated for plugin: " + descriptor));
    }

    private ResourceType saveResourceType(ResourceTypeDescriptor descriptor, ResourceType resourceType, boolean create) {
        IHibernatePersistenceService service = this.getPersistenceService();
        ResourceTypeDAI dao = service.getDataAccessObjectFactory().getResourceTypeDAO();
        Session session = service.getCurrentSession();
        service.beginTransaction(session);
        try {
            resourceType = create ? dao.create(resourceType) : dao.update(resourceType);
            service.commitTransaction(session);
        }
        catch (RuntimeException e) {
            service.rollbackTransaction(session);
            String operation = create ? "create" : "update";
            LOGGER.error((Object)("Failed to " + operation + " resource type" + resourceType + " for dynamic plugin " + descriptor), (Throwable)e);
            return null;
        }
        return resourceType;
    }

    @Override
    public void handleResourceGroupDescriptorChange(ResourceGroupDescriptor descriptor) {
        IPluginDescriptorMergeService mergeService;
        LOGGER.debug((Object)("Received resource group descriptor change event for " + descriptor));
        ResourceGroup persistedGroup = null;
        Long resourceTypeId = null;
        IHibernatePersistenceService service = this.getPersistenceService();
        DataAccessObjectFactory factory = service.getDataAccessObjectFactory();
        Session session = service.getCurrentSession();
        service.beginTransaction(session);
        try {
            persistedGroup = factory.getResourceGroupDAO().findByName(descriptor.getName());
            if (persistedGroup != null) {
                resourceTypeId = persistedGroup.getResourceType().getId();
            } else {
                ResourceTypeDAI typeDao = factory.getResourceTypeDAO();
                resourceTypeId = typeDao.findIDBySystemID(descriptor.getSystemId());
            }
            service.commitTransaction(session);
        }
        catch (RuntimeException ex) {
            service.rollbackTransaction(session);
            String msg = "Failed to get resource group from database with name: " + descriptor.getName() + ", cannot process resource group descriptor change.";
            LOGGER.error((Object)msg, (Throwable)ex);
            return;
        }
        ResourceType resourceType = null;
        if (resourceTypeId != null) {
            try {
                resourceType = this.getManager().getResourceType(resourceTypeId);
            }
            catch (FinderException e) {
                throw new RuntimeException("Failed to get resource type[" + resourceTypeId + "] from distributed cache.", e);
            }
        }
        ResourceGroup group = null;
        if (persistedGroup != null) {
            try {
                group = this.getManager().getResourceGroup(persistedGroup.getId());
            }
            catch (FinderException e) {
                throw new RuntimeException("Failed to get resource group" + persistedGroup + " from distributed cache.", e);
            }
        }
        if (!(mergeService = this.getMergeService()).validateResourceGroupDescriptor(descriptor, group)) {
            return;
        }
        if (persistedGroup == null && this.getClusterService().isMaster()) {
            if ((group = mergeService.mergeResourceGroup(descriptor, group, resourceType)) != null) {
                this.createResourceGroup(descriptor, group);
            }
        } else if (persistedGroup != null && this.getClusterService().owner((Object)resourceTypeId) && (group = mergeService.mergeResourceGroup(descriptor, group, resourceType)) != null) {
            this.updateResourceGroup(descriptor, group);
        }
    }

    private void createResourceGroup(ResourceGroupDescriptor descriptor, ResourceGroup group) {
        if ((group = this.saveResourceGroup(descriptor, group, true)) == null) {
            return;
        }
        long resourceTypeId = group.getResourceType().getId();
        this.getLocatorService().setResourceTypeIdForGroup(group.getId(), resourceTypeId);
        ResourceGroup clone = this.getCloneService().cloneResourceGroup(group);
        this.getResourceGroupCache().add((Serializable)Long.valueOf(resourceTypeId), (Object)clone);
        this.getDistributedEventHandler().handleEvent(new ResourceGroupCachedEvent(clone.getId(), resourceTypeId));
        LOGGER.info((Object)("resource group" + clone + " was created for plugin: " + descriptor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateResourceGroup(ResourceGroupDescriptor descriptor, ResourceGroup group) {
        ResourceGroupContainer container = (ResourceGroupContainer)this.getResourceGroupContainerCache().get((Serializable)Long.valueOf(group.getId()));
        String name = "resource group" + group.toString();
        if (container == null) {
            LOGGER.error((Object)("Failed to update " + name + " for plugin: " + descriptor + ", resource group not in local cache."));
            return;
        }
        container.getWriteLock().lock();
        try {
            if (container.isStopped()) {
                LOGGER.error((Object)("Failed to update " + container + " for plugin: " + descriptor + ", resource group not in local cache."));
                return;
            }
            if ((group = this.saveResourceGroup(descriptor, group, false)) != null) {
                container.performMaintenance(descriptor, group);
            }
        }
        finally {
            container.getWriteLock().unlock();
        }
        LOGGER.info((Object)(container + " was updated for plugin: " + descriptor));
    }

    private ResourceGroup saveResourceGroup(ResourceGroupDescriptor descriptor, ResourceGroup group, boolean create) {
        IHibernatePersistenceService service = this.getPersistenceService();
        ResourceGroupDAI dao = service.getDataAccessObjectFactory().getResourceGroupDAO();
        Session session = service.getCurrentSession();
        service.beginTransaction(session);
        try {
            group = create ? dao.create(group) : dao.update(group);
            service.commitTransaction(session);
        }
        catch (RuntimeException e) {
            service.rollbackTransaction(session);
            String operation = create ? "create" : "update";
            LOGGER.error((Object)("Failed to " + operation + " resource group" + group + " for dynamic plugin " + descriptor), (Throwable)e);
            return null;
        }
        return group;
    }

    private ResourceManagement getManager() {
        return (ResourceManagement)ServiceRegistry.getDefault().lookup(ResourceManagement.class);
    }

    private ICacheService<ResourceType> getResourceTypeCache() {
        return (ICacheService)this.getService("WFS:ResourceTypeCache");
    }

    private ICacheService<ResourceTypeContainer> getResourceTypeContainerCache() {
        return (ICacheService)this.getService("ResourceTypeContainerCache");
    }

    private IMultiValueCacheService<ResourceGroup> getResourceGroupCache() {
        return (IMultiValueCacheService)this.getService("WFS:ResourceGroupCache");
    }

    private ICacheService<ResourceGroupContainer> getResourceGroupContainerCache() {
        return (ICacheService)this.getService("ResourceGroupContainerCache");
    }

    private IHibernatePersistenceService getPersistenceService() {
        return this.getService(IHibernatePersistenceService.class);
    }

    private ILocatorService getLocatorService() {
        return this.getService(ILocatorService.class);
    }

    private IPluginDescriptorMergeService getMergeService() {
        return this.getService(IPluginDescriptorMergeService.class);
    }

    private ICloneService getCloneService() {
        return this.getService(ICloneService.class);
    }

    private IEventHandler getDistributedEventHandler() {
        return (IEventHandler)this.getService("ResourceManagementDistributedEventHandler");
    }
}

