/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.search;

import com.tandbergtv.watchpoint.search.Association;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.watchpoint.search.HQLQuery;
import com.tandbergtv.watchpoint.search.SearchParameter;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.util.SearchCriteria;

public class QueryBuilder {
    protected QueryBuilder() {
    }

    public static QueryBuilder newInstance() {
        return new QueryBuilder();
    }

    public String buildCountQuery(SearchCriteria criteria) {
        SearchParameter e = null;
        for (SearchParameterBase s : criteria.getSearchList()) {
            if (!(s instanceof Entity)) continue;
            e = (Entity)s;
            break;
        }
        String select = "select count(distinct " + e.getCompleteAlias() + ")";
        return select + this.getFromClause(criteria) + this.getWhereClause(criteria);
    }

    public String buildQuery(SearchCriteria criteria) {
        if (criteria.getSearchList() == null || criteria.getSearchList().size() == 0) {
            throw new IllegalArgumentException("Criteria must not be empty");
        }
        String from = this.getFromClause(criteria);
        String select = this.getSelectClause(criteria);
        String where = this.getWhereClause(criteria);
        String orderBy = this.getOrderByClause(criteria);
        return select + from + where + orderBy;
    }

    public String getSelectClause(SearchCriteria criteria) {
        String clause = "";
        for (SearchParameterBase parameter : criteria.getSearchList()) {
            if (!(parameter instanceof Entity)) continue;
            if (clause.length() > 0) {
                clause = clause + ", ";
            }
            clause = clause + ((Entity)Entity.class.cast(parameter)).getSelectClause();
        }
        return (Object)((Object)HQLQuery.SELECT_DISTINCT) + " " + clause + System.getProperty("line.separator");
    }

    public String getFromClause(SearchCriteria criteria) {
        String clause = "";
        int count = 0;
        for (SearchParameterBase parameter : criteria.getSearchList()) {
            if (!(parameter instanceof Entity) && !(parameter instanceof Association)) {
                throw new RuntimeException("Criteria must contain only entities or associations");
            }
            if (parameter instanceof Association) continue;
            Entity p = (Entity)Entity.class.cast(parameter);
            if (clause.length() > 0) {
                clause = clause + ", ";
            }
            clause = clause + p.getPartialFromClause(count++);
        }
        clause = (Object)((Object)HQLQuery.FROM) + clause + System.getProperty("line.separator");
        return clause;
    }

    public String getWhereClause(SearchCriteria criteria) {
        String clause = "";
        for (SearchParameterBase parameter : criteria.getSearchList()) {
            if (!(parameter instanceof Entity) && !(parameter instanceof Association)) {
                throw new RuntimeException("Criteria must contain only entities or associations");
            }
            SearchParameter p = (SearchParameter)SearchParameter.class.cast(parameter);
            String c = p.getPartialWhereClause();
            if (c.trim().length() <= 0) continue;
            if (clause.length() > 0) {
                clause = clause + System.getProperty("line.separator") + "\t" + (Object)((Object)HQLQuery.AND);
            }
            clause = clause + c;
        }
        if (clause.length() > 0) {
            clause = (Object)((Object)HQLQuery.WHERE) + clause + System.getProperty("line.separator");
        }
        return clause;
    }

    public String getOrderByClause(SearchCriteria criteria) {
        String clause = "";
        for (SearchParameterBase parameter : criteria.getSearchList()) {
            if (!(parameter instanceof Entity)) continue;
            Entity e = (Entity)Entity.class.cast(parameter);
            String parameterClause = e.getPartialOrderByClause();
            if (!parameterClause.isEmpty() && !clause.isEmpty()) {
                clause = clause + ",";
            }
            clause = clause + parameterClause;
        }
        if (clause.length() > 0) {
            clause = (Object)((Object)HQLQuery.ORDERBY) + clause;
        }
        return clause;
    }
}

