/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.service.internal;

import com.hazelcast.core.ICompletableFuture;
import com.tandbergtv.workflow.core.service.concurrent.RecoverableFutureWrapper;
import com.tandbergtv.workflow.core.service.concurrent.RecoverableMultiFutureWrapper;
import com.tandbergtv.workflow.core.service.internal.DistributedScheduler;
import com.tandbergtv.workflow.core.service.thread.IRecoverableSchedulerService;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.ITaskCompletionListener;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.core.service.util.SchedulerUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class RecoverableDistributedScheduler<T>
extends DistributedScheduler<T>
implements IRecoverableSchedulerService<T> {
    private static final Logger LOGGER = Logger.getLogger(RecoverableDistributedScheduler.class);
    private final Set<Class<? extends Exception>> recoverableErrors = new CopyOnWriteArraySet<Class<? extends Exception>>();
    private final List<ITaskCompletionListener> listeners = new CopyOnWriteArrayList<ITaskCompletionListener>();
    private static final int MAX_RECOVERY_COUNT = 10;
    private ISchedulerService<Void> recoveryScheduler;
    private int recoverySize = 1;
    private int maximumRetryAttempts = 10;
    private final AtomicInteger queueSize = new AtomicInteger(0);

    public RecoverableDistributedScheduler(String name) {
        super(name);
    }

    public RecoverableDistributedScheduler(String name, int size) {
        super(name, size);
    }

    public RecoverableDistributedScheduler(String name, int size, int recoverySize) {
        this(name, size);
        this.recoverySize = recoverySize;
    }

    @Override
    public Future<T> schedule(Callable<T> callable) {
        ICompletableFuture actual = (ICompletableFuture)SchedulerUtils.submitTask(callable, this.getExecutor(), this.getClusterService());
        LOGGER.debug((Object)(this.getServiceName() + " - Queue Size: " + this.queueSize.incrementAndGet()));
        return ((RecoverableFutureWrapper.RecoverableFutureBuilder)((RecoverableFutureWrapper.RecoverableFutureBuilder)((RecoverableFutureWrapper.RecoverableFutureBuilder)((RecoverableFutureWrapper.RecoverableFutureBuilder)((RecoverableFutureWrapper.RecoverableFutureBuilder)((RecoverableFutureWrapper.RecoverableFutureBuilder)((RecoverableFutureWrapper.RecoverableFutureBuilder)((RecoverableFutureWrapper.RecoverableFutureBuilder)((RecoverableFutureWrapper.RecoverableFutureBuilder)new RecoverableFutureWrapper.RecoverableFutureBuilder().callable(callable)).future(actual).executorService(this.getExecutor())).clusterService(this.getClusterService())).recoveryScheduler(this.recoveryScheduler)).maximumRetryAttempts(this.maximumRetryAttempts)).queueSize(this.queueSize)).listeners(this.listeners)).recoverableErrors(this.recoverableErrors)).serviceName(this.getServiceName())).build();
    }

    @Override
    public Future<Collection<T>> scheduleMulti(Callable<T> callable) {
        Collection actual = this.getExecutor().submitToAllMembers(callable).values();
        LOGGER.debug((Object)(this.getServiceName() + " - Queue Size: " + this.queueSize.incrementAndGet()));
        return ((RecoverableMultiFutureWrapper.RecoverableMultiFutureBuilder)((RecoverableMultiFutureWrapper.RecoverableMultiFutureBuilder)((RecoverableMultiFutureWrapper.RecoverableMultiFutureBuilder)((RecoverableMultiFutureWrapper.RecoverableMultiFutureBuilder)((RecoverableMultiFutureWrapper.RecoverableMultiFutureBuilder)((RecoverableMultiFutureWrapper.RecoverableMultiFutureBuilder)((RecoverableMultiFutureWrapper.RecoverableMultiFutureBuilder)((RecoverableMultiFutureWrapper.RecoverableMultiFutureBuilder)((RecoverableMultiFutureWrapper.RecoverableMultiFutureBuilder)new RecoverableMultiFutureWrapper.RecoverableMultiFutureBuilder().callable(callable)).futures(actual).executorService(this.getExecutor())).clusterService(this.getClusterService())).recoveryScheduler(this.recoveryScheduler)).maximumRetryAttempts(this.maximumRetryAttempts)).queueSize(this.queueSize)).listeners(this.listeners)).recoverableErrors(this.recoverableErrors)).serviceName(this.getServiceName())).build();
    }

    @Override
    public void addRecoverableError(Class<? extends Exception> errorClass) {
        this.recoverableErrors.add(errorClass);
    }

    @Override
    public int getMaximumRetryAttempts() {
        return this.maximumRetryAttempts;
    }

    @Override
    public void setMaximumRetryAttempts(int maximumRetryAttempts) {
        this.maximumRetryAttempts = maximumRetryAttempts;
    }

    @Override
    public void addTaskCompletionListener(ITaskCompletionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeTaskCompletionListener(ITaskCompletionListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void start() {
        super.start();
        String name = this.getServiceName() + "-recovery";
        this.recoveryScheduler = new Scheduler<Void>(name, 1, this.recoverySize);
        this.recoveryScheduler.start();
    }

    @Override
    public void stop() {
        this.recoveryScheduler.stop();
        this.recoveryScheduler = null;
        super.stop();
    }
}

