/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.service.concurrent;

import com.google.common.util.concurrent.AbstractFuture;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.Validate;

public class MultiFuture<T>
extends AbstractFuture<Collection<T>>
implements ExecutionCallback<T> {
    private final Collection<Future<T>> futures;
    private AtomicReference<Throwable> exception = new AtomicReference();
    private Collection<T> result;
    private Lock lock = new ReentrantLock();

    public MultiFuture(Collection<Future<T>> futures) {
        Validate.notEmpty(futures);
        this.futures = futures;
        this.result = new ArrayList<T>(futures.size());
        for (Future<T> f : futures) {
            ((ICompletableFuture)f).andThen((ExecutionCallback)this);
        }
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean isCancelled = false;
        for (Future<T> f : this.futures) {
            isCancelled |= f.cancel(mayInterruptIfRunning);
        }
        return isCancelled ? super.cancel(mayInterruptIfRunning) : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponse(T response) {
        this.lock.lock();
        try {
            this.result.add(response);
            if (this.result.size() == this.futures.size()) {
                this.set(this.result);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void onFailure(Throwable t) {
        if (this.exception.compareAndSet(null, t)) {
            this.setException(t);
        }
    }
}

