/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.service.internal;

import com.tandbergtv.workflow.core.service.internal.DistributedMultiValueCache;
import java.io.Serializable;

public class DistributedOverrideMultiValueCache<T>
extends DistributedMultiValueCache<T> {
    public static final String SUFFIX = ".o-multimap";

    public DistributedOverrideMultiValueCache(String name, int size) {
        super(name, size);
    }

    public DistributedOverrideMultiValueCache(String name) {
        this(name, Integer.MAX_VALUE);
    }

    @Override
    public void start() {
        this.map = this.getClusterService().getInstance().getMultiMap(this.name + SUFFIX);
    }

    @Override
    public boolean add(Serializable key, T value) {
        T old = this.findEqualValue(key, value);
        boolean isAdded = this.map.put((Object)key, value);
        if (isAdded && old != null) {
            this.map.remove((Object)key, value);
        }
        return isAdded;
    }

    @Override
    public boolean remove(Serializable key, T value) {
        return this.map.remove((Object)key, value);
    }
}

