/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.unit.test;

import com.ericsson.neptune.security.NeptunePrincipal;
import com.tandbergtv.workflow.rest.services.test.MockRequest;
import com.tandbergtv.workflow.rest.services.test.MockRequestType;
import com.tandbergtv.workflow.rest.services.test.RESTUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.apache.struts.mock.MockHttpServletRequest;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.JsonMappingException;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.mock.MockDispatcherFactory;
import org.jboss.resteasy.mock.MockHttpRequest;
import org.jboss.resteasy.mock.MockHttpResponse;
import org.jboss.resteasy.plugins.server.resourcefactory.POJOResourceFactory;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.junit.Assert;

public class RESTMockUtil {
    private final POJOResourceFactory factory;
    private static final String BASE_URI = "http://localhost:7070";
    private static final Logger logger = Logger.getLogger(RESTMockUtil.class);

    public RESTMockUtil(Class<?> resourceClass) {
        this.factory = new POJOResourceFactory(resourceClass);
    }

    public List<Map<String, Object>> getResourcesList(String uri, String field) throws JsonProcessingException, IOException {
        MockHttpResponse response = this.executeGet(uri, RESTUtil.setDefaultHeaders());
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Map<String, Object> resourceMap = RESTUtil.deserialize(response);
        return (List)resourceMap.get(field);
    }

    public Map<String, Object> getResponseMap(String uri) throws JsonParseException, JsonMappingException, IOException {
        MockHttpResponse response = this.executeGet(uri, RESTUtil.setDefaultHeaders());
        Assert.assertEquals((long)200L, (long)response.getStatus());
        return RESTUtil.deserialize(response);
    }

    public MockHttpResponse executeGet(String uri, Map<String, String> headers) {
        try {
            return this.execute(uri, headers, MockRequestType.GET, this.factory);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public MockHttpResponse execute(String requestURL, Map<String, String> headers, MockRequestType requestType) throws URISyntaxException {
        return this.execute(requestURL, headers, requestType, this.factory);
    }

    private MockHttpResponse execute(String requestURL, Map<String, String> headers, MockRequestType requestType, POJOResourceFactory resourceFactory) throws URISyntaxException {
        Dispatcher dispatcher = MockDispatcherFactory.createDispatcher();
        dispatcher.getRegistry().addResourceFactory((ResourceFactory)resourceFactory);
        MockHttpRequest request = new MockRequest().create(requestType.toString(), new URI(BASE_URI + requestURL), new URI(BASE_URI));
        logger.info((Object)("Request URL is: " + request.getUri().getRequestUri()));
        for (Map.Entry<String, String> header : headers.entrySet()) {
            request.header(header.getKey(), header.getValue());
        }
        MockHttpServletRequest req = new MockHttpServletRequest();
        NeptunePrincipal nsp = this.getNeptunePrincipal();
        req.setAttribute("neptune_sso_oauth2_principal", (Object)nsp);
        ResteasyProviderFactory.getContextDataMap().put(HttpServletRequest.class, req);
        MockHttpResponse response = new MockHttpResponse();
        dispatcher.invoke((HttpRequest)request, (HttpResponse)response);
        return response;
    }

    private NeptunePrincipal getNeptunePrincipal() {
        NeptunePrincipal nsp = new NeptunePrincipal();
        HashSet<String> roles = new HashSet<String>();
        roles.add("ResourceManagement_View");
        roles.add("ResourceManagement_Create");
        roles.add("ResourceManagement_Delete");
        roles.add("ResourceManagement_Modify");
        nsp.setRoles(roles);
        return nsp;
    }
}

