/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resource.test;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.Member;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceState;
import com.tandbergtv.workflow.test.util.RemoteCmds;
import com.tandbergtv.workflow.test.util.TestUtil;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ClusterStatusResourceTest
extends Assert {
    private static long initialWaitForStartup = 300000L;
    private static final Logger logger = Logger.getLogger(ClusterStatusResourceTest.class);
    private static String localIp;
    private static final String RESOURCE_ID = "CR";
    private ResourceManagement resourceManagement = TestUtil.getResourceManagement();
    private Set<Member> members;
    private int hazelcastPort;
    private List<String> hazelcastIps = new ArrayList<String>();
    private long heartbeatFrequency = 30000L;
    protected static final String SSH_USERNAME = "root";
    protected static final String SSH_PASSWORD = "root1234";
    protected static int sshPort;

    private List<Resource> getCRHazelcastResources() {
        ArrayList<Resource> hzResources = new ArrayList<Resource>();
        List resources = this.resourceManagement.getResourcesBySystemId(RESOURCE_ID);
        for (Resource resource : resources) {
            if (!resource.getHeartbeatConnectionString().contains(":" + this.hazelcastPort)) continue;
            hzResources.add(resource);
        }
        return hzResources;
    }

    @BeforeClass
    public void init() throws UnknownHostException {
        this.members = Hazelcast.newHazelcastInstance().getCluster().getMembers();
        for (Member member : this.members) {
            this.hazelcastPort = member.getInetSocketAddress().getPort();
            logger.info((Object)("Found member ip " + member.getInetSocketAddress().getAddress().getHostAddress() + ", port = " + this.hazelcastPort));
            this.hazelcastIps.add(member.getInetSocketAddress().getAddress().getHostAddress());
        }
        localIp = Inet4Address.getLocalHost().getHostAddress();
        logger.info((Object)("Local Ip = " + localIp));
    }

    @Test(priority=1)
    public void testInitialClusterResourcesStatus() {
        List<Resource> resources = this.getCRHazelcastResources();
        ClusterStatusResourceTest.assertEquals((int)resources.size(), (int)this.members.size(), (String)"Size of CR resources");
        for (Resource r : resources) {
            this.heartbeatFrequency = r.getHeartbeatFrequency() * 1000L > this.heartbeatFrequency ? r.getHeartbeatFrequency() * 1000L : this.heartbeatFrequency;
            logger.info((Object)("Verifying resource " + r.getName() + " Administation state " + r.getAdministrationState() + " Operational state " + r.getOperationalState() + " Heartbeat Frequency = " + r.getHeartbeatFrequency()));
            String name = r.getName().substring(r.getName().indexOf("_") + 1);
            name = name.substring(0, name.indexOf(":"));
            ClusterStatusResourceTest.assertTrue((boolean)this.hazelcastIps.contains(name), (String)(r.getName() + " is hazelcast member"));
            ClusterStatusResourceTest.assertEquals((String)r.getAdministrationState().toString(), (String)ResourceState.ONLINE.toString(), (String)("Administation state of " + r.getName()));
            ClusterStatusResourceTest.assertEquals((String)r.getOperationalState().toString(), (String)ResourceState.ONLINE.toString(), (String)("Operational state of " + r.getName()));
        }
    }

    @Test(priority=2)
    public void testClusterResourcesStatusOnStutdown() throws Exception {
        for (String ip : this.hazelcastIps) {
            if (localIp.equals(ip)) continue;
            this.stopCms(ip);
        }
        Thread.sleep(this.heartbeatFrequency + 5000L);
        List<Resource> resources = this.getCRHazelcastResources();
        ClusterStatusResourceTest.assertEquals((int)resources.size(), (int)this.hazelcastIps.size(), (String)"Size of CR resources");
        for (Resource r : resources) {
            if (r.getName().contains(localIp)) {
                ClusterStatusResourceTest.assertEquals((String)r.getAdministrationState().toString(), (String)ResourceState.ONLINE.toString(), (String)("Administation state of " + r.getName()));
                ClusterStatusResourceTest.assertEquals((String)r.getOperationalState().toString(), (String)ResourceState.ONLINE.toString(), (String)("Operational state of " + r.getName()));
                continue;
            }
            ClusterStatusResourceTest.assertEquals((String)r.getAdministrationState().toString(), (String)ResourceState.ONLINE.toString(), (String)("Administation state of " + r.getName()));
            ClusterStatusResourceTest.assertEquals((String)r.getOperationalState().toString(), (String)ResourceState.HEARTBEAT_ERROR.toString(), (String)("Operational state of " + r.getName()));
        }
    }

    @Test(priority=3)
    public void testClusterResourcesStatusOnNodeRejoin() throws Exception {
        for (String ip : this.hazelcastIps) {
            if (localIp.equals(ip)) continue;
            this.startCms(ip);
        }
        Thread.sleep(initialWaitForStartup);
        List<Resource> resources = this.getCRHazelcastResources();
        ClusterStatusResourceTest.assertEquals((int)resources.size(), (int)this.hazelcastIps.size(), (String)"Size of CR resources");
        for (Resource r : resources) {
            ClusterStatusResourceTest.assertEquals((String)r.getAdministrationState().toString(), (String)ResourceState.ONLINE.toString(), (String)("Administation state of " + r.getName()));
            ClusterStatusResourceTest.assertEquals((String)r.getOperationalState().toString(), (String)ResourceState.ONLINE.toString(), (String)("Operational state of " + r.getName()));
        }
    }

    private void stopCms(String ip) throws Exception {
        this.serviceCms(ip, "stop");
    }

    private void startCms(String ip) throws Exception {
        this.serviceCms(ip, "start");
    }

    private void serviceCms(String ip, String action) throws Exception {
        logger.info((Object)(action + "ing CMS on " + ip));
        RemoteCmds remote = new RemoteCmds(ip, SSH_USERNAME, SSH_PASSWORD, sshPort);
        remote.runCmd("service cms " + action);
    }

    static {
        sshPort = 22;
    }
}

