/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.test;

import com.tandbergtv.workflow.test.SingleStandaloneTestBase;
import com.tandbergtv.workflow.test.util.ESTransportClient;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.common.unit.TimeValue;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class HistoryLogRetentionTest
extends SingleStandaloneTestBase {
    private static final Logger LOGGER = Logger.getLogger(HistoryLogRetentionTest.class);
    private static final TimeValue TIMEOUT = TimeValue.timeValueSeconds((long)5L);
    private static final String INDEX_PREFIX = "history_logs_";
    private static final int RETENTION_WINDOW_IN_DAYS = 30;
    private static final int NUMBER_OF_INDICES_TO_CREATE = 20;
    private AdminClient adminClient;

    @BeforeClass
    public void prepareIndices() throws InterruptedException, IOException {
        this.adminClient = ESTransportClient.getTransportClient().admin();
        LOGGER.debug((Object)"Creating indicies to be deleted");
        for (int i = 1; i <= 20; ++i) {
            try {
                String indexDate = this.getIndexDateString(i);
                CreateIndexResponse response = (CreateIndexResponse)this.adminClient.indices().prepareCreate(INDEX_PREFIX + indexDate).get(TIMEOUT);
                HistoryLogRetentionTest.assertTrue((boolean)response.isAcknowledged());
                continue;
            }
            catch (Throwable t) {
                HistoryLogRetentionTest.fail((String)"An error was thrown while creating the indices", (Throwable)t);
            }
        }
        this.start();
        TimeUnit.SECONDS.sleep(60L);
    }

    @AfterClass(alwaysRun=true)
    public void cleanup() {
        try {
            for (String index : this.getHistoryIndices()) {
                if (!this.shouldBeDeleted(index)) continue;
                LOGGER.debug((Object)("Deleting process history index : " + index));
                this.adminClient.indices().delete(new DeleteIndexRequest(index));
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)"There was an error when getting the list of indices.", (Throwable)e);
        }
        this.stop();
    }

    @Test
    public void testVerifyOldIndicesDeletedOnStartup() {
        try {
            for (String index : this.getHistoryIndices()) {
                LOGGER.info((Object)("remaining log index after deletion: " + index));
                HistoryLogRetentionTest.assertTrue((!this.shouldBeDeleted(index) ? 1 : 0) != 0, (String)("log index[" + index + "] should be deleted"));
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)"There was an error when getting the list of indices.", (Throwable)e);
        }
    }

    private String getIndexDateString(int offset) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -(30 + offset));
        return new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime());
    }

    private Date getCutoffDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -31);
        return calendar.getTime();
    }

    private boolean shouldBeDeleted(String fullIndex) {
        String indexString = fullIndex.substring(INDEX_PREFIX.length());
        try {
            Date indexDate = new SimpleDateFormat("yyyy-MM-dd").parse(indexString);
            if (indexDate.before(this.getCutoffDate())) {
                return true;
            }
        }
        catch (ParseException e) {
            LOGGER.warn((Object)("There was an error parsing the date format of the index " + fullIndex));
        }
        return false;
    }

    private List<String> getHistoryIndices() {
        ArrayList<String> historyIndices = new ArrayList<String>();
        for (String index : ((ClusterStateResponse)this.adminClient.cluster().prepareState().get(TIMEOUT)).getState().getMetaData().concreteAllIndices()) {
            if (!index.contains(INDEX_PREFIX)) continue;
            historyIndices.add(index);
        }
        return historyIndices;
    }
}

