/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.rest.services.test;

import com.google.common.base.Preconditions;
import javax.ws.rs.core.UriBuilder;

public abstract class AbstractQueryBuilder {
    protected String baseUrl;
    protected String path;
    protected String detail;
    protected int start;
    protected int count;
    protected String order;
    protected String sort;
    protected UriBuilder ub;

    protected AbstractQueryBuilder(String baseUrl, String path) {
        this.baseUrl = (String)Preconditions.checkNotNull((Object)baseUrl);
        this.path = (String)Preconditions.checkNotNull((Object)path);
        this.start = 0;
        this.count = 10;
        this.ub = UriBuilder.fromUri((String)baseUrl).path(path);
    }

    public AbstractQueryBuilder start(int start) {
        this.start = start;
        this.ub.queryParam("start", new Object[]{this.start});
        return this;
    }

    public AbstractQueryBuilder count(int count) {
        this.count = count;
        this.ub.queryParam("count", new Object[]{this.count});
        return this;
    }

    public AbstractQueryBuilder order(String order) {
        this.order = order;
        this.ub.queryParam("order", new Object[]{this.order});
        return this;
    }

    public AbstractQueryBuilder sortBy(String sort) {
        this.sort = sort;
        this.ub.queryParam("sort", new Object[]{this.sort});
        return this;
    }

    public AbstractQueryBuilder detail(String detail) {
        this.detail = (String)Preconditions.checkNotNull((Object)detail);
        this.ub = this.ub.queryParam("detail", new Object[]{this.detail});
        return this;
    }

    public abstract String build();
}

