/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.unit.test;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.monitor.core.alarm.AlarmNotification;
import com.tandbergtv.workflow.monitor.core.alarm.AlarmSeverity;
import com.tandbergtv.workflow.monitor.core.alarm.IAlarmNotificationService;
import com.tandbergtv.workflow.monitor.core.alarm.Intent;
import com.tandbergtv.workflow.monitor.core.alarm.IntentAction;
import com.tandbergtv.workflow.monitor.core.alarm.IntentOperation;
import com.tandbergtv.workflow.monitor.internal.AlarmNotificationService;
import com.tandbergtv.workflow.rest.services.AlarmsResource;
import com.tandbergtv.workflow.unit.test.RESTMockUtil;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ServiceRegistry.class})
public class AlarmsResourceUnitTest {
    private static RESTMockUtil restUtil;
    private static ServiceRegistry registry;
    private static IAlarmNotificationService alarmsService;
    private static String CUT_OFF_DATE;
    public static final String ALARMS_START_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String BASE_API_PATH = "/alarms";
    public static final String VAR_TITLE_ID = "titleId";
    public static final String VAR_TITLE_BRIEF = "titleBrief";
    public static final String VAR_ANNOTATIONS = "annotations";
    private static final String START_TIME = "startTime";
    private static final String TITLE_BRIEF = "Test Title";
    private static final String ALARM_TYPE_ERROR = "UNHANDLED_EXCEPTION";
    private static final String ALARM_TYPE_INFORMATIONAL = "ManualTask";
    private static final String ALARM_MESSAGE_ERROR = "failed during distribution";
    private static final String ALARM_MESSAGE_INFORMATIONAL = "has a pending task";
    private static final String RECOVERY_URL = "http://app:7070/dummy";

    public AlarmsResourceUnitTest() {
        restUtil = new RESTMockUtil(AlarmsResource.class);
    }

    @Before
    public void setup() throws Exception {
        registry = (ServiceRegistry)Mockito.mock(ServiceRegistry.class);
        alarmsService = (IAlarmNotificationService)Mockito.mock(AlarmNotificationService.class);
        PowerMockito.stub((Method)PowerMockito.method(ServiceRegistry.class, (String)"getDefault", (Class[])new Class[0])).toReturn((Object)registry);
        Mockito.when((Object)registry.lookup(IAlarmNotificationService.class)).thenReturn((Object)alarmsService);
    }

    @Test
    public void testalarms() throws Exception {
        ArrayList<AlarmNotification> alarms = new ArrayList<AlarmNotification>();
        alarms.add(this.createErrorAlarm());
        alarms.add(this.createInformationalAlarm());
        Mockito.when((Object)alarmsService.getAlarms(AlarmsResourceUnitTest.getStartTimeFormatter().parse(CUT_OFF_DATE).getTime())).thenReturn(alarms);
        String response = restUtil.executeGet(this.getUrl(), new HashMap<String, String>()).getContentAsString();
        List responseList = (List)new ObjectMapper().readValue(response, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
        Assert.assertEquals((long)2L, (long)responseList.size());
        Assert.assertTrue((boolean)this.isOrdered(this.getTimeStampList(responseList)));
        for (int i = 0; i < responseList.size(); ++i) {
            Map alarmsMap = (Map)responseList.get(i);
            if (alarmsMap.get("severity").equals(AlarmSeverity.Informational.toString())) {
                Assert.assertEquals(alarmsMap.get("objectId"), (Object)("Test Title " + AlarmSeverity.Informational.toString()));
                Assert.assertEquals(alarmsMap.get("type"), (Object)ALARM_TYPE_INFORMATIONAL);
                Assert.assertTrue((boolean)alarmsMap.get("message").toString().contains(ALARM_MESSAGE_INFORMATIONAL));
                this.verifyAlarms(alarmsMap);
            }
            if (!alarmsMap.get("severity").equals(AlarmSeverity.Error.toString())) continue;
            Assert.assertEquals(alarmsMap.get("objectId"), (Object)("Test Title " + AlarmSeverity.Error.toString()));
            Assert.assertEquals(alarmsMap.get("type"), (Object)ALARM_TYPE_ERROR);
            Assert.assertTrue((boolean)alarmsMap.get("message").toString().contains(ALARM_MESSAGE_ERROR));
            this.verifyAlarms(alarmsMap);
        }
    }

    @Test
    public void testalarmsInvalidStartTime() throws Exception {
        Assert.assertEquals((long)400L, (long)restUtil.executeGet(this.getInvalidStartTimeUrl(), new HashMap<String, String>()).getStatus());
    }

    @Test
    public void testalarmsThrowException() throws Exception {
        Mockito.when((Object)alarmsService.getAlarms(AlarmsResourceUnitTest.getStartTimeFormatter().parse(CUT_OFF_DATE).getTime())).thenThrow(new Throwable[]{new RuntimeException()});
        Assert.assertEquals((long)500L, (long)restUtil.executeGet(this.getUrl(), new HashMap<String, String>()).getStatus());
    }

    private AlarmNotification createErrorAlarm() throws ParseException, URISyntaxException {
        AlarmNotification notification = new AlarmNotification((Object)1, 1L, AlarmSeverity.Error, ALARM_TYPE_ERROR, System.currentTimeMillis(), "Test", this.getProcessData(AlarmSeverity.Error), "Test Task");
        notification.addAction(Intent.newInstance((IntentOperation)IntentOperation.Restart, (IntentAction)IntentAction.Command, (URI)new URI(RECOVERY_URL)));
        return notification;
    }

    private AlarmNotification createInformationalAlarm() throws ParseException, URISyntaxException {
        AlarmNotification notification = new AlarmNotification((Object)2, 2L, AlarmSeverity.Informational, ALARM_TYPE_INFORMATIONAL, System.currentTimeMillis(), "Test", this.getProcessData(AlarmSeverity.Informational), "Test Task");
        notification.addAction(Intent.newInstance((IntentOperation)IntentOperation.Restart, (IntentAction)IntentAction.Command, (URI)new URI(RECOVERY_URL)));
        return notification;
    }

    private static String getCurrentDate() {
        return AlarmsResourceUnitTest.getStartTimeFormatter().format(new Date());
    }

    private static DateFormat getStartTimeFormatter() {
        return new SimpleDateFormat(ALARMS_START_TIME_FORMAT);
    }

    private HashMap<String, Object> getProcessData(AlarmSeverity severity) {
        HashMap<String, Object> processData = new HashMap<String, Object>();
        String titleId = "1";
        String titleBrief = "Test Title " + severity.toString();
        ArrayList<String> annotations = new ArrayList<String>();
        annotations.add("@Category(\"Distribution\")");
        processData.put(VAR_TITLE_ID, titleId);
        processData.put(VAR_TITLE_BRIEF, titleBrief);
        processData.put(VAR_ANNOTATIONS, annotations);
        return processData;
    }

    private String getUrl() {
        UriBuilder builder = UriBuilder.fromPath((String)BASE_API_PATH);
        builder.queryParam(START_TIME, new Object[]{CUT_OFF_DATE});
        return builder.build(new Object[0]).toASCIIString();
    }

    private String getInvalidStartTimeUrl() {
        UriBuilder builder = UriBuilder.fromPath((String)BASE_API_PATH);
        builder.queryParam(START_TIME, new Object[]{"2016/06/06"});
        return builder.build(new Object[0]).toASCIIString();
    }

    private boolean isOrdered(List<Long> timeStampList) {
        return Ordering.natural().reverse().isStrictlyOrdered(timeStampList);
    }

    private List<Long> getTimeStampList(List<Map<String, Object>> resources) {
        return new ArrayList<Long>(Lists.transform(resources, this.idMapper()));
    }

    private Function<Map<String, Object>, Long> idMapper() {
        return new Function<Map<String, Object>, Long>(){

            public Long apply(Map<String, Object> map) {
                return ((Number)Number.class.cast(map.get("time"))).longValue();
            }
        };
    }

    private void verifyAlarms(Map<String, Object> alarmsMap) {
        Assert.assertTrue((boolean)alarmsMap.get("detailedMessage").toString().isEmpty());
        List recoveryOptions = (List)alarmsMap.get("recoveryOptions");
        for (Map recoveryOption : recoveryOptions) {
            Assert.assertEquals((Object)recoveryOption.get("name").toString(), (Object)"Restart the Work Order");
            Assert.assertEquals((Object)recoveryOption.get("type").toString(), (Object)IntentAction.Command.toString());
            Assert.assertEquals((Object)recoveryOption.get("url").toString(), (Object)RECOVERY_URL);
            Map parameters = (Map)recoveryOption.get("parameters");
            Assert.assertEquals((Object)parameters.get("operation").toString(), (Object)IntentOperation.Restart.toString());
        }
    }

    static {
        CUT_OFF_DATE = AlarmsResourceUnitTest.getCurrentDate();
    }
}

