/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.rest.services.test;

import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.rest.services.internal.ProcessesResource;
import com.tandbergtv.workflow.rest.services.test.MockRequestType;
import com.tandbergtv.workflow.rest.services.test.RESTServiceMockTestBase;
import com.tandbergtv.workflow.rest.services.test.RESTUtil;
import com.tandbergtv.workflow.test.util.ProcessUtils;
import com.tandbergtv.workflow.test.util.ResourceUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.jboss.resteasy.mock.MockHttpResponse;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"sequential"})
public class ProcessesStatisticsTest
extends RESTServiceMockTestBase {
    private static final String BASE_API_PATH = "/processes/statistics";
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String STAUS_CREATED = "created";
    private static final String STAUS_BUSY = "busy";
    private static final String STAUS_RUNNING = "running";
    private static final String STAUS_PAUSED = "paused";
    private static final String STAUS_COMPLETED = "completed";
    private static final String STAUS_CANCELLED = "cancelled";
    private static final String STAUS_BRANCHED = "branched";
    private static final String STAUS_QUEUED = "queued";
    private static final String STAUS_ERROR = "error";
    private static final int BUSY_PROCESSES_COUNT = 2;
    private static final int PAUSED_PROCESSES_COUNT = 3;
    private static final int COMPLETED_PROCESSES_COUNT = 3;
    private static final int CANCELLED_PROCESSES_COUNT = 1;
    private static final int BRANCHED_PROCESSES_COUNT = 2;
    private static final int ERROR_PROCESSES_COUNT = 2;
    private static final int QUEUED_PROCESSES_COUNT = 3;
    private static final String PROVIDERID_TEMPLATE = "UserTaskTemplate";
    private static final String PROVIDER_ID_PARAM = "providerId=";
    private static final String PROVIDER_ID = "providerId";
    private static final String BRANCHED_TEMPLATE = "branch-fail-template";
    private static final String QUEUED_TEMPLATE = "echo-template";
    private static final String ERROR_TEMPLATE = "FailureTemplate";

    public ProcessesStatisticsTest() {
        super(ProcessesResource.class);
    }

    @AfterClass
    private void setResourceOnline() throws Exception {
        ResourceUtils.setResourcesOnline("27");
    }

    @Test
    public void testStatisticsWithStartDateParam() throws Exception {
        String uuid = this.createProcesses();
        MockHttpResponse response = this.getResponse(PROVIDER_ID_PARAM + uuid + "&" + this.getDateQueryParam());
        ProcessesStatisticsTest.assertEquals((int)response.getStatus(), (int)200);
        this.verifyResponse(response);
    }

    @Test
    public void testStatisticsWithProviderId() throws Exception {
        String uuid = this.createProcesses();
        MockHttpResponse response = this.getResponse(PROVIDER_ID_PARAM + uuid);
        ProcessesStatisticsTest.assertEquals((int)response.getStatus(), (int)200);
        this.verifyResponse(response);
    }

    private String getDateQueryParam() {
        return "start=" + new SimpleDateFormat(DATE_FORMAT).format(new Date());
    }

    private void createPausedProcessesWithProviderId(String template, Map<String, Object> parameters) throws Exception {
        for (int i = 0; i < 3; ++i) {
            WorkflowProcess process = this.run(template, parameters);
            ProcessUtils.sleepUntilStatus(process.getId(), 60000L, ProcessStatus.BUSY);
            ProcessUtils.pause(process);
            ProcessesStatisticsTest.assertTrue((boolean)ProcessUtils.sleepUntilStatus(process.getId(), 180000L, ProcessStatus.PAUSED));
        }
    }

    private void createCancelledProcessesWithProviderId(String template, Map<String, Object> parameters) throws Exception {
        for (int i = 0; i < 1; ++i) {
            WorkflowProcess process = this.run(template, parameters);
            ProcessUtils.sleepUntilStatus(process.getId(), 60000L, ProcessStatus.BUSY);
            ProcessUtils.cancel(process);
            ProcessesStatisticsTest.assertTrue((boolean)ProcessUtils.sleepUntilStatus(process.getId(), 15000L, ProcessStatus.CANCELLED));
        }
    }

    private void createCompletedProcessesWithProviderId(String template, Map<String, Object> parameters) throws Exception {
        for (int i = 0; i < 3; ++i) {
            WorkflowProcess process = this.run(template, parameters);
            ProcessesStatisticsTest.assertTrue((boolean)ProcessUtils.sleepUntilStatus(process.getId(), 60000L, ProcessStatus.BUSY));
            ProcessUtils.performManualTask(ProcessUtils.get(process.getId()));
            ProcessesStatisticsTest.assertTrue((boolean)ProcessUtils.sleepUntilStatus(process.getId(), 15000L, ProcessStatus.COMPLETED));
        }
    }

    private MockHttpResponse getResponse(String url) throws URISyntaxException {
        return this.execute("/processes/statistics?" + url, RESTUtil.setDefaultHeaders(), MockRequestType.GET);
    }

    private String createProcesses() throws Exception {
        ResourceUtils.setResourcesOffline("27");
        String uuid = UUID.randomUUID().toString();
        this.createPausedProcessesWithProviderId(PROVIDERID_TEMPLATE, Collections.singletonMap(PROVIDER_ID, uuid));
        this.createCancelledProcessesWithProviderId(PROVIDERID_TEMPLATE, Collections.singletonMap(PROVIDER_ID, uuid));
        this.createCompletedProcessesWithProviderId(PROVIDERID_TEMPLATE, Collections.singletonMap(PROVIDER_ID, uuid));
        this.createProcessesWithGivenStatus(2, BRANCHED_TEMPLATE, Collections.singletonMap(PROVIDER_ID, uuid), 5000L, ProcessStatus.BRANCHED);
        this.createProcessesWithGivenStatus(2, ERROR_TEMPLATE, Collections.singletonMap(PROVIDER_ID, uuid), 5000L, ProcessStatus.ERROR);
        this.createProcessesWithGivenStatus(3, QUEUED_TEMPLATE, Collections.singletonMap(PROVIDER_ID, uuid), 5000L, ProcessStatus.QUEUED);
        this.createProcessesWithGivenStatus(2, PROVIDERID_TEMPLATE, Collections.singletonMap(PROVIDER_ID, uuid), 60000L, ProcessStatus.BUSY);
        TimeUnit.SECONDS.sleep(30L);
        return uuid;
    }

    private void verifyResponse(MockHttpResponse response) throws JsonParseException, JsonMappingException, IOException {
        Map<String, Object> responseMap = RESTUtil.deserialize(response);
        ProcessesStatisticsTest.assertEquals((Object)responseMap.get(STAUS_BUSY), (Object)String.valueOf(2));
        ProcessesStatisticsTest.assertEquals((Object)responseMap.get(STAUS_PAUSED), (Object)String.valueOf(3));
        ProcessesStatisticsTest.assertEquals((Object)responseMap.get(STAUS_CANCELLED), (Object)String.valueOf(1));
        ProcessesStatisticsTest.assertEquals((Object)responseMap.get(STAUS_COMPLETED), (Object)String.valueOf(3));
        ProcessesStatisticsTest.assertEquals((Object)responseMap.get(STAUS_BRANCHED), (Object)String.valueOf(2));
        ProcessesStatisticsTest.assertEquals((Object)responseMap.get(STAUS_QUEUED), (Object)String.valueOf(3));
        ProcessesStatisticsTest.assertEquals((Object)responseMap.get(STAUS_ERROR), (Object)String.valueOf(2));
        ProcessesStatisticsTest.assertEquals((Object)responseMap.get(STAUS_CREATED), (Object)"0");
        ProcessesStatisticsTest.assertEquals((Object)responseMap.get(STAUS_RUNNING), (Object)"0");
    }

    private void createProcessesWithGivenStatus(int count, String template, Map<String, Object> parameters, long timeout, ProcessStatus status) throws Exception {
        for (int i = 0; i < count; ++i) {
            WorkflowProcess process = this.run(template, parameters);
            ProcessesStatisticsTest.assertTrue((boolean)ProcessUtils.sleepUntilStatus(process.getId(), timeout, status));
        }
    }
}

