/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.test.util;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.Session;
import com.trilead.ssh2.StreamGobbler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class RemoteCmds {
    Connection conn;
    Session sess;
    StringBuilder sb;
    String command;
    InputStream stdout;
    InputStream stderr;
    BufferedReader stdoutReader;
    BufferedReader stderrReader;
    private final long EXIT_SIGNAL_TIMEOUT = 10000L;
    private String ipAddress;
    private String sshUsername;
    private String sshPassword;
    private int port;

    public RemoteCmds() {
    }

    public RemoteCmds(String ipAddress, String sshUsername, String sshPassword) {
        this.connect(ipAddress, sshUsername, sshPassword);
    }

    public RemoteCmds(String ipAddress, String sshUsername, String sshPassword, int port) {
        this.connect(ipAddress, sshUsername, sshPassword, port);
    }

    public void connect(String ipAddress, String sshUsername, String sshPassword) {
        this.connect(ipAddress, sshUsername, sshPassword, 22);
    }

    public void connect(String ipAddress, String sshUsername, String sshPassword, int port) {
        this.ipAddress = ipAddress;
        this.sshUsername = sshUsername;
        this.sshPassword = sshPassword;
        this.port = port;
        try {
            this.conn = new Connection(ipAddress, port);
            this.conn.connect();
            boolean isAuthenticated = this.conn.authenticateWithPassword(sshUsername, sshPassword);
            if (!isAuthenticated) {
                throw new IOException("Authentication failed.");
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            System.exit(2);
        }
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getSshUsername() {
        return this.sshUsername;
    }

    public String getSshPassword() {
        return this.sshPassword;
    }

    public int getPort() {
        return this.port;
    }

    @Deprecated
    public String runCommand(String cmd) {
        return this.runCommand(cmd, false);
    }

    @Deprecated
    public String runCommand(String cmd, boolean isSilent) {
        try {
            this.openSessionExecuteCmd(cmd);
            String result = this.readOutput(isSilent);
            this.sess.close();
            return result;
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            return e.toString();
        }
    }

    public String runCmd(String cmd, boolean isSilent) throws Exception {
        this.openSessionExecuteCmd(cmd);
        String result = this.readOutput(isSilent);
        this.sess.waitForCondition(64, 10000L);
        Integer exitStatus = this.sess.getExitStatus();
        this.sess.close();
        if (exitStatus == null || exitStatus != 0) {
            throw new Exception(cmd + "\nRemote command executed unsuccessfully, exit status = " + exitStatus + ": " + result);
        }
        return result;
    }

    public String runCmd(String cmd) throws Exception {
        return this.runCmd(cmd, false);
    }

    private String readOutput(boolean isSilent) throws IOException {
        String line;
        this.sb = new StringBuilder();
        String lineSep = System.getProperty("line.separator");
        this.stdout = new StreamGobbler(this.sess.getStdout());
        this.stderr = new StreamGobbler(this.sess.getStderr());
        this.stdoutReader = new BufferedReader(new InputStreamReader(this.stdout));
        this.stderrReader = new BufferedReader(new InputStreamReader(this.stderr));
        while ((line = this.stdoutReader.readLine()) != null) {
            this.sb.append(String.valueOf(line) + lineSep);
            if (isSilent) continue;
            System.out.println(String.valueOf(line));
        }
        while ((line = this.stderrReader.readLine()) != null) {
            String err = "Error: " + line;
            System.out.println(err);
            this.sb.append(err);
        }
        this.stdoutReader.close();
        this.stderrReader.close();
        this.stdout.close();
        this.stderr.close();
        return this.sb.toString();
    }

    private void openSessionExecuteCmd(String cmd) throws IOException {
        this.sess = this.conn.openSession();
        this.sess.execCommand(cmd);
    }

    public void runProcess(String cmd) {
        try {
            this.openSessionExecuteCmd(cmd);
            this.sess.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void runProcess(String cmd, long wait) {
        try {
            this.openSessionExecuteCmd(cmd);
            Thread.sleep(wait);
            this.sess.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public Session openSession() throws IOException {
        return this.conn.openSession();
    }

    public void disconnect() {
        this.conn.close();
    }
}

