/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.rest.services.test;

import com.ericsson.neptune.security.NeptunePrincipal;
import com.tandbergtv.workflow.rest.services.test.MockRequest;
import com.tandbergtv.workflow.rest.services.test.MockRequestType;
import com.tandbergtv.workflow.rest.services.test.RESTUtil;
import com.tandbergtv.workflow.test.WorkflowTestBase;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.apache.struts.mock.MockHttpServletRequest;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.JsonMappingException;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.mock.MockDispatcherFactory;
import org.jboss.resteasy.mock.MockHttpRequest;
import org.jboss.resteasy.mock.MockHttpResponse;
import org.jboss.resteasy.plugins.server.resourcefactory.POJOResourceFactory;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class RESTServiceMockTestBase
extends WorkflowTestBase {
    private final POJOResourceFactory factory;
    protected static final String BASE_URI = "http://localhost:8081";
    private static final Logger logger = Logger.getLogger(RESTServiceMockTestBase.class);

    public RESTServiceMockTestBase(Class<?> resourceClass) {
        this.factory = new POJOResourceFactory(resourceClass);
    }

    protected final POJOResourceFactory getResourceFactory() {
        return this.factory;
    }

    protected List<Map<String, Object>> getResourcesList(String uri, String field) throws JsonProcessingException, IOException {
        MockHttpResponse response = this.executeGet(uri, RESTUtil.setDefaultHeaders());
        RESTServiceMockTestBase.assertEquals((int)response.getStatus(), (int)200);
        Map<String, Object> resourceMap = RESTUtil.deserialize(response);
        return (List)resourceMap.get(field);
    }

    protected Map<String, Object> getResponseMap(String uri) throws JsonParseException, JsonMappingException, IOException {
        MockHttpResponse response = this.executeGet(uri, RESTUtil.setDefaultHeaders());
        RESTServiceMockTestBase.assertEquals((int)response.getStatus(), (int)200);
        return RESTUtil.deserialize(response);
    }

    protected MockHttpResponse executeGet(String uri, Map<String, String> headers) {
        Dispatcher dispatcher = MockDispatcherFactory.createDispatcher();
        dispatcher.getRegistry().addResourceFactory((ResourceFactory)this.factory);
        MockHttpResponse response = null;
        try {
            MockHttpRequest request = new MockRequest().create(MockRequestType.GET.toString(), new URI(uri), new URI(BASE_URI));
            logger.info((Object)("Request URL is: " + request.getUri().getRequestUri()));
            for (Map.Entry<String, String> header : headers.entrySet()) {
                request.header(header.getKey(), header.getValue());
            }
            response = new MockHttpResponse();
            dispatcher.invoke((HttpRequest)request, (HttpResponse)response);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    protected MockHttpResponse execute(String requestURL, Map<String, String> headers, MockRequestType requestType) throws URISyntaxException {
        return this.execute(requestURL, headers, requestType, this.factory);
    }

    protected MockHttpResponse execute(String requestURL, Map<String, String> headers, MockRequestType requestType, POJOResourceFactory resourceFactory) throws URISyntaxException {
        Dispatcher dispatcher = MockDispatcherFactory.createDispatcher();
        dispatcher.getRegistry().addResourceFactory((ResourceFactory)resourceFactory);
        MockHttpRequest request = new MockRequest().create(requestType.toString(), new URI(BASE_URI + requestURL), new URI(BASE_URI));
        logger.info((Object)("Request URL is: " + request.getUri().getRequestUri()));
        for (Map.Entry<String, String> header : headers.entrySet()) {
            request.header(header.getKey(), header.getValue());
        }
        MockHttpServletRequest req = new MockHttpServletRequest();
        NeptunePrincipal nsp = this.getNeptunePrincipal();
        req.setAttribute("neptune_sso_oauth2_principal", (Object)nsp);
        ResteasyProviderFactory.getContextDataMap().put(HttpServletRequest.class, req);
        MockHttpResponse response = new MockHttpResponse();
        dispatcher.invoke((HttpRequest)request, (HttpResponse)response);
        return response;
    }

    private NeptunePrincipal getNeptunePrincipal() {
        NeptunePrincipal nsp = new NeptunePrincipal();
        HashSet<String> roles = new HashSet<String>();
        roles.add("ResourceManagement_View");
        roles.add("ResourceManagement_Create");
        roles.add("ResourceManagement_Delete");
        roles.add("ResourceManagement_Modify");
        nsp.setRoles(roles);
        return nsp;
    }
}

