/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.nodetype.loop.test;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.test.NormalTestBase;
import com.tandbergtv.workflow.test.util.ProcessUtils;
import java.util.concurrent.Future;
import org.testng.annotations.Test;

public class LoopTest
extends NormalTestBase {
    @Test
    public void testLoopConditionBecomeInvalid() throws Exception {
        WorkflowProcess wp = this.run("loop-invalid-condition-template");
        long id = wp.getId();
        LoopTest.assertTrue((boolean)ProcessUtils.sleepUntilStatus(id, 60000L, ProcessStatus.ERROR));
    }

    @Test
    public void testPauseLoopFailure() throws Exception {
        WorkflowProcess wp = this.run("loop-without-message-template");
        long id = wp.getId();
        LoopTest.assertTrue((boolean)ProcessUtils.sleepUntilStatus(id, 5000L, ProcessStatus.BUSY));
        ProcessUtils.pause(ProcessUtils.get(id));
        LoopTest.assertTrue((boolean)ProcessUtils.sleepUntilComplete(id, 60000L));
    }

    @Test
    public void testPauseLoopSucceed() throws Exception {
        WorkflowProcess wp = this.run("loop-call-resource-template");
        long id = wp.getId();
        LoopTest.assertTrue((boolean)ProcessUtils.sleepUntilStatus(id, 5000L, ProcessStatus.BUSY));
        ProcessUtils.pause(ProcessUtils.get(id));
        LoopTest.assertTrue((boolean)ProcessUtils.sleepUntilStatus(id, 60000L, ProcessStatus.PAUSED));
        ProcessUtils.resume(ProcessUtils.get(id));
        LoopTest.assertTrue((boolean)ProcessUtils.sleepUntilComplete(id, 60000L));
    }

    @Test
    public void testCancelLoop() throws Exception {
        WorkflowProcess wp = this.run("loop-call-resource-template");
        long id = wp.getId();
        LoopTest.assertTrue((boolean)ProcessUtils.sleepUntilStatus(id, 5000L, ProcessStatus.BUSY));
        Thread.sleep(4000L);
        ProcessUtils.cancel(ProcessUtils.get(id));
        LoopTest.assertTrue((boolean)ProcessUtils.sleepUntilStatus(id, 60000L, ProcessStatus.CANCELLED), (String)"process cancelled within 60 seconds");
    }

    @Test
    public void tesRestartLoop() throws Exception {
        WorkflowProcess wp = this.run("loop-diff-type-template");
        long id = wp.getId();
        LoopTest.assertTrue((boolean)ProcessUtils.sleepUntilComplete(id, 60000L));
        Future f = ProcessUtils.getProcessManager().restart(ProcessUtils.get(id));
        WorkflowProcess copy = ((CustomToken)f.get()).getProcessInstance();
        LoopTest.assertTrue((boolean)ProcessUtils.sleepUntilComplete(copy.getId(), 60000L));
    }
}

