/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.test.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceState;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import com.tandbergtv.workflow.test.util.ResourceUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;

public class ResourceBuilder {
    private final ResourceType resourceType;
    private Set<ResourceGroup> resourceGroups;
    private String name = UUID.randomUUID().toString();
    private String connectionString = this.name + "@test.com";
    private String heartbeatConnectionString = null;
    private Long heartbeatFrequency = null;
    private int maxConcurrentUsers = 0;
    private boolean ignoreTimeout = false;
    private ResourceState startingState = ResourceState.ONLINE;

    protected ResourceBuilder(ResourceType resourceType, Set<ResourceGroup> resourceGroups, String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        this.resourceType = resourceType;
        this.resourceGroups = resourceGroups;
        this.name = prefix + this.name;
        this.connectionString = prefix + this.connectionString;
    }

    protected ResourceBuilder(ResourceType rt, Set<ResourceGroup> rg) {
        this(rt, rg, "");
    }

    protected ResourceBuilder(Resource resource, String prefix) {
        this(resource.getResourceType(), resource.getResourceGroups(), prefix);
        this.heartbeatConnectionString = resource.getHeartbeatConnectionString();
        this.heartbeatFrequency = resource.getHeartbeatFrequency();
        this.maxConcurrentUsers = resource.getMaxConcurrentUsers();
        this.ignoreTimeout = resource.getIgnoreTimeout();
    }

    protected ResourceBuilder(Resource resource) {
        this(resource, "");
    }

    public ResourceBuilder resourceGroups(Set<ResourceGroup> value) {
        this.resourceGroups = value;
        return this;
    }

    public ResourceBuilder resourceGroup(final String value) {
        Collection filtered = Collections2.filter(ResourceUtils.getResourceGroupsByResourceType(this.resourceType.getId()), (Predicate)new Predicate<ResourceGroup>(){

            public boolean apply(ResourceGroup g) {
                return g.getName().equals(value);
            }
        });
        HashSet<ResourceGroup> set = new HashSet<ResourceGroup>(filtered);
        if (filtered.size() > 0) {
            return this.resourceGroups(set);
        }
        throw new NoSuchElementException("No Resource Group found with name: " + value + " for ResourceType: " + this.resourceType.getName());
    }

    public ResourceBuilder name(String value) {
        this.name = value;
        return this;
    }

    public ResourceBuilder connectionString(String value) {
        this.connectionString = value;
        return this;
    }

    public ResourceBuilder heartbeatConnectionString(String value) {
        this.heartbeatConnectionString = value;
        return this;
    }

    public ResourceBuilder heartbeatFrequency(Long value) {
        this.heartbeatFrequency = value;
        return this;
    }

    public ResourceBuilder maxConcurrentUsers(Integer value) {
        this.maxConcurrentUsers = value;
        return this;
    }

    public ResourceBuilder ignoreTimeout(Boolean value) {
        this.ignoreTimeout = value;
        return this;
    }

    public ResourceBuilder initialState(ResourceState value) {
        this.startingState = value;
        return this;
    }

    public ResourceBuilder usesHTTPConnectionString() {
        this.connectionString = "http://localhost:8080/" + this.name;
        if (this.heartbeatConnectionString != null) {
            this.heartbeatConnectionString = this.connectionString;
        }
        return this;
    }

    public Resource build() {
        Resource resource = new Resource();
        resource.setResourceType(this.resourceType);
        resource.setResourceGroups(this.resourceGroups);
        resource.setName(this.name);
        resource.setConnectionString(this.connectionString);
        resource.setHeartbeatConnectionString(this.heartbeatConnectionString);
        resource.setHeartbeatFrequency(this.heartbeatFrequency);
        resource.setMaxConcurrentUsers(this.maxConcurrentUsers);
        resource.setIgnoreTimeout(this.ignoreTimeout);
        resource.setAdministrationState(this.startingState);
        return resource;
    }
}

