/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.test;

import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.graph.NodeVisitor;
import com.tandbergtv.workflow.log.entities.MessageLog;
import com.tandbergtv.workflow.log.entities.ProcessQueuedPerResourceLog;
import com.tandbergtv.workflow.log.entities.ProcessStatusPerResourceLog;
import com.tandbergtv.workflow.log.entities.WorkflowMessageLog;
import com.tandbergtv.workflow.log.file.LogReader;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.Unmarshaller;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.test.WorkflowTestBase;
import com.tandbergtv.workflow.test.util.ESTransportClient;
import com.tandbergtv.workflow.test.util.ProcessUtils;
import com.tandbergtv.workflow.test.util.TestUtil;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.elasticsearch.client.transport.TransportClient;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.log.NodeLog;
import org.jbpm.logging.log.ProcessLog;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

@Test(groups={"normal"})
public class VerifyTaskDetails
extends WorkflowTestBase {
    private static final int WAIT_FOR_ELASTICSEARCH = 20;
    private long id = 0L;
    private WorkflowProcess wp;
    private TransportClient client;
    private LogReader logReader;

    @BeforeClass
    void setup() throws Exception {
        this.wp = this.run("echo-template", new HashMap<String, Object>());
        this.id = this.wp.getId();
        ProcessUtils.sleepUntilComplete(this.wp, 60000L);
        this.wp = ProcessUtils.get(this.id);
        VerifyTaskDetails.assertEquals((Object)this.wp.getRootToken().getStatus(), (Object)ProcessStatus.COMPLETED);
        TimeUnit.SECONDS.sleep(20L);
        this.client = ESTransportClient.getTransportClient();
        this.logReader = new LogReader(this.client);
    }

    @Test
    public void verifyNodeLogs() throws Exception {
        List<NodeLog> nodeLogs = this.getNodeLogs(this.wp.getProcessDefinition(), this.id, 0, 2);
        VerifyTaskDetails.assertEquals((int)nodeLogs.size(), (int)2);
        this.sortNodeLogsByStarttime(nodeLogs);
        WorkflowTemplate template = this.wp.getProcessDefinition();
        VerifyTaskDetails.assertEquals((String)this.getNodeById(template, Long.valueOf(nodeLogs.get(0).getNode().getName())).getName(), (String)"start-state1");
        VerifyTaskDetails.assertEquals((String)this.getNodeById(template, Long.valueOf(nodeLogs.get(1).getNode().getName())).getName(), (String)"Echo");
    }

    @Test
    public void verifyNodeLogsSorted() throws Exception {
        WorkflowProcess wp = this.run("loop-call-resource-template");
        VerifyTaskDetails.assertTrue((boolean)ProcessUtils.sleepUntilComplete(wp.getId(), 60000L));
        TimeUnit.SECONDS.sleep(20L);
        List<NodeLog> nodeLogs = this.getNodeLogs(wp.getProcessDefinition(), this.id, 0, 20);
        VerifyTaskDetails.assertTrue((boolean)this.isNodeLogsSorted(nodeLogs));
    }

    @Test
    public void verifyMessageLogs() throws Exception {
        List<MessageLog> messageLogs = this.getMessageLogs(this.id);
        VerifyTaskDetails.assertEquals((int)messageLogs.size(), (int)2);
        for (MessageLog ml : messageLogs) {
            WorkflowMessageLog wml = ml.getLog();
            WorkflowMessage wfm = this.getWorkflowMessage(wml);
            if (!wml.isIncoming()) {
                VerifyTaskDetails.assertEquals((String)wml.getMessageName(), (String)"Echo");
                VerifyTaskDetails.assertEquals((String)wml.getMessageType(), (String)"control");
                VerifyTaskDetails.assertEquals((Object)wfm.getParameterValue("Phrase"), (Object)"This is echo");
                continue;
            }
            VerifyTaskDetails.assertEquals((String)wml.getMessageName(), (String)"Echo");
            VerifyTaskDetails.assertEquals((String)wml.getMessageType(), (String)"ack");
            VerifyTaskDetails.assertEquals((Object)wfm.getParameterValue("echo"), (Object)"This is echo");
        }
    }

    @Test
    public void verifyProcessQueuedPerResourceLog() throws Exception {
        List<ProcessQueuedPerResourceLog> queuedPerResourceLogs = this.getqueuedPerResourceLogs(this.id);
        VerifyTaskDetails.assertEquals((int)queuedPerResourceLogs.size(), (int)1);
        VerifyTaskDetails.assertEquals((Object)queuedPerResourceLogs.get(0).getAdminStatus(), (Object)ProcessStatus.QUEUED);
        VerifyTaskDetails.assertEquals((Object)queuedPerResourceLogs.get(0).getOperationalStatus(), (Object)ProcessStatus.QUEUED);
        Resource qr = TestUtil.getResourceManagement().getResource(queuedPerResourceLogs.get(0).getResourceId().longValue());
        ResourceGroup qrgrp = TestUtil.getResourceManagement().getResourceGroup(queuedPerResourceLogs.get(0).getResourceGroupId());
        VerifyTaskDetails.assertEquals((String)"Echo", (String)qrgrp.getName());
        VerifyTaskDetails.assertEquals((String)"Echo", (String)qr.getName());
        VerifyTaskDetails.assertTrue((boolean)qrgrp.getResources().contains(qr));
    }

    @Test
    public void verifyProcessStatusPerResourceLog() throws Exception {
        List<ProcessStatusPerResourceLog> statusPerResourceLogs = this.getstatusPerResourceLogs(this.id);
        VerifyTaskDetails.assertEquals((int)statusPerResourceLogs.size(), (int)1);
        VerifyTaskDetails.assertEquals((Object)statusPerResourceLogs.get(0).getAdminStatus(), (Object)ProcessStatus.RUNNING);
        VerifyTaskDetails.assertEquals((Object)statusPerResourceLogs.get(0).getOperationalStatus(), (Object)ProcessStatus.RUNNING);
        Resource sr = TestUtil.getResourceManagement().getResource(statusPerResourceLogs.get(0).getResourceId().longValue());
        ResourceGroup srgrp = TestUtil.getResourceManagement().getResourceGroup(statusPerResourceLogs.get(0).getResourceGroupId());
        VerifyTaskDetails.assertEquals((String)"Echo", (String)srgrp.getName());
        VerifyTaskDetails.assertEquals((String)"Echo", (String)sr.getName());
        VerifyTaskDetails.assertTrue((boolean)srgrp.getResources().contains(sr));
    }

    private Node getNodeById(WorkflowTemplate template, long id) {
        List<Node> nodes = this.getNodes(template);
        for (Node node : nodes) {
            if (node.getId() != id) continue;
            return node;
        }
        return null;
    }

    private List<NodeLog> getNodeLogs(WorkflowTemplate template, long processId, int start, int count) {
        return TestUtil.getWorkflowLogService().findNodeLogs(template, processId, start, count);
    }

    private List<MessageLog> getMessageLogs(long id) throws Exception {
        List messageProcessLogs = this.logReader.getLogs(id, MessageLog.class);
        ArrayList<MessageLog> messageLogs = new ArrayList<MessageLog>();
        for (ProcessLog log : messageProcessLogs) {
            messageLogs.add((MessageLog)log);
        }
        return messageLogs;
    }

    private List<ProcessQueuedPerResourceLog> getqueuedPerResourceLogs(long id) throws Exception {
        List queuedProcessLogs = this.logReader.getLogs(id, ProcessQueuedPerResourceLog.class);
        ArrayList<ProcessQueuedPerResourceLog> processQueuedPerResourceLogs = new ArrayList<ProcessQueuedPerResourceLog>();
        for (ProcessLog log : queuedProcessLogs) {
            if (!(log instanceof ProcessQueuedPerResourceLog)) continue;
            processQueuedPerResourceLogs.add((ProcessQueuedPerResourceLog)log);
        }
        return processQueuedPerResourceLogs;
    }

    private List<ProcessStatusPerResourceLog> getstatusPerResourceLogs(long id) throws Exception {
        List statusProcessLogs = this.logReader.getLogs(id, ProcessStatusPerResourceLog.class);
        ArrayList<ProcessStatusPerResourceLog> processStatusPerResourceLogs = new ArrayList<ProcessStatusPerResourceLog>();
        for (ProcessLog log : statusProcessLogs) {
            if (log instanceof ProcessQueuedPerResourceLog) continue;
            processStatusPerResourceLogs.add((ProcessStatusPerResourceLog)log);
        }
        return processStatusPerResourceLogs;
    }

    private List<Node> getNodes(WorkflowTemplate template) {
        final ArrayList<Node> nodes = new ArrayList<Node>();
        template.breadthFirstTraversal(new NodeVisitor(){

            public void visit(Node node) {
                nodes.add(node);
            }
        });
        return nodes;
    }

    private void sortNodeLogsByStarttime(List<NodeLog> nodeLogs) {
        Collections.sort(nodeLogs, new Comparator<NodeLog>(){

            @Override
            public int compare(NodeLog nl1, NodeLog nl2) {
                return nl1.getEnter().compareTo(nl2.getEnter());
            }
        });
    }

    private boolean isNodeLogsSorted(List<NodeLog> nodeLogs) {
        for (int i = 0; i < nodeLogs.size(); ++i) {
            if (nodeLogs.get(i).getLeave().compareTo(nodeLogs.get(i).getLeave()) <= 0) continue;
            return false;
        }
        return true;
    }

    private WorkflowMessage getWorkflowMessage(WorkflowMessageLog wml) throws Exception {
        String message = wml.getMessage();
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        InputSource inputSource = new InputSource(new StringReader(message));
        inputSource.setCharacterStream(new StringReader(message));
        Document doc = documentBuilder.parse(inputSource);
        return Unmarshaller.unmarshal((Document)doc);
    }
}

