/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resource.test;

import com.google.common.collect.Lists;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.resourcemanager.DataOperationException;
import com.tandbergtv.workflow.resourcemanager.ResourceManagementException;
import com.tandbergtv.workflow.resourcemanager.ValidationException;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceState;
import com.tandbergtv.workflow.test.SequentialTestBase;
import com.tandbergtv.workflow.test.util.ProcessUtils;
import com.tandbergtv.workflow.test.util.ResourceUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class Allocation
extends SequentialTestBase {
    private static final long CANCEL_TIMEOUT = TimeUnit.MILLISECONDS.convert(2L, TimeUnit.MINUTES);
    private static final String TEMPLATE = "loop-manual-task-template";
    private static final String LIST_VARIABLE_NAME = "manualVariableList";
    private static final String UUID_PREFIX = "Allocation_";
    private static final String RESOURCE_TYPE_SYSTEM_ID = "04";

    @Test(priority=1)
    public void concurrency() throws Exception {
        Resource resource = this.initializeResources(1, 2).get(0);
        this.runMultiple(TEMPLATE, this.createParameters(), 3);
        Thread.sleep(7000L);
        Allocation.assertEquals((int)this.numberOfProcessesOfStatus(ProcessStatus.BUSY), (int)2);
        Allocation.assertEquals((int)this.numberOfProcessesOfStatus(ProcessStatus.QUEUED), (int)1);
        Allocation.assertEquals((int)ResourceUtils.getResourceUserCount(resource.getId()), (int)2);
    }

    @Test(priority=2)
    public void resourceFinishesBeforeGoingOffline() throws Exception {
        List<Resource> resources = this.initializeResources(2, 1);
        this.runMultiple(TEMPLATE, this.createParameters(), 3);
        Thread.sleep(5000L);
        Allocation.assertEquals((int)this.numberOfProcessesOfStatus(ProcessStatus.BUSY), (int)2);
        Allocation.assertEquals((int)this.numberOfProcessesOfStatus(ProcessStatus.QUEUED), (int)1);
        Allocation.assertEquals((int)ResourceUtils.getResourceUserCount(resources.get(0).getId()), (int)1);
        Allocation.assertEquals((int)ResourceUtils.getResourceUserCount(resources.get(1).getId()), (int)1);
        ResourceUtils.setResourceOffline(resources.get(0).getId());
        Allocation.assertEquals((int)ResourceUtils.getResourceUserCount(resources.get(0).getId()), (int)1);
        this.performAndWaitForManualTasks();
        Allocation.assertEquals((int)this.numberOfProcessesOfStatus(ProcessStatus.BUSY), (int)1);
        Allocation.assertEquals((int)this.numberOfProcessesOfStatus(ProcessStatus.QUEUED), (int)0);
        Allocation.assertEquals((int)ResourceUtils.getResourceUserCount(resources.get(0).getId()), (int)0);
        Allocation.assertEquals((int)ResourceUtils.getResourceUserCount(resources.get(1).getId()), (int)1);
    }

    @BeforeClass
    public void setup() throws Exception {
        ResourceUtils.setResourcesOffline(RESOURCE_TYPE_SYSTEM_ID);
        ResourceUtils.deleteResourcesWithPrefix(RESOURCE_TYPE_SYSTEM_ID, UUID_PREFIX);
    }

    @Override
    @AfterMethod
    public void afterMethod() throws Exception {
        for (WorkflowProcess p : this.createdProcesses) {
            if (ProcessUtils.get(p.getId()).getRootToken().getStatus() == ProcessStatus.COMPLETED) continue;
            ProcessUtils.getProcessManager().cancel(p.getRootToken());
            ProcessUtils.sleepUntilStatus(p.getId(), CANCEL_TIMEOUT, ProcessStatus.CANCELLED);
        }
        for (WorkflowProcess p : this.createdProcesses) {
            ProcessUtils.getProcessManager().delete(p);
        }
        this.createdProcesses.clear();
        ResourceUtils.setResourcesOffline(RESOURCE_TYPE_SYSTEM_ID);
        TimeUnit.SECONDS.sleep(2L);
        for (Resource resource : ResourceUtils.getResourcesWithPrefix(RESOURCE_TYPE_SYSTEM_ID, UUID_PREFIX)) {
            Allocation.assertEquals((Object)resource.getOperationalState(), (Object)ResourceState.OFFLINE);
        }
        ResourceUtils.deleteResourcesWithPrefix(RESOURCE_TYPE_SYSTEM_ID, UUID_PREFIX);
    }

    @AfterClass
    public void teardown() throws ResourceManagementException {
        ResourceUtils.setResourcesOnline(RESOURCE_TYPE_SYSTEM_ID);
    }

    private List<Resource> initializeResources(int numberOfResources, int concurrency) throws DataOperationException, ValidationException {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (int i = 0; i < numberOfResources; ++i) {
            Resource resource = ResourceUtils.createResource(ResourceUtils.getResourceBuilderFromSystemId(RESOURCE_TYPE_SYSTEM_ID, UUID_PREFIX).maxConcurrentUsers(concurrency));
            resources.add(resource);
        }
        return resources;
    }

    private Map<String, Object> createParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList manualVariables = new ArrayList(Lists.newArrayList((Object[])new String[]{"1"}));
        params.put(LIST_VARIABLE_NAME, manualVariables);
        return params;
    }

    private void performAndWaitForManualTasks() throws Exception {
        this.refreshProcesses();
        HashSet<WorkflowProcess> busyProcesses = new HashSet<WorkflowProcess>();
        for (WorkflowProcess process : this.createdProcesses) {
            if (process.getRootToken().getStatus() != ProcessStatus.BUSY) continue;
            busyProcesses.add(process);
        }
        ProcessUtils.performManualTasks(busyProcesses);
        for (WorkflowProcess process : busyProcesses) {
            ProcessUtils.sleepUntilComplete(process, 300000L);
        }
    }

    private void refreshProcesses() {
        HashSet<WorkflowProcess> refresh = new HashSet<WorkflowProcess>();
        for (WorkflowProcess process : this.createdProcesses) {
            refresh.add(ProcessUtils.get(process.getId()));
        }
        this.createdProcesses.clear();
        this.createdProcesses.addAll(refresh);
    }
}

