/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.test.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.IPersistenceService;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.graph.IProcessFactory;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.DriverException;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.driver.service.ITaskCompletionService;
import com.tandbergtv.workflow.test.util.TestUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.jbpm.JbpmConfiguration;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.testng.Assert;

public class ProcessUtils {
    private ProcessUtils() {
    }

    public static WorkflowProcess create(String templateName, HashMap<String, Object> params, List<WorkflowProcess> createdProcesses) throws DriverException {
        WorkflowProcess wp = ProcessUtils.create(templateName, params);
        createdProcesses.add(wp);
        return wp;
    }

    public static WorkflowProcess create(String templateName, List<WorkflowProcess> createdProcesses) throws DriverException {
        WorkflowProcess wp = ProcessUtils.create(templateName, new HashMap<String, Object>());
        createdProcesses.add(wp);
        return wp;
    }

    public static WorkflowProcess create(String templateName, Map<String, Object> params) throws DriverException {
        WorkflowTemplate template = TestUtil.getTemplateService().getTemplateByName(templateName);
        WorkflowProcess wp = ProcessUtils.getProcessFactory().create((ProcessDefinition)template, ProcessPriority.P10, params);
        ProcessUtils.getProcessManager().start(wp.getRootToken());
        return wp;
    }

    public static WorkflowProcess createIdle(String templateName) throws DriverException {
        return ProcessUtils.createIdle(templateName, new HashMap<String, Object>());
    }

    public static WorkflowProcess createIdle(String templateName, Map<String, Object> parameters) throws DriverException {
        WorkflowTemplate template = TestUtil.getTemplateService().getTemplateByName(templateName);
        return ProcessUtils.getProcessFactory().create((ProcessDefinition)template, ProcessPriority.P10, parameters);
    }

    public static WorkflowProcess get(long id) {
        return ((IPersistenceService)ServiceRegistry.getDefault().lookup(IPersistenceService.class)).get((Serializable)Long.valueOf(id));
    }

    public static void pause(WorkflowProcess process) {
        ProcessUtils.getProcessManager().pause(process.getRootToken());
    }

    public static void resume(WorkflowProcess process) throws DriverException {
        ProcessUtils.getProcessManager().resume(process.getRootToken());
    }

    public static void cancel(WorkflowProcess process) {
        ProcessUtils.getProcessManager().cancel(process.getRootToken());
    }

    public static Future<CustomToken> restart(WorkflowProcess process) throws DriverException {
        return ProcessUtils.getProcessManager().restart(process);
    }

    public static String getStringVariable(WorkflowProcess wp, String name) {
        return (String)wp.getContextInstance().getVariables().get(name);
    }

    public static int getIntegerVariable(WorkflowProcess wp, String name) {
        return (Integer)wp.getContextInstance().getVariables().get(name);
    }

    public static List<Object> getListVariable(WorkflowProcess wp, String name) {
        return (List)wp.getContextInstance().getVariables().get(name);
    }

    public static void performManualTasks(Set<WorkflowProcess> processes) throws InterruptedException {
        Collection busyProcesses = Collections2.filter(processes, (Predicate)new Predicate<WorkflowProcess>(){

            public boolean apply(WorkflowProcess wp) {
                return wp.getRootToken().getStatus() == ProcessStatus.BUSY;
            }
        });
        for (WorkflowProcess process : busyProcesses) {
            ProcessUtils.performManualTask(process);
        }
    }

    public static void performManualTask(WorkflowProcess process) {
        TaskInstance task = ProcessUtils.getTaskInstance(process);
        if (task == null) {
            return;
        }
        TestUtil.getService(ITaskCompletionService.class).endTask(process.getRootToken(), task, new HashMap());
    }

    public static TaskInstance getTaskInstance(WorkflowProcess process) {
        Collection tasks = process.getTaskMgmtInstance().getTaskInstances();
        if (tasks == null) {
            return null;
        }
        Collection filtered = Collections2.filter((Collection)tasks, (Predicate)new Predicate<TaskInstance>(){

            public boolean apply(TaskInstance t) {
                return !t.hasEnded();
            }
        });
        if (filtered.isEmpty()) {
            return null;
        }
        return (TaskInstance)filtered.iterator().next();
    }

    public static boolean sleepUntilComplete(long id, long timeoutMillisecs) throws Exception {
        return ProcessUtils.sleepUntilStatus(id, timeoutMillisecs, ProcessStatus.COMPLETED);
    }

    public static boolean sleepUntilComplete(WorkflowProcess wp, long timeoutMillisecs) throws Exception {
        return ProcessUtils.sleepUntilComplete(wp.getId(), timeoutMillisecs);
    }

    public static boolean sleepUntilStatus(long id, long timeoutMillisecs, ProcessStatus status) throws Exception {
        for (long t = 0L; t < timeoutMillisecs; t += 100L) {
            if (ProcessUtils.get(id).getRootToken().getStatus() == status) {
                return true;
            }
            Thread.sleep(100L);
        }
        return false;
    }

    public static void sleepWhileActive(List<WorkflowProcess> list, long timeoutMillisecs) throws Exception {
        long start = System.currentTimeMillis();
        ArrayList<WorkflowProcess> copy = new ArrayList<WorkflowProcess>(list);
        do {
            for (int i = 0; i < copy.size(); ++i) {
                if (ProcessUtils.isRunning(copy.get(i))) continue;
                copy.remove(copy.get(i));
                --i;
            }
        } while (System.currentTimeMillis() - start < timeoutMillisecs && !copy.isEmpty());
        if (!copy.isEmpty()) {
            throw new Exception("Timeout occured. Some of the work orders are still active");
        }
    }

    public static boolean isRunning(WorkflowProcess wp) {
        ProcessStatus status = ProcessUtils.get(wp.getId()).getRootToken().getStatus();
        return status == ProcessStatus.CREATED || status == ProcessStatus.RUNNING || status == ProcessStatus.QUEUED || status == ProcessStatus.BUSY;
    }

    public static void assertStatus(long processId, ProcessStatus desiredStatus, long timeoutMillisecs) throws InterruptedException {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < timeoutMillisecs && ProcessUtils.get(processId).getRootToken().getStatus() != desiredStatus) {
            Thread.sleep(100L);
        }
        ProcessStatus actualStatus = ProcessUtils.get(processId).getRootToken().getStatus();
        Assert.assertEquals((Object)actualStatus, (Object)desiredStatus);
    }

    static IProcessFactory getProcessFactory() {
        return (IProcessFactory)JbpmConfiguration.Configs.getObject((String)"jbpm.process.factory");
    }

    public static IProcessManagerService getProcessManager() {
        return (IProcessManagerService)ServiceRegistry.getDefault().lookup(IProcessManagerService.class);
    }
}

