/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.test;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.log.WorkflowLogService;
import com.tandbergtv.workflow.log.entities.MessageLog;
import com.tandbergtv.workflow.log.entities.ProcessStatusPerResourceLog;
import com.tandbergtv.workflow.log.entities.WorkflowMessageLog;
import com.tandbergtv.workflow.log.file.LogReader;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.Unmarshaller;
import com.tandbergtv.workflow.test.NormalTestBase;
import com.tandbergtv.workflow.test.util.ESTransportClient;
import com.tandbergtv.workflow.test.util.ProcessUtils;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.elasticsearch.client.transport.TransportClient;
import org.jbpm.logging.log.ProcessLog;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

@Test(groups={"normal"})
public class RetryTest
extends NormalTestBase {
    private static final int WAIT_FOR_PROCESS_TO_FAIL = 60000;
    private static final int WAIT_FOR_ELASTICSEARCH = 20;
    private static final String DEFAULT_TEMPLATE = "loop-call-resource-template";
    private static final String TIMEOUT_TEMPLATE = "pizza-timeout";
    private static final long MAX_SLEEP_TIME = 300000L;
    private long id = 0L;
    private TransportClient client;
    private WorkflowLogService wflService;
    private LogReader logReader;

    @BeforeClass
    protected void setup() throws Exception {
        this.client = ESTransportClient.getTransportClient();
        this.wflService = (WorkflowLogService)ServiceRegistry.getDefault().lookup(WorkflowLogService.class);
        this.logReader = new LogReader(this.client);
    }

    private WorkflowTemplate testTimeoutError() throws Exception {
        WorkflowProcess wp = this.run(TIMEOUT_TEMPLATE);
        this.id = wp.getId();
        ProcessUtils.sleepUntilStatus(this.id, 60000L, ProcessStatus.ERROR);
        WorkflowTemplate template = wp.getProcessDefinition();
        RetryTest.assertEquals((Object)ProcessUtils.get(this.id).getRootToken().getStatus(), (Object)ProcessStatus.ERROR);
        TimeUnit.SECONDS.sleep(20L);
        List nodeLogs = this.wflService.findNodeLogs(template, this.id, 0, 10);
        RetryTest.assertEquals((int)nodeLogs.size(), (int)1);
        List<ProcessStatusPerResourceLog> statusPerResourceLogs = this.getstatusPerResourceLogs(this.id);
        RetryTest.assertEquals((int)statusPerResourceLogs.size(), (int)2);
        RetryTest.assertEquals((Object)statusPerResourceLogs.get(0).getOperationalStatus(), (Object)ProcessStatus.QUEUED);
        RetryTest.assertEquals((Object)statusPerResourceLogs.get(1).getOperationalStatus(), (Object)ProcessStatus.ERROR);
        return template;
    }

    private List<ProcessStatusPerResourceLog> getstatusPerResourceLogs(long id) throws Exception {
        List statusProcessLogs = this.logReader.getLogs(id, ProcessStatusPerResourceLog.class);
        ArrayList<ProcessStatusPerResourceLog> processStatusPerResourceLogs = new ArrayList<ProcessStatusPerResourceLog>();
        for (ProcessLog log : statusProcessLogs) {
            processStatusPerResourceLogs.add((ProcessStatusPerResourceLog)log);
        }
        return processStatusPerResourceLogs;
    }

    private void testRetryFailedWO(WorkflowTemplate template) throws Exception {
        ProcessUtils.resume(ProcessUtils.get(this.id));
        Thread.sleep(120000L);
        int totalNodeLogs = this.wflService.getNodeLogCount(template, this.id);
        int totalmessageLogs = this.logReader.getLogs(this.id, MessageLog.class).size();
        List resourceLogs = this.logReader.getLogs(this.id, ProcessStatusPerResourceLog.class);
        RetryTest.assertEquals((int)(totalNodeLogs + totalmessageLogs + resourceLogs.size()), (int)5);
        RetryTest.assertEquals((int)resourceLogs.size(), (int)4);
    }

    @Test
    public void testRestartCompletedWO() throws Exception {
        System.out.println("Starting restartCompletedWO");
        WorkflowProcess wp = this.run(DEFAULT_TEMPLATE);
        long id = wp.getId();
        WorkflowTemplate defaultTemplate = wp.getProcessDefinition();
        System.out.println("First WO:" + id);
        ProcessUtils.sleepUntilComplete(ProcessUtils.get(id), 300000L);
        RetryTest.assertEquals((Object)ProcessUtils.get(id).getRootToken().getStatus(), (Object)ProcessStatus.COMPLETED);
        this.assertLogsCorrectForCompletedDefaultTemplate(defaultTemplate, ProcessUtils.get(id).getId());
        System.out.println("Restarting");
        Future<CustomToken> f = ProcessUtils.restart(ProcessUtils.get(id));
        long newId = f.get().getProcessInstance().getId();
        System.out.println("Second WO:" + newId);
        RetryTest.assertNotEquals((Object)wp.getId(), (Object)newId);
        ProcessUtils.sleepUntilComplete(ProcessUtils.get(newId), 300000L);
        this.assertLogsCorrectForCompletedDefaultTemplate(defaultTemplate, newId);
    }

    private void assertLogsCorrectForCompletedDefaultTemplate(WorkflowTemplate defaultTemplate, long id) throws Exception {
        System.out.println("Inspecting logs for WO id " + id);
        TimeUnit.SECONDS.sleep(20L);
        List nodeLogs = this.wflService.findNodeLogs(defaultTemplate, id, 0, 10);
        RetryTest.assertEquals((int)nodeLogs.size(), (int)9);
        List<ProcessStatusPerResourceLog> statusPerResourceLogs = this.getstatusPerResourceLogs(id);
        RetryTest.assertEquals((int)statusPerResourceLogs.size(), (int)8);
        for (int i = 0; i < 4; i += 2) {
            RetryTest.assertEquals((Object)statusPerResourceLogs.get(i).getOperationalStatus(), (Object)ProcessStatus.QUEUED);
            RetryTest.assertEquals((Object)statusPerResourceLogs.get(i + 1).getOperationalStatus(), (Object)ProcessStatus.RUNNING);
        }
        List<MessageLog> messageLogs = this.getMessageLogs(id);
        RetryTest.assertEquals((int)messageLogs.size(), (int)8);
        for (MessageLog ml : messageLogs) {
            WorkflowMessageLog wml = ml.getLog();
            WorkflowMessage wfm = this.getWorkflowMessage(wml);
            if (!wml.isIncoming()) {
                RetryTest.assertEquals((String)wml.getMessageName(), (String)"Echo");
                RetryTest.assertEquals((String)wml.getMessageType(), (String)"control");
                continue;
            }
            RetryTest.assertEquals((String)wml.getMessageName(), (String)"Echo");
            RetryTest.assertEquals((String)wml.getMessageType(), (String)"ack");
        }
    }

    private List<MessageLog> getMessageLogs(long id) throws Exception {
        List messageProcessLogs = this.logReader.getLogs(id, MessageLog.class);
        ArrayList<MessageLog> messageLogs = new ArrayList<MessageLog>();
        for (ProcessLog log : messageProcessLogs) {
            messageLogs.add((MessageLog)log);
        }
        return messageLogs;
    }

    private WorkflowMessage getWorkflowMessage(WorkflowMessageLog wml) throws Exception {
        String message = wml.getMessage();
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        InputSource inputSource = new InputSource(new StringReader(message));
        inputSource.setCharacterStream(new StringReader(message));
        Document doc = documentBuilder.parse(inputSource);
        return Unmarshaller.unmarshal((Document)doc);
    }
}

