/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.rest.services.test;

import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.driver.template.ITemplateService;
import com.tandbergtv.workflow.rest.services.internal.TemplatesResource;
import com.tandbergtv.workflow.rest.services.test.AbstractQueryBuilder;
import com.tandbergtv.workflow.rest.services.test.MockRequestType;
import com.tandbergtv.workflow.rest.services.test.RESTServiceMockTestBase;
import com.tandbergtv.workflow.rest.services.test.RESTUtil;
import com.tandbergtv.workflow.rest.services.test.TemplateQueryBuilder;
import com.tandbergtv.workflow.test.util.TestUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.JsonMappingException;
import org.jboss.resteasy.mock.MockHttpResponse;
import org.testng.annotations.Test;

@Test(groups={"normal"})
public class TemplateResourceGetListTest
extends RESTServiceMockTestBase {
    private static final String BASE_API_PATH = "/templates";
    private static final String CATEGORY_ALL = "all";
    private static final String CATEGORY_DISTRIBUTION = "Distribution";
    private static final String TEMPLATES = "templates";

    public TemplateResourceGetListTest() {
        super(TemplatesResource.class);
    }

    @Test
    public void testTemplateGetAll() throws Exception {
        String uri = BASE_API_PATH;
        MockHttpResponse response = this.execute(uri, RESTUtil.setDefaultHeaders(), MockRequestType.GET);
        TemplateResourceGetListTest.assertEquals((int)response.getStatus(), (int)200);
        this.verifyResponseFields(response, 0, 10, CATEGORY_ALL, uri);
    }

    @Test
    public void testTemplateGetAllWithStartAndCountParam() throws Exception {
        String uri = "/templates?count=3&start=1";
        MockHttpResponse response = this.execute(uri, RESTUtil.setDefaultHeaders(), MockRequestType.GET);
        TemplateResourceGetListTest.assertEquals((int)response.getStatus(), (int)200);
        this.verifyResponseFields(response, 1, 3, CATEGORY_ALL, uri);
    }

    @Test
    public void testTemplateGetAllWithCountAndCategoryParam() throws Exception {
        String uri = "/templates?count=6&category=Distribution";
        MockHttpResponse response = this.execute(uri, RESTUtil.setDefaultHeaders(), MockRequestType.GET);
        TemplateResourceGetListTest.assertEquals((int)response.getStatus(), (int)200);
        this.verifyResponseFields(response, 0, 6, CATEGORY_DISTRIBUTION, uri);
    }

    @Test
    public void testTemplateGetAllWithInvalidFilter() throws Exception {
        TemplateResourceGetListTest.assertEquals((int)this.queryStatus(this.filterQuery("invalid").build()), (int)400);
    }

    @Test
    public void testTemplateGetAllWithInvalidStartParam() throws Exception {
        String uri = "/templates?start=-1";
        MockHttpResponse response = this.execute(uri, RESTUtil.setDefaultHeaders(), MockRequestType.GET);
        TemplateResourceGetListTest.assertEquals((int)response.getStatus(), (int)400);
    }

    @Test
    public void testTemplateGetAllWithInvalidCountParam() throws Exception {
        String uri = "/templates?count=-1";
        MockHttpResponse response = this.execute(uri, RESTUtil.setDefaultHeaders(), MockRequestType.GET);
        TemplateResourceGetListTest.assertEquals((int)response.getStatus(), (int)400);
    }

    @Test
    public void testTemplateGetAllWithInvalidDetailParam() throws Exception {
        String uri = "/templates?detail=" + System.currentTimeMillis();
        MockHttpResponse response = this.execute(uri, RESTUtil.setDefaultHeaders(), MockRequestType.GET);
        TemplateResourceGetListTest.assertEquals((int)response.getStatus(), (int)400);
    }

    @Test
    public void testWhenNoVersionHeaderIsSent() throws Exception {
        String uri = BASE_API_PATH;
        MockHttpResponse response = this.execute(uri, new HashMap<String, String>(), MockRequestType.GET);
        TemplateResourceGetListTest.assertEquals((int)response.getStatus(), (int)412);
    }

    @Test
    public void testInvalidVersionHeader() throws Exception {
        String uri = BASE_API_PATH;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-API-Version", "2");
        MockHttpResponse response = this.execute(uri, headers, MockRequestType.GET);
        TemplateResourceGetListTest.assertEquals((int)response.getStatus(), (int)412);
    }

    private void verifyResponseFields(MockHttpResponse response, int start, int count, String category, String uri) throws JsonParseException, JsonMappingException, IOException {
        this.verifyPagingParametersInResponse(RESTUtil.deserialize(response), start, count, this.getTemplatesByCategory(category).size(), uri);
        this.VerifyTemplatesList(response, start, count, category);
    }

    private void verifyPagingParametersInResponse(Map<String, Object> responseMap, int start, int count, int expectedtotal, String uri) throws JsonParseException, JsonMappingException, IOException {
        int total = Integer.valueOf(responseMap.get("total").toString());
        TemplateResourceGetListTest.assertEquals((int)total, (int)expectedtotal);
        TemplateResourceGetListTest.assertEquals((Object)responseMap.get("start"), (Object)start);
        TemplateResourceGetListTest.assertEquals((Object)responseMap.get("count"), (Object)count);
        if (total > start + count) {
            TemplateResourceGetListTest.assertEquals((Object)responseMap.get("next"), (Object)("http://localhost:8081" + RESTUtil.getExpectedUrl(uri, start, start + count)));
        } else {
            TemplateResourceGetListTest.assertFalse((boolean)responseMap.containsKey("next"));
        }
        if (start > 0) {
            if (start - count < 0) {
                TemplateResourceGetListTest.assertEquals((Object)responseMap.get("prev"), (Object)("http://localhost:8081" + RESTUtil.getExpectedUrl(uri, start, 0)));
            } else {
                TemplateResourceGetListTest.assertEquals((Object)responseMap.get("prev"), (Object)("http://localhost:8081" + RESTUtil.getExpectedUrl(uri, start, start - count)));
            }
            TemplateResourceGetListTest.assertEquals((Object)responseMap.get("first"), (Object)("http://localhost:8081" + RESTUtil.getExpectedUrl(uri, start, 0)));
        } else {
            TemplateResourceGetListTest.assertFalse((boolean)responseMap.containsKey("prev"));
            TemplateResourceGetListTest.assertFalse((boolean)responseMap.containsKey("first"));
        }
    }

    private void VerifyTemplatesList(MockHttpResponse response, int start, int count, String category) throws JsonProcessingException, IOException {
        List<Map<String, Object>> templatesListMap = RESTUtil.getComplexFieldValues(response.getContentAsString(), TEMPLATES);
        List<Object> templates = this.getTemplatesByCategory(category);
        int endIndex = Math.min(templates.size(), start + count);
        templates = start < endIndex ? templates.subList(start, endIndex) : Collections.emptyList();
        TemplateResourceGetListTest.assertEquals((int)templates.size(), (int)templatesListMap.size());
        for (WorkflowTemplate workflowTemplate : templates) {
            boolean foundMatch = false;
            for (Map<String, Object> templatesMap : templatesListMap) {
                if (!templatesMap.get("id").equals(String.valueOf(workflowTemplate.getId()))) continue;
                foundMatch = true;
                TemplateResourceGetListTest.assertEquals((Object)templatesMap.get("name"), (Object)workflowTemplate.getName());
                TemplateResourceGetListTest.assertTrue((boolean)templatesMap.get("href").toString().contains("/templates/" + workflowTemplate.getId()));
                TemplateResourceGetListTest.assertEquals((Object)templatesMap.get("version"), (Object)workflowTemplate.getVersion());
            }
            if (foundMatch) continue;
            TemplateResourceGetListTest.fail((String)("The Response was missing a template entry for id: " + workflowTemplate.getId()));
        }
    }

    private List<WorkflowTemplate> getTemplatesList() {
        return TestUtil.getService(ITemplateService.class).getLatestTemplates();
    }

    private List<WorkflowTemplate> getSortedTemplatesList() {
        List<WorkflowTemplate> templates = this.getTemplatesList();
        Collections.sort(templates, this.defaultComparator());
        return templates;
    }

    private Comparator<WorkflowTemplate> defaultComparator() {
        return new Comparator<WorkflowTemplate>(){

            @Override
            public int compare(WorkflowTemplate t1, WorkflowTemplate t2) {
                return t2.getCreateDate().compareTo(t1.getCreateDate());
            }
        };
    }

    private List<WorkflowTemplate> getTemplatesByCategory(String category) {
        ArrayList<WorkflowTemplate> templatesByCategory = new ArrayList<WorkflowTemplate>();
        if (CATEGORY_ALL.equals(category)) {
            return this.getSortedTemplatesList();
        }
        for (WorkflowTemplate template : this.getSortedTemplatesList()) {
            for (String annotation : template.getAnnotations("Category")) {
                if (!annotation.contains(category)) continue;
                templatesByCategory.add(template);
            }
        }
        return templatesByCategory;
    }

    private AbstractQueryBuilder filterQuery(String value) {
        return this.queryBuilder().filter(value);
    }

    private AbstractQueryBuilder idQuery(String id) {
        return this.queryBuilder().id(id).detail("full");
    }

    private List<Map<String, Object>> doQuery(AbstractQueryBuilder builder) throws IOException {
        return this.getResourcesList(builder.build(), TEMPLATES);
    }

    private int queryStatus(String url) {
        return this.executeGet(url, RESTUtil.setDefaultHeaders()).getStatus();
    }

    private TemplateQueryBuilder queryBuilder() {
        return new TemplateQueryBuilder("http://localhost:8081");
    }
}

