/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.watchfolder.core;

public class FileInfo {
    private String name;
    private long size;
    private long lastModified;
    private String absolutePath;
    private String parent;

    public FileInfo(String name, long size, long lastModified, String absolutePath) {
        this.name = name;
        this.size = size;
        this.lastModified = lastModified;
        this.absolutePath = absolutePath;
    }

    public String getParent() {
        int loc = this.absolutePath.lastIndexOf("\\");
        this.parent = this.absolutePath.substring(0, loc);
        return this.parent;
    }

    void setParent(String parent) {
        this.parent = parent;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getName() {
        return this.name;
    }

    public String getExtension() {
        int index;
        if (this.name != null && (index = this.name.lastIndexOf(".")) != -1) {
            return this.name.substring(index + 1);
        }
        return null;
    }

    public int compareTo(FileInfo fileInfo) {
        if (this.getLastModified() > fileInfo.getLastModified()) {
            return 1;
        }
        if (this.getLastModified() < fileInfo.getLastModified()) {
            return -1;
        }
        return 0;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    void setAbsolutePath(String absolutePath) {
        this.absolutePath = absolutePath;
    }

    public long getSize() {
        return this.size;
    }

    public String toString() {
        return this.absolutePath;
    }
}

