/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.tpp;

import com.ericsson.tpp.RpmListMain;
import com.ericsson.tpp.report.ReportGenerator;
import com.ericsson.tpp.util.Configuration;
import java.io.File;
import java.io.FileFilter;

public class ReportMain {
    public static void main(String[] stringArray) throws Exception {
        Object object;
        File file;
        if (stringArray.length < 1 || stringArray.length > 3) {
            ReportMain.printUsageAndExit();
        }
        if (!(file = new File(stringArray[0])).exists()) {
            System.out.println("Configuration file does not exist: " + file.getAbsolutePath());
            System.exit(1);
        }
        File file2 = null;
        File file3 = null;
        if (!(stringArray.length != 2 && stringArray.length != 3 || (file2 = new File(stringArray[1])).exists())) {
            System.out.println("Data file does not exist: " + file2.getAbsolutePath());
            System.exit(1);
        }
        if (stringArray.length == 3 && !(file3 = new File(stringArray[2])).exists()) {
            System.out.println("Data file does not exist: " + file3.getAbsolutePath());
            System.exit(1);
        }
        System.out.println("Reading config file: " + file.getAbsolutePath());
        Configuration configuration = new Configuration();
        configuration.load(file);
        if (file2 == null || file3 == null) {
            object = new FindLastReports();
            File file4 = new File(configuration.getDataDir());
            file4.listFiles((FileFilter)object);
            if (file2 == null && ((FindLastReports)object).prev > 0L) {
                file2 = new File(file4, ((FindLastReports)object).prev + ".xml");
            }
            if (file3 == null && ((FindLastReports)object).last > 0L) {
                file3 = new File(file4, ((FindLastReports)object).last + ".xml");
            }
        }
        if (file2 == null && file3 == null) {
            System.out.println("Could not find any data files.");
            System.exit(0);
        }
        object = new ReportGenerator(configuration, file2, file3);
        ((ReportGenerator)object).run();
        if (((ReportGenerator)object).changed()) {
            System.exit(100);
        } else {
            System.exit(0);
        }
    }

    private static void printUsageAndExit() {
        System.out.println("Usage: " + RpmListMain.class.getCanonicalName() + " <Config file path> [<Previous data file>] [<Latest data file>]");
        System.out.println("Config file path is required. Data files are optional.");
        System.exit(1);
    }

    private static class FindLastReports
    implements FileFilter {
        public long last;
        public long prev;

        @Override
        public boolean accept(File file) {
            if (!file.isFile()) {
                return false;
            }
            String string = file.getName().toLowerCase();
            if (!string.endsWith(".xml")) {
                return false;
            }
            int n = string.lastIndexOf(".xml");
            if (n > 0) {
                try {
                    long l = Long.parseLong(string.substring(0, n));
                    if (l > this.last) {
                        this.prev = this.last;
                        this.last = l;
                    } else if (l > this.prev) {
                        this.prev = l;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
    }
}

