/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.tpp;

import com.ericsson.tpp.RpmProcessor;
import com.ericsson.tpp.util.Configuration;
import com.ericsson.tpp.util.Logger;
import com.ericsson.tpp.util.RpmList;
import com.ericsson.tpp.util.XmlWriter;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

public class RpmListProcessor {
    private Logger logger = Logger.getLogger();
    private Configuration conf;
    private XmlWriter xmlWriter;

    public RpmListProcessor(Configuration configuration) {
        this.conf = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        long l = System.currentTimeMillis();
        this.initFiles(l);
        RpmList rpmList = this.getRpmList();
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String string = simpleDateFormat.format(new Date(l));
            this.xmlWriter.writeRootStart(string);
            RpmProcessor rpmProcessor = new RpmProcessor(this.conf, this.xmlWriter);
            for (File file : rpmList.getFiles()) {
                if (this.conf.whiteList(file.getName())) {
                    this.logger.info("Skipping white listed RPM: " + file.getAbsolutePath());
                    continue;
                }
                rpmProcessor.processRpm(file);
            }
            this.xmlWriter.writeRootEnd();
        }
        catch (Exception exception) {
            this.logger.error("" + exception);
        }
        finally {
            if (this.xmlWriter != null) {
                this.xmlWriter.close();
            }
            this.logger.closeLogFile();
        }
    }

    private void initFiles(long l) {
        File file = new File(this.conf.getDataDir(), l + ".xml");
        File file2 = new File(this.conf.getDataDir(), l + ".log");
        this.initLogger(file2);
        this.initXmlWriter(file);
        this.logger.info("Will write data to " + file.getAbsolutePath());
        this.logger.info("Will log to " + file2.getAbsolutePath());
    }

    private RpmList getRpmList() {
        RpmList rpmList = new RpmList();
        for (String string : this.conf.getRpmDirs()) {
            this.logger.info("Looking for RPMs in: " + string);
            rpmList.appendFilesInDir(string);
        }
        this.logger.info("Found " + rpmList.getFiles().size() + " RPM(s)");
        return rpmList;
    }

    private void initLogger(File file) {
        try {
            this.logger.openLogFile(file);
        }
        catch (Exception exception) {
            this.logger.error("Could not open log file: " + file.getAbsolutePath() + ": " + exception);
            System.exit(1);
        }
    }

    private void initXmlWriter(File file) {
        if (this.xmlWriter != null) {
            this.xmlWriter.close();
        }
        try {
            this.xmlWriter = new XmlWriter(file);
        }
        catch (Exception exception) {
            this.logger.error("Could not open output file: " + file.getAbsolutePath() + ": " + exception);
            System.exit(1);
        }
    }
}

