/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.tpp;

import com.ericsson.tpp.JarInfo;
import com.ericsson.tpp.RpmInfo;
import com.ericsson.tpp.util.Configuration;
import com.ericsson.tpp.util.FileUtils;
import com.ericsson.tpp.util.JarUtils;
import com.ericsson.tpp.util.JavaArchiveList;
import com.ericsson.tpp.util.Logger;
import com.ericsson.tpp.util.XmlWriter;
import java.io.File;

public class RpmProcessor {
    private Logger logger = Logger.getLogger();
    private XmlWriter writer;
    private File tmpDir;
    private Configuration conf;

    public RpmProcessor(Configuration configuration, XmlWriter xmlWriter) {
        this.conf = configuration;
        this.writer = xmlWriter;
        this.tmpDir = new File("/tmp/3pplist");
    }

    public void processRpm(File file) {
        this.logger.info("----------------------------------------------------------------------------------------------");
        this.logger.info("Processing RPM: " + file.getAbsolutePath());
        try {
            String string;
            RpmInfo rpmInfo = FileUtils.getRpmInfo(file);
            String string2 = string = rpmInfo.vendor == null ? "" : rpmInfo.vendor.toLowerCase();
            if (string.contains("tandberg") || string.contains("ericsson")) {
                this.processEricssonRpm(rpmInfo);
            } else {
                this.processNonEricssonRpm(rpmInfo);
            }
            this.logger.info("done.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void processEricssonRpm(RpmInfo rpmInfo) throws Exception {
        this.logger.info("Processing Ericsson RPM: " + rpmInfo.filePath);
        FileUtils.deleteDir(this.tmpDir.getAbsolutePath());
        this.tmpDir.mkdirs();
        this.logger.info("Extracting RPM");
        FileUtils.extractRpm(rpmInfo.filePath, this.tmpDir.getAbsolutePath());
        this.writer.writeRpmStart(rpmInfo);
        this.processJavaArchives(this.tmpDir);
        this.writer.writeRpmEnd();
    }

    private void processJavaArchives(File file) throws Exception {
        JavaArchiveList javaArchiveList = new JavaArchiveList();
        javaArchiveList.appendFilesInDir(file);
        this.logger.info("Found " + javaArchiveList.getJars().size() + " JAR(s), " + javaArchiveList.getEars().size() + " EAR(s), " + javaArchiveList.getWars().size() + " WAR(s)");
        for (File file2 : javaArchiveList.getJars()) {
            this.processJar(file2);
        }
        for (File file2 : javaArchiveList.getEars()) {
            this.processEarAndWar(file2);
        }
        for (File file2 : javaArchiveList.getWars()) {
            this.processEarAndWar(file2);
        }
    }

    private void processJar(File file) {
        if (file == null) {
            return;
        }
        this.logger.info("Processing Jar " + file.getAbsolutePath());
        try {
            String string;
            String string2 = FileUtils.getRelativePath(this.tmpDir, file);
            JarInfo jarInfo = new JarInfo(file.getName(), string2);
            JarUtils.setJarInfo(file, jarInfo);
            String string3 = string = jarInfo.vendor == null ? "" : jarInfo.vendor.toLowerCase();
            if (string.contains("tandberg") || string.contains("ericsson")) {
                this.logger.info("Skipping Ericsson JAR: " + file.getAbsolutePath());
            } else if (this.conf.whiteList(file.getName())) {
                this.logger.info("Skipping white listed JAR: " + file.getAbsolutePath());
            } else {
                this.writer.writeJar(jarInfo);
            }
            if (JarUtils.hasNestedJars(file)) {
                File file2 = new File(file.getAbsolutePath() + ".tmp");
                file.renameTo(file2);
                this.logger.info("----------------------------");
                this.logger.info("Extracting " + file.getAbsolutePath());
                FileUtils.extractJavaArchive(file2.getAbsolutePath(), file.getAbsolutePath());
                file2.delete();
                this.processJavaArchives(file);
            }
        }
        catch (Exception exception) {
            this.logger.error("Could not process Jar " + file.getAbsolutePath() + ": " + exception);
        }
    }

    private void processEarAndWar(File file) {
        try {
            File file2 = new File(file.getAbsolutePath() + ".tmp");
            file.renameTo(file2);
            this.logger.info("----------------------------");
            this.logger.info("Extracting " + file.getAbsolutePath());
            FileUtils.extractJavaArchive(file2.getAbsolutePath(), file.getAbsolutePath());
            file2.delete();
            this.processJavaArchives(file);
        }
        catch (Exception exception) {
            this.logger.error("Could not process archive " + file.getAbsolutePath() + ": " + exception);
        }
    }

    private void processNonEricssonRpm(RpmInfo rpmInfo) throws Exception {
        this.logger.info("Processing non-Ericsson RPM: " + rpmInfo.filePath);
        this.writer.writeRpmStart(rpmInfo);
        this.writer.writeRpmEnd();
    }
}

