/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.tpp.report;

import com.ericsson.tpp.report.JarEntry;
import com.ericsson.tpp.report.JarList;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;

public class CsvReportGenerator {
    private JarList jarList;
    private File reportFile;
    private Writer writer;

    public CsvReportGenerator(JarList jarList, File file) {
        this.jarList = jarList;
        this.reportFile = file;
    }

    public void close() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void generate() throws Exception {
        if (this.jarList == null) {
            return;
        }
        this.writer = new FileWriter(this.reportFile);
        this.writeQuotedValue(this.writer, this.jarList.getTimestamp());
        this.writer.write("\n");
        this.writer.write("Jar,Version,Vendor,Title\n");
        for (JarEntry jarEntry : this.jarList.getJars().values()) {
            this.writeQuotedValue(this.writer, jarEntry.fileName);
            this.writer.write(",");
            this.writeQuotedValue(this.writer, jarEntry.version);
            this.writer.write(",");
            this.writeQuotedValue(this.writer, jarEntry.vendor);
            this.writer.write(",");
            this.writeQuotedValue(this.writer, jarEntry.title);
            this.writer.write("\n");
        }
    }

    private void writeQuotedValue(Writer writer, String string) throws Exception {
        if (string != null) {
            writer.write("\"" + string + "\"");
        }
    }
}

