/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.tpp.report;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import org.apache.commons.lang3.StringEscapeUtils;

public class HtmlWriter {
    private Writer writer;

    public HtmlWriter(File file) throws Exception {
        File file2 = file.getParentFile();
        if (file2 != null) {
            file2.mkdirs();
        }
        this.writer = new BufferedWriter(new FileWriter(file));
    }

    public void close() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void writeReportStart() throws Exception {
        this.writer.write("<html>\n");
        this.writer.write("<head>\n");
        this.writer.write("<style>\n");
        char[] cArray = new char[5120];
        int n = 0;
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("report.css");
        if (inputStream == null) {
            throw new Exception("Could not find 'report.css'.");
        }
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        while ((n = inputStreamReader.read(cArray)) > 0) {
            this.writer.write(cArray, 0, n);
        }
        this.writer.write("</style>\n");
        this.writer.write("</head>\n");
        this.writer.write("<body>\n");
    }

    public void writeReportEnd() throws Exception {
        this.writer.write("</body>\n");
        this.writer.write("</html>\n");
    }

    public void writeElement(String string, String string2) throws Exception {
        this.writeElement(string, null, string2);
    }

    public void writeElementStart(String string, String string2) throws Exception {
        this.writer.write("<");
        this.writer.write(string);
        if (string2 != null) {
            this.writer.write(" class=\"" + string2 + "\"");
        }
        this.writer.write(">\n");
    }

    public void writeElementEnd(String string) throws Exception {
        this.writer.write("</");
        this.writer.write(string);
        this.writer.write(">\n");
    }

    public void writeElement(String string, String string2, String string3) throws Exception {
        this.writer.write("<");
        this.writer.write(string);
        if (string2 != null) {
            this.writer.write(" class=\"" + string2 + "\"");
        }
        this.writer.write(">");
        if (string3 == null) {
            this.writer.write("&nbsp;");
        } else {
            this.writer.write(string3);
        }
        this.writer.write("</" + string + ">\n");
    }

    public void writeTh(String string, String string2, String string3) throws Exception {
        this.writer.write("<th");
        if (string != null) {
            this.writer.write(" class=\"" + string + "\"");
        }
        if (string2 != null) {
            this.writer.write(" width=\"" + string2 + "\"");
        }
        this.writer.write(">");
        this.writer.write(string3);
        this.writer.write("</th>\n");
    }

    public void write(String string) throws Exception {
        this.writer.write(string);
        this.writer.write("\n");
    }

    private void writeAttribute(String string, String string2) throws Exception {
        if (string2 == null) {
            return;
        }
        string2 = StringEscapeUtils.escapeXml((String)string2);
        this.writer.write(string + "=\"" + string2 + "\" ");
    }
}

