/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.tpp.report;

import com.ericsson.tpp.report.JarEntry;
import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JarList {
    private Map<String, JarEntry> jars = new TreeMap<String, JarEntry>();
    private String timestamp;
    private DataHandler saxHandler = new DataHandler(this);

    public Map<String, JarEntry> getJars() {
        return this.jars;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void parse(File file) throws Exception {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        sAXParser.parse(file, (DefaultHandler)this.saxHandler);
    }

    private static class DataHandler
    extends DefaultHandler {
        private JarList list;
        private String rpmName;

        public DataHandler(JarList jarList) {
            this.list = jarList;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            String string4;
            if ("rpms".equals(string3)) {
                this.list.timestamp = attributes.getValue("timestamp");
            } else if ("rpm".equals(string3)) {
                this.rpmName = attributes.getValue("file");
            } else if ("jar".equals(string3) && (string4 = attributes.getValue("file")) != null) {
                String string5 = attributes.getValue("dir");
                JarEntry jarEntry = (JarEntry)this.list.jars.get(string4);
                if (jarEntry == null) {
                    jarEntry = new JarEntry();
                    jarEntry.fileName = string4;
                    jarEntry.vendor = attributes.getValue("vendor");
                    jarEntry.title = attributes.getValue("title");
                    jarEntry.version = attributes.getValue("version");
                    jarEntry.url = attributes.getValue("url");
                    jarEntry.addReference(this.rpmName, string5);
                    this.list.jars.put(string4, jarEntry);
                } else {
                    jarEntry.addReference(this.rpmName, string5);
                }
            }
        }
    }
}

