/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.tpp.report;

import com.ericsson.tpp.report.HtmlWriter;
import com.ericsson.tpp.report.JarEntry;
import com.ericsson.tpp.report.JarList;
import com.ericsson.tpp.report.JarListComparator;
import java.io.File;
import java.util.List;
import java.util.Map;

public class JarReportGenerator {
    private File oldDataFile;
    private File newDataFile;
    private File reportFile;
    private boolean changed = false;
    private HtmlWriter writer;
    private JarList newList;

    public JarReportGenerator(File file, File file2, File file3) {
        this.oldDataFile = file;
        this.newDataFile = file2;
        this.reportFile = file3;
    }

    public JarList getNewJarList() {
        return this.newList;
    }

    public boolean changed() {
        return this.changed;
    }

    public void close() {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    public void generate() throws Exception {
        if (this.newDataFile == null) {
            throw new Exception("New data file is null");
        }
        this.writer = new HtmlWriter(this.reportFile);
        this.writer.writeReportStart();
        this.newList = new JarList();
        this.newList.parse(this.newDataFile);
        JarList jarList = null;
        JarListComparator jarListComparator = null;
        if (this.oldDataFile != null) {
            jarList = new JarList();
            jarList.parse(this.oldDataFile);
            jarListComparator = new JarListComparator();
        }
        this.writer.writeElementStart("div", "header_box");
        this.writer.writeElement("div", "header", "3PP JARS");
        this.writer.writeElementStart("div", "header2");
        this.writer.write("<b>Created on</b> " + this.newList.getTimestamp());
        this.writer.writeElementEnd("div");
        if (this.oldDataFile != null) {
            this.writer.writeElementStart("div", "header2");
            this.writer.write("<b>Compared to</b> " + jarList.getTimestamp());
            this.writer.writeElementEnd("div");
        }
        this.writer.writeElementEnd("div");
        this.writer.write("<div class=\"c1\">");
        this.writer.write("<div class=\"c1_hdr\">Non-Ericsson JARs</div>");
        this.writeJarList(this.newList);
        if (this.oldDataFile != null) {
            jarListComparator.compare(jarList.getJars(), this.newList.getJars());
            if (!jarListComparator.getAdded().isEmpty()) {
                this.changed = true;
                this.writer.write("<div class=\"c1_added\">Added</div>");
                this.writeCompList(jarListComparator.getAdded(), "added");
            }
            if (!jarListComparator.getRemoved().isEmpty()) {
                this.changed = true;
                this.writer.write("<div class=\"c1_removed\">Removed</div>");
                this.writeCompList(jarListComparator.getRemoved(), "removed");
            }
        }
        this.writer.write("</div>");
        this.writer.writeReportEnd();
    }

    private void writeCompList(List<JarEntry> list, String string) throws Exception {
        this.writer.write("<table width=\"100%\">");
        this.writer.write("<tr>");
        this.writer.writeTh(string, "20%", "Jar");
        this.writer.writeTh(string, "15%", "Version");
        this.writer.writeTh(string, "25%", "Vendor");
        this.writer.writeTh(string, "40%", "Title");
        this.writer.write("</tr>");
        for (JarEntry jarEntry : list) {
            this.writer.write("<tr>");
            this.writer.writeElement("td", string, jarEntry.fileName);
            this.writer.writeElement("td", string, jarEntry.version);
            this.writer.writeElement("td", string, jarEntry.vendor);
            this.writer.writeElement("td", string, jarEntry.title);
            this.writer.write("</tr>");
        }
        this.writer.write("</table>");
    }

    private void writeJarList(JarList jarList) throws Exception {
        this.writer.write("<table width=\"100%\">");
        this.writer.write("<tr>");
        this.writer.writeTh(null, "15%", "Jar");
        this.writer.writeTh(null, "30%", "Info");
        this.writer.writeTh(null, "55%", "References");
        this.writer.write("</tr>");
        for (Map.Entry<String, JarEntry> entry : jarList.getJars().entrySet()) {
            String string = entry.getKey();
            JarEntry jarEntry = entry.getValue();
            jarEntry.sort();
            this.writer.write("<tr>");
            this.writer.write("<td>");
            this.writer.writeElementStart("div", "jar_name");
            this.writer.write(string);
            this.writer.writeElementEnd("div");
            if (jarEntry.version != null) {
                this.writer.writeElementStart("div", "jar_info");
                this.writer.write("<b>Version:</b> " + jarEntry.version);
                this.writer.writeElementEnd("div");
            }
            this.writer.write("</td>");
            this.writer.write("<td>");
            if (jarEntry.vendor != null) {
                this.writer.writeElementStart("div", "jar_info");
                this.writer.write("<b>Vendor:</b> " + jarEntry.vendor);
                this.writer.writeElementEnd("div");
            }
            if (jarEntry.title != null) {
                this.writer.writeElementStart("div", "jar_info");
                this.writer.write("<b>Title:</b> " + jarEntry.title);
                this.writer.writeElementEnd("div");
            }
            if (jarEntry.url != null) {
                this.writer.writeElementStart("div", "jar_info");
                this.writer.write("<b>URL:</b> " + jarEntry.url);
                this.writer.writeElementEnd("div");
            }
            this.writer.writeElementEnd("td");
            this.writer.write("<td>");
            for (JarEntry.RefEntry refEntry : jarEntry.refList) {
                this.writer.write("<div class=\"jar_ref\">");
                this.writer.write("<div class=\"jar_ref_rpm\">");
                this.writer.write(refEntry.rpmPath);
                this.writer.write("</div>");
                this.writer.write(refEntry.jarPath);
                this.writer.write("</div>");
            }
            this.writer.write("</td>");
            this.writer.write("</tr>");
        }
        this.writer.write("</table>");
    }
}

