/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.tpp.report;

import com.ericsson.tpp.report.CsvReportGenerator;
import com.ericsson.tpp.report.JarReportGenerator;
import com.ericsson.tpp.report.RpmReportGenerator;
import com.ericsson.tpp.util.Configuration;
import java.io.File;

public class ReportGenerator {
    private File oldDataFile;
    private File newDataFile;
    private File reportDir;
    private boolean changed = false;

    public ReportGenerator(Configuration configuration, File file, File file2) throws Exception {
        this.oldDataFile = file;
        this.newDataFile = file2;
        this.reportDir = new File(configuration.getReportDir());
        this.reportDir.mkdirs();
    }

    public boolean changed() {
        return this.changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        RpmReportGenerator rpmReportGenerator = null;
        File file = new File(this.reportDir, "RpmReport.html");
        System.out.println("Generating RPM report...");
        System.out.println("New data file: " + this.newDataFile.getAbsolutePath());
        System.out.println("Old data file: " + (this.oldDataFile == null ? "N/A" : this.oldDataFile.getAbsolutePath()));
        System.out.println("Report file: " + file.getAbsolutePath());
        try {
            rpmReportGenerator = new RpmReportGenerator(this.oldDataFile, this.newDataFile, file);
            rpmReportGenerator.generate();
            System.out.println("done");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        finally {
            rpmReportGenerator.close();
        }
        file = new File(this.reportDir, "JarReport.html");
        System.out.println("Generating JAR report...");
        System.out.println("New data file: " + this.newDataFile.getAbsolutePath());
        System.out.println("Old data file: " + (this.oldDataFile == null ? "N/A" : this.oldDataFile.getAbsolutePath()));
        System.out.println("Report file: " + file.getAbsolutePath());
        JarReportGenerator jarReportGenerator = null;
        try {
            jarReportGenerator = new JarReportGenerator(this.oldDataFile, this.newDataFile, file);
            jarReportGenerator.generate();
            System.out.println("done");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        finally {
            jarReportGenerator.close();
        }
        file = new File(this.reportDir, "CsvReport.csv");
        System.out.println("Generating CSV report...");
        System.out.println("New data file: " + this.newDataFile.getAbsolutePath());
        System.out.println("Report file: " + file.getAbsolutePath());
        CsvReportGenerator csvReportGenerator = null;
        try {
            csvReportGenerator = new CsvReportGenerator(jarReportGenerator.getNewJarList(), file);
            csvReportGenerator.generate();
            System.out.println("done");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        finally {
            csvReportGenerator.close();
        }
        this.changed = jarReportGenerator.changed();
    }
}

