/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.tpp.report;

import com.ericsson.tpp.RpmInfo;
import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ReportRpmList {
    private Map<String, RpmInfo> nonEriccsonRpms = new TreeMap<String, RpmInfo>();
    private Map<String, RpmInfo> ericcsonRpms = new TreeMap<String, RpmInfo>();
    private String timestamp;
    private DataHandler saxHandler = new DataHandler(this);

    public Map<String, RpmInfo> getNonEriccsonRpms() {
        return this.nonEriccsonRpms;
    }

    public Map<String, RpmInfo> getEriccsonRpms() {
        return this.ericcsonRpms;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void parse(File file) throws Exception {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        sAXParser.parse(file, (DefaultHandler)this.saxHandler);
        RpmInfo.FileNameComparator fileNameComparator = new RpmInfo.FileNameComparator();
    }

    private static class DataHandler
    extends DefaultHandler {
        private ReportRpmList list;

        public DataHandler(ReportRpmList reportRpmList) {
            this.list = reportRpmList;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if ("rpms".equals(string3)) {
                this.list.timestamp = attributes.getValue("timestamp");
            } else if ("rpm".equals(string3)) {
                String string4 = attributes.getValue("vendor");
                if (string4 == null) {
                    string4 = "";
                }
                RpmInfo rpmInfo = new RpmInfo();
                rpmInfo.fileName = attributes.getValue("file");
                rpmInfo.vendor = string4;
                rpmInfo.license = attributes.getValue("license");
                rpmInfo.url = attributes.getValue("url");
                String string5 = string4.toLowerCase();
                if (string5.contains("tandberg") || string5.contains("ericsson")) {
                    this.list.ericcsonRpms.put(rpmInfo.fileName, rpmInfo);
                } else {
                    this.list.nonEriccsonRpms.put(rpmInfo.fileName, rpmInfo);
                }
            }
        }
    }
}

