/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.tpp.report;

import com.ericsson.tpp.RpmInfo;
import com.ericsson.tpp.report.HtmlWriter;
import com.ericsson.tpp.report.ReportRpmList;
import com.ericsson.tpp.report.RpmListComparator;
import java.io.File;
import java.util.Collection;

public class RpmReportGenerator {
    private File oldDataFile;
    private File newDataFile;
    private File reportFile;
    private boolean changed = false;
    private HtmlWriter writer;

    public RpmReportGenerator(File file, File file2, File file3) {
        this.oldDataFile = file;
        this.newDataFile = file2;
        this.reportFile = file3;
    }

    public boolean changed() {
        return this.changed;
    }

    public void close() {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    public void generate() throws Exception {
        if (this.newDataFile == null) {
            throw new Exception("New data file is null");
        }
        ReportRpmList reportRpmList = new ReportRpmList();
        reportRpmList.parse(this.newDataFile);
        ReportRpmList reportRpmList2 = null;
        RpmListComparator rpmListComparator = null;
        if (this.oldDataFile != null) {
            reportRpmList2 = new ReportRpmList();
            reportRpmList2.parse(this.oldDataFile);
            rpmListComparator = new RpmListComparator();
        }
        this.writer = new HtmlWriter(this.reportFile);
        this.writer.writeReportStart();
        this.writer.writeElementStart("div", "header_box");
        this.writer.writeElement("div", "header", "3PP RPMS");
        this.writer.writeElementStart("div", "header2");
        this.writer.write("<b>Created on</b> " + reportRpmList.getTimestamp());
        this.writer.writeElementEnd("div");
        if (this.oldDataFile != null) {
            this.writer.writeElementStart("div", "header2");
            this.writer.write("<b>Compared to</b> " + reportRpmList2.getTimestamp());
            this.writer.writeElementEnd("div");
        }
        this.writer.writeElementEnd("div");
        this.writer.write("<div class=\"c1\">");
        this.writer.write("<div class=\"c1_hdr\">Non-Ericsson RPMs</div>");
        this.writeRpmList(reportRpmList.getNonEriccsonRpms().values(), null);
        if (this.oldDataFile != null) {
            rpmListComparator.compare(reportRpmList2.getNonEriccsonRpms(), reportRpmList.getNonEriccsonRpms());
            if (!rpmListComparator.getAdded().isEmpty()) {
                this.changed = true;
                this.writer.write("<div class=\"c1_added\">Added</div>");
                this.writeRpmList(rpmListComparator.getAdded(), "added");
            }
            if (!rpmListComparator.getRemoved().isEmpty()) {
                this.changed = true;
                this.writer.write("<div class=\"c1_removed\">Removed</div>");
                this.writeRpmList(rpmListComparator.getRemoved(), "removed");
            }
        }
        this.writer.write("</div>");
        this.writer.write("<div class=\"c1\">");
        this.writer.write("<div class=\"c1_hdr\">Ericsson RPMs</div>");
        this.writeRpmList(reportRpmList.getEriccsonRpms().values(), null);
        if (this.oldDataFile != null) {
            rpmListComparator.compare(reportRpmList2.getEriccsonRpms(), reportRpmList.getEriccsonRpms());
            if (!rpmListComparator.getAdded().isEmpty()) {
                this.changed = true;
                this.writer.write("<div class=\"c1_added\">Added</div>");
                this.writeRpmList(rpmListComparator.getAdded(), "added");
            }
            if (!rpmListComparator.getRemoved().isEmpty()) {
                this.changed = true;
                this.writer.write("<div class=\"c1_removed\">Removed</div>");
                this.writeRpmList(rpmListComparator.getRemoved(), "removed");
            }
        }
        this.writer.write("</div>");
        this.writer.writeReportEnd();
    }

    private void writeRpmList(Collection<RpmInfo> collection, String string) throws Exception {
        this.writer.write("<table width=\"100%\">");
        this.writer.write("<tr>");
        this.writer.writeTh(string, "35%", "RPM");
        this.writer.writeTh(string, "20%", "Vendor");
        this.writer.writeTh(string, "25%", "License");
        this.writer.writeTh(string, "20%", "URL");
        this.writer.write("</tr>");
        for (RpmInfo rpmInfo : collection) {
            this.writer.write("<tr>");
            this.writer.writeElement("td", string, rpmInfo.fileName);
            this.writer.writeElement("td", string, rpmInfo.vendor);
            this.writer.writeElement("td", string, rpmInfo.license);
            this.writer.writeElement("td", string, rpmInfo.url);
            this.writer.write("</tr>");
        }
        this.writer.write("</table>");
    }
}

